/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.management.AccessConstraintKey;
import org.jboss.as.controller.access.management.AccessConstraintUtilization;

class AccessConstraintUtilizationImpl
implements AccessConstraintUtilization {
    private final AccessConstraintKey constraint;
    private final PathAddress pathAddress;
    private volatile Boolean resourceConstrained;
    private Set<String> attributes = Collections.synchronizedSet(new HashSet());
    private Set<String> operations = Collections.synchronizedSet(new HashSet());

    public AccessConstraintUtilizationImpl(AccessConstraintKey constraint, PathAddress pathAddress) {
        this.constraint = constraint;
        this.pathAddress = pathAddress;
    }

    @Override
    public PathAddress getPathAddress() {
        return this.pathAddress;
    }

    @Override
    public boolean isEntireResourceConstrained() {
        Boolean constrained = this.resourceConstrained;
        return constrained == null ? false : constrained;
    }

    @Override
    public Set<String> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    @Override
    public Set<String> getOperations() {
        return Collections.unmodifiableSet(this.operations);
    }

    public int hashCode() {
        return this.pathAddress.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof AccessConstraintUtilizationImpl && this.pathAddress.equals(((AccessConstraintUtilizationImpl)obj).pathAddress);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{pathAddress=" + String.valueOf(this.pathAddress) + "}";
    }

    void setResourceConstrained(boolean resourceConstrained) {
        this.resourceConstrained = resourceConstrained;
    }

    void addAttribute(String attribute) {
        this.attributes.add(attribute);
    }

    void addOperation(String operation) {
        this.operations.add(operation);
    }
}

