/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;
import org.wildfly.clustering.server.GroupMember;

@MessageLogger(projectCode="WFLYCLSN", length=4)
public interface SingletonLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.wildfly.clustering.singleton.server";
    public static final SingletonLogger ROOT_LOGGER = (SingletonLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), SingletonLogger.class, (String)"org.wildfly.clustering.singleton.server");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="This node will now operate as the singleton provider of the %s service")
    public void startSingleton(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="This node will no longer operate as the singleton provider of the %s service")
    public void stopSingleton(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="%s elected as the singleton provider of the %s service")
    public void elected(String var1, String var2);

    @Message(id=4, value="No response received from primary provider of the %s service, retrying...")
    public IllegalStateException noResponseFromPrimary(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Failed to start %s service")
    public void serviceStartFailed(@Cause StartException var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Failed to reach quorum of %2$d for %1$s service. No primary singleton provider will be elected.")
    public void quorumNotReached(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.")
    public void quorumJustReached(String var1, int var2);

    @Message(id=8, value="Detected multiple primary providers for %s service: %s")
    public IllegalArgumentException multiplePrimaryProvidersDetected(String var1, Collection<GroupMember> var2);

    @Message(id=9, value="Singleton service %s is not started.")
    public IllegalStateException notStarted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="No node was elected as the singleton provider of the %s service")
    public void noPrimaryElected(String var1);

    @Message(id=11, value="Specified quorum %d must be greater than zero")
    public IllegalArgumentException invalidQuorum(int var1);
}

