/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface ElasticsearchSearchAggregation<A>
extends SearchAggregation<A> {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Extractor<A> request(AggregationRequestContext var1, AggregationKey<?> var2, JsonObject var3);

    public Set<String> indexNames();

    public static <A> ElasticsearchSearchAggregation<A> from(ElasticsearchSearchIndexScope<?> scope, SearchAggregation<A> aggregation) {
        if (!(aggregation instanceof ElasticsearchSearchAggregation)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherAggregations(aggregation);
        }
        ElasticsearchSearchAggregation casted = (ElasticsearchSearchAggregation)aggregation;
        if (!CollectionHelper.isSubset((Set)scope.hibernateSearchIndexNames(), casted.indexNames())) {
            throw log.aggregationDefinedOnDifferentIndexes(aggregation, casted.indexNames(), scope.hibernateSearchIndexNames(), CollectionHelper.notInTheOtherSet((Set)scope.hibernateSearchIndexNames(), casted.indexNames()));
        }
        return casted;
    }

    public static interface Extractor<T> {
        public T extract(JsonObject var1, AggregationExtractContext var2);
    }
}

