/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public final class JdkDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final String[] JDK_NAMING_MODULES = new String[]{"jdk.naming.dns", "jdk.naming.rmi"};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String moduleName : JDK_NAMING_MODULES) {
            try {
                moduleLoader.loadModule(moduleName);
                moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)moduleName).build());
            }
            catch (ModuleLoadException ex) {
                NamingLogger.ROOT_LOGGER.debugf("Module not found: %s", moduleName);
            }
        }
    }
}

