/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.TemporalType;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.ExtractFunction;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleExtractFunction
extends ExtractFunction {
    public OracleExtractFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super(dialect, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        new PatternRenderer(this.extractPattern(sqlAstArguments)).render(sqlAppender, sqlAstArguments, walker);
    }

    private String extractPattern(List<? extends SqlAstNode> sqlAstArguments) {
        ExtractUnit field = (ExtractUnit)sqlAstArguments.get(0);
        TemporalUnit unit = field.getUnit();
        if (unit == TemporalUnit.EPOCH) {
            TemporalType temporalType;
            Expression expression = (Expression)sqlAstArguments.get(1);
            JdbcMappingContainer type = expression.getExpressionType();
            TemporalType temporalType2 = temporalType = type != null ? TypeConfiguration.getSqlTemporalType(type) : null;
            if (temporalType == TemporalType.DATE) {
                return "trunc((cast(from_tz(cast(?2 as timestamp),'UTC') as date) - date '1970-1-1')*86400)";
            }
        }
        return this.dialect.extractPattern(unit);
    }
}

