/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemRootDefinition;
import org.jboss.as.connector.subsystems.datasources.DsParser;
import org.jboss.as.connector.subsystems.datasources.Element;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DataSourcesExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "datasources";
    private static final String RESOURCE_NAME = DataSourcesExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)7, (int)2, (int)0);

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, DataSourcesExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Initializing Datasources Extension", new Object[0]);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)DataSourcesSubsystemRootDefinition.createInstance(registerRuntimeOnly));
        subsystem.registerXMLElementWriter((XMLElementWriter)new DataSourceSubsystemParser());
        if (registerRuntimeOnly) {
            subsystem.registerDeploymentModel((ResourceDefinition)DataSourcesSubsystemRootDefinition.createDeployedInstance(registerRuntimeOnly));
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_1_1.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_1_2.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_2_0.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_3_0.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_4_0.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_5_0.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_6_0.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_7_0.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_7_1.getUriString(), DataSourceSubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.DATASOURCES_7_2.getUriString(), DataSourceSubsystemParser::new);
    }

    public static final class DataSourceSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private static final SimpleAttributeDefinition[] COMMON_SIMPLE_DS_ATTRIBUTES = new SimpleAttributeDefinition[]{Constants.DATASOURCE_DRIVER, Constants.URL_DELIMITER, Constants.URL_SELECTOR_STRATEGY_CLASS_NAME, Constants.NEW_CONNECTION_SQL, Constants.TRANSACTION_ISOLATION};
        private static final SimpleAttributeDefinition[] POOL_ATTRIBUTES = new SimpleAttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE, org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY, Constants.ALLOW_MULTIPLE_USERS};
        private static final SimpleAttributeDefinition[] XA_POOL_ATTRIBUTES = new SimpleAttributeDefinition[]{Constants.SAME_RM_OVERRIDE, Constants.INTERLEAVING, Constants.NO_TX_SEPARATE_POOL, Constants.PAD_XID, Constants.WRAP_XA_RESOURCE};
        private static final SimpleAttributeDefinition[] TIMEOUT_ATTRIBUTES = new SimpleAttributeDefinition[]{Constants.SET_TX_QUERY_TIMEOUT, org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES, Constants.QUERY_TIMEOUT, Constants.USE_TRY_LOCK, Constants.ALLOCATION_RETRY, Constants.ALLOCATION_RETRY_WAIT_MILLIS, Constants.XA_RESOURCE_TIMEOUT};
        private static final SimpleAttributeDefinition[] RECOVERY_ATTRIBUTES = new SimpleAttributeDefinition[]{Constants.RECOVERY_SECURITY_DOMAIN, Constants.RECOVERY_AUTHENTICATION_CONTEXT, Constants.RECOVERY_CREDENTIAL_REFERENCE, Constants.RECOVERY_ELYTRON_ENABLED};
        private static final SimpleAttributeDefinition[] SECURITY_ATTRIBUTES = new SimpleAttributeDefinition[]{Constants.SECURITY_DOMAIN, Constants.AUTHENTICATION_CONTEXT, Constants.CREDENTIAL_REFERENCE, Constants.ELYTRON_ENABLED};
        private static final SimpleAttributeDefinition[] STATEMENT_ATTRIBUTES = new SimpleAttributeDefinition[]{Constants.TRACK_STATEMENTS, Constants.PREPARED_STATEMENTS_CACHE_SIZE, Constants.SHARE_PREPARED_STATEMENTS};

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            writer.writeStartElement(DataSourcesExtension.SUBSYSTEM_NAME);
            if (node.hasDefined("data-source") || node.hasDefined("xa-data-source")) {
                if (node.hasDefined("data-source")) {
                    this.writeDS(writer, false, node.get("data-source"));
                }
                if (node.hasDefined("xa-data-source")) {
                    this.writeDS(writer, true, node.get("xa-data-source"));
                }
            }
            if (node.hasDefined("jdbc-driver")) {
                writer.writeStartElement(DataSources.Tag.DRIVERS.getLocalName());
                ModelNode drivers = node.get("jdbc-driver");
                for (String driverName : drivers.keys()) {
                    ModelNode driver = drivers.get(driverName);
                    writer.writeStartElement(DataSources.Tag.DRIVER.getLocalName());
                    writer.writeAttribute(Driver.Attribute.NAME.getLocalName(), driverName);
                    if (this.has(driver, Constants.DRIVER_MODULE_NAME.getName())) {
                        Object moduleName = driver.get(Constants.DRIVER_MODULE_NAME.getName()).asString();
                        if (this.has(driver, Constants.MODULE_SLOT.getName())) {
                            moduleName = (String)moduleName + ":" + driver.get(Constants.MODULE_SLOT.getName()).asString();
                        }
                        writer.writeAttribute(Driver.Attribute.MODULE.getLocalName(), (String)moduleName);
                    }
                    this.writeAttributeIfHas(writer, driver, Driver.Attribute.MAJOR_VERSION, Constants.DRIVER_MAJOR_VERSION.getName());
                    this.writeAttributeIfHas(writer, driver, Driver.Attribute.MINOR_VERSION, Constants.DRIVER_MINOR_VERSION.getName());
                    this.writeElementIfHas(writer, driver, Driver.Tag.DRIVER_CLASS.getLocalName(), Constants.DRIVER_CLASS_NAME.getName());
                    this.writeElementIfHas(writer, driver, Driver.Tag.XA_DATASOURCE_CLASS.getLocalName(), Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName());
                    this.writeElementIfHas(writer, driver, Driver.Tag.DATASOURCE_CLASS.getLocalName(), Constants.DRIVER_DATASOURCE_CLASS_NAME.getName());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeDS(XMLExtendedStreamWriter writer, boolean isXADataSource, ModelNode datasources) throws XMLStreamException {
            for (String dsName : datasources.keys()) {
                boolean statementRequired;
                boolean timeoutRequired;
                boolean validationRequired;
                boolean securityRequired;
                boolean recoveryRequired;
                boolean poolRequired;
                ModelNode dataSourceNode = datasources.get(dsName);
                writer.writeStartElement(isXADataSource ? DataSources.Tag.XA_DATASOURCE.getLocalName() : DataSources.Tag.DATASOURCE.getLocalName());
                Constants.JTA.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                writer.writeAttribute("pool-name", dsName);
                Constants.ENABLED.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.SPY.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.USE_CCM.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.CONNECTABLE.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.TRACKING.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.MCP.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.ENLISTMENT_TRACE.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                Constants.STATISTICS_ENABLED.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                if (!isXADataSource) {
                    this.marshallAsElements(dataSourceNode, writer, Constants.CONNECTION_URL, Constants.DRIVER_CLASS, Constants.DATASOURCE_CLASS);
                    if (dataSourceNode.hasDefined(Constants.CONNECTION_PROPERTIES.getName())) {
                        for (Property connectionProperty : dataSourceNode.get(Constants.CONNECTION_PROPERTIES.getName()).asPropertyList()) {
                            this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().get("value").asString(), DataSource.Tag.CONNECTION_PROPERTY.getLocalName());
                        }
                    }
                }
                if (isXADataSource) {
                    if (dataSourceNode.hasDefined(Constants.XADATASOURCE_PROPERTIES.getName())) {
                        for (Property prop : dataSourceNode.get(Constants.XADATASOURCE_PROPERTIES.getName()).asPropertyList()) {
                            this.writeProperty(writer, dataSourceNode, prop.getName(), prop.getValue().get("value").asString(), XaDataSource.Tag.XA_DATASOURCE_PROPERTY.getLocalName());
                        }
                    }
                    this.marshallAsElements(dataSourceNode, writer, Constants.XA_DATASOURCE_CLASS, Constants.URL_PROPERTY);
                }
                this.marshallAsElements(dataSourceNode, writer, COMMON_SIMPLE_DS_ATTRIBUTES);
                boolean bl = poolRequired = this.isAnyRequired(dataSourceNode, (AttributeDefinition[])POOL_ATTRIBUTES) || Constants.CONNECTION_LISTENER_CLASS.isMarshallable(dataSourceNode) || Constants.CONNECTION_LISTENER_PROPERTIES.isMarshallable(dataSourceNode);
                if (isXADataSource) {
                    poolRequired = poolRequired || this.isAnyRequired(dataSourceNode, (AttributeDefinition[])XA_POOL_ATTRIBUTES);
                }
                boolean capacityRequired = this.isAnyRequired(dataSourceNode, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES});
                boolean bl2 = poolRequired = poolRequired || capacityRequired;
                if (poolRequired) {
                    writer.writeStartElement(isXADataSource ? XaDataSource.Tag.XA_POOL.getLocalName() : DataSource.Tag.POOL.getLocalName());
                    this.marshallAsElements(dataSourceNode, writer, POOL_ATTRIBUTES);
                    if (dataSourceNode.hasDefined(Constants.CONNECTION_LISTENER_CLASS.getName())) {
                        writer.writeStartElement(DsPool.Tag.CONNECTION_LISTENER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.CONNECTION_LISTENER_CLASS.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.CONNECTION_LISTENER_PROPERTIES.getName())) {
                            for (Object connectionProperty : dataSourceNode.get(Constants.CONNECTION_LISTENER_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    if (capacityRequired) {
                        writer.writeStartElement(DsPool.Tag.CAPACITY.getLocalName());
                        if (dataSourceNode.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.getName())) {
                            writer.writeStartElement(Capacity.Tag.INCREMENTER.getLocalName());
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        }
                        if (dataSourceNode.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.getName())) {
                            writer.writeStartElement(Capacity.Tag.DECREMENTER.getLocalName());
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                            org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.marshallAsElement(dataSourceNode, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (isXADataSource) {
                        this.marshallAsElements(dataSourceNode, writer, XA_POOL_ATTRIBUTES);
                    }
                    writer.writeEndElement();
                }
                if ((recoveryRequired = this.isAnyRequired(dataSourceNode, new AttributeDefinition[]{Constants.RECOVERY_USERNAME, Constants.RECOVERY_PASSWORD, Constants.RECOVERY_SECURITY_DOMAIN, Constants.RECOVERY_ELYTRON_ENABLED, Constants.RECOVER_PLUGIN_CLASSNAME, Constants.RECOVERY_CREDENTIAL_REFERENCE, Constants.NO_RECOVERY, Constants.RECOVER_PLUGIN_PROPERTIES})) && isXADataSource) {
                    writer.writeStartElement(XaDataSource.Tag.RECOVERY.getLocalName());
                    Constants.NO_RECOVERY.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                    if (this.hasAnyOf(dataSourceNode, new SimpleAttributeDefinition[]{Constants.RECOVERY_USERNAME, Constants.RECOVERY_PASSWORD, Constants.RECOVERY_SECURITY_DOMAIN, Constants.RECOVERY_ELYTRON_ENABLED, Constants.RECOVERY_CREDENTIAL_REFERENCE})) {
                        writer.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                        Constants.RECOVERY_USERNAME.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                        Constants.RECOVERY_PASSWORD.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                        this.marshallAsElements(dataSourceNode, writer, RECOVERY_ATTRIBUTES);
                        writer.writeEndElement();
                    }
                    if (this.hasAnyOf(dataSourceNode, Constants.RECOVER_PLUGIN_CLASSNAME)) {
                        writer.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.RECOVER_PLUGIN_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.RECOVER_PLUGIN_PROPERTIES.getName())) {
                            Object connectionProperty;
                            connectionProperty = dataSourceNode.get(Constants.RECOVER_PLUGIN_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty.hasNext()) {
                                Property connectionProperty2 = (Property)connectionProperty.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty2.getName(), connectionProperty2.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (securityRequired = this.isAnyRequired(dataSourceNode, new AttributeDefinition[]{Constants.USERNAME, Constants.PASSWORD, Constants.CREDENTIAL_REFERENCE, Constants.SECURITY_DOMAIN, Constants.ELYTRON_ENABLED, Constants.REAUTH_PLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES})) {
                    writer.writeStartElement(DataSource.Tag.SECURITY.getLocalName());
                    Constants.USERNAME.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                    Constants.PASSWORD.marshallAsAttribute(dataSourceNode, (XMLStreamWriter)writer);
                    this.marshallAsElements(dataSourceNode, writer, SECURITY_ATTRIBUTES);
                    if (dataSourceNode.hasDefined(Constants.REAUTH_PLUGIN_CLASSNAME.getName())) {
                        writer.writeStartElement(DsSecurity.Tag.REAUTH_PLUGIN.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.REAUTH_PLUGIN_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.REAUTHPLUGIN_PROPERTIES.getName())) {
                            for (Object connectionProperty3 : dataSourceNode.get(Constants.REAUTHPLUGIN_PROPERTIES.getName()).asPropertyList()) {
                                this.writeProperty(writer, dataSourceNode, connectionProperty3.getName(), connectionProperty3.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (validationRequired = this.isAnyRequired(dataSourceNode, new AttributeDefinition[]{Constants.VALID_CONNECTION_CHECKER_CLASSNAME, Constants.VALID_CONNECTION_CHECKER_MODULE, Constants.CHECK_VALID_CONNECTION_SQL, Constants.VALIDATE_ON_MATCH, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL, Constants.STALE_CONNECTION_CHECKER_CLASSNAME, Constants.STALE_CONNECTION_CHECKER_MODULE, Constants.STALE_CONNECTION_CHECKER_PROPERTIES, Constants.EXCEPTION_SORTER_CLASSNAME, Constants.EXCEPTION_SORTER_MODULE, Constants.EXCEPTION_SORTER_PROPERTIES})) {
                    Property connectionProperty;
                    Object connectionProperty3;
                    writer.writeStartElement(DataSource.Tag.VALIDATION.getLocalName());
                    if (dataSourceNode.hasDefined(Constants.VALID_CONNECTION_CHECKER_CLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.VALID_CONNECTION_CHECKER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.VALID_CONNECTION_CHECKER_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.VALID_CONNECTION_CHECKER_MODULE.getName())) {
                            writer.writeAttribute(Extension.Attribute.MODULE.getLocalName(), dataSourceNode.get(Constants.VALID_CONNECTION_CHECKER_MODULE.getName()).asString());
                        }
                        if (dataSourceNode.hasDefined(Constants.VALID_CONNECTION_CHECKER_PROPERTIES.getName())) {
                            connectionProperty3 = dataSourceNode.get(Constants.VALID_CONNECTION_CHECKER_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty3.hasNext()) {
                                connectionProperty = (Property)connectionProperty3.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    this.marshallAsElements(dataSourceNode, writer, Constants.CHECK_VALID_CONNECTION_SQL, Constants.VALIDATE_ON_MATCH, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL);
                    if (dataSourceNode.hasDefined(Constants.STALE_CONNECTION_CHECKER_CLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.STALE_CONNECTION_CHECKER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.STALE_CONNECTION_CHECKER_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.STALE_CONNECTION_CHECKER_MODULE.getName())) {
                            writer.writeAttribute(Extension.Attribute.MODULE.getLocalName(), dataSourceNode.get(Constants.STALE_CONNECTION_CHECKER_MODULE.getName()).asString());
                        }
                        if (dataSourceNode.hasDefined(Constants.STALE_CONNECTION_CHECKER_PROPERTIES.getName())) {
                            connectionProperty3 = dataSourceNode.get(Constants.STALE_CONNECTION_CHECKER_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty3.hasNext()) {
                                connectionProperty = (Property)connectionProperty3.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    if (dataSourceNode.hasDefined(Constants.EXCEPTION_SORTER_CLASSNAME.getName())) {
                        writer.writeStartElement(Validation.Tag.EXCEPTION_SORTER.getLocalName());
                        writer.writeAttribute(Extension.Attribute.CLASS_NAME.getLocalName(), dataSourceNode.get(Constants.EXCEPTION_SORTER_CLASSNAME.getName()).asString());
                        if (dataSourceNode.hasDefined(Constants.EXCEPTION_SORTER_MODULE.getName())) {
                            writer.writeAttribute(Extension.Attribute.MODULE.getLocalName(), dataSourceNode.get(Constants.EXCEPTION_SORTER_MODULE.getName()).asString());
                        }
                        if (dataSourceNode.hasDefined(Constants.EXCEPTION_SORTER_PROPERTIES.getName())) {
                            connectionProperty3 = dataSourceNode.get(Constants.EXCEPTION_SORTER_PROPERTIES.getName()).asPropertyList().iterator();
                            while (connectionProperty3.hasNext()) {
                                connectionProperty = (Property)connectionProperty3.next();
                                this.writeProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (timeoutRequired = this.isAnyRequired(dataSourceNode, (AttributeDefinition[])TIMEOUT_ATTRIBUTES)) {
                    writer.writeStartElement(DataSource.Tag.TIMEOUT.getLocalName());
                    this.marshallAsElements(dataSourceNode, writer, TIMEOUT_ATTRIBUTES);
                    writer.writeEndElement();
                }
                if (statementRequired = this.hasAnyOf(dataSourceNode, STATEMENT_ATTRIBUTES)) {
                    writer.writeStartElement(DataSource.Tag.STATEMENT.getLocalName());
                    this.marshallAsElements(dataSourceNode, writer, STATEMENT_ATTRIBUTES);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, Driver.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value, String localName) throws XMLStreamException {
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                String content = node.get(identifier).asString();
                if (content.indexOf(10) > -1) {
                    writer.writeCharacters(content);
                } else {
                    char[] chars = content.toCharArray();
                    writer.writeCharacters(chars, 0, chars.length);
                }
                writer.writeEndElement();
            }
        }

        private void marshallAsElements(ModelNode node, XMLExtendedStreamWriter writer, SimpleAttributeDefinition ... names) throws XMLStreamException {
            for (SimpleAttributeDefinition attr : names) {
                attr.marshallAsElement(node, (XMLStreamWriter)writer);
            }
        }

        private boolean hasAnyOf(ModelNode node, SimpleAttributeDefinition ... names) {
            for (SimpleAttributeDefinition current : names) {
                if (!this.has(node, current.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private boolean isAnyRequired(ModelNode node, AttributeDefinition ... names) {
            return Arrays.stream(names).anyMatch(name -> name.isMarshallable(node));
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", DataSourcesExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            try {
                String localName = null;
                localName = reader.getLocalName();
                Element element = Element.forName(reader.getLocalName());
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.tracef("%s -> %s", localName, (Object)element);
                switch (element) {
                    case SUBSYSTEM: {
                        DsParser parser = new DsParser();
                        parser.parse(reader, list, address);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

