/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.activemq.artemis.wildfly.integration.recovery;

import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXAResourceRecovery;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildFlyActiveMQXAResourceRecovery
extends ActiveMQXAResourceRecovery
implements XAResourceRecovery {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean trace = logger.isTraceEnabled();
    private boolean hasMore;
    private ActiveMQXAResourceWrapper res;

    public WildFlyActiveMQXAResourceRecovery() {
        if (this.trace) {
            logger.trace("Constructing ActiveMQXAResourceRecovery");
        }
    }

    public boolean initialise(String config) {
        if (this.trace) {
            logger.trace(String.valueOf((Object)this) + " intialise: " + config);
        }
        String[] configs = config.split(";");
        XARecoveryConfig[] xaRecoveryConfigs = new XARecoveryConfig[configs.length];
        for (String s : configs) {
            ConfigParser parser = new ConfigParser(s);
            String connectorFactoryClassName = parser.getConnectorFactoryClassName();
            Map<String, Object> connectorParams = parser.getConnectorParameters();
            String username = parser.getUsername();
            String password = parser.getPassword();
            TransportConfiguration transportConfiguration = new TransportConfiguration(connectorFactoryClassName, connectorParams);
            xaRecoveryConfigs[i] = new XARecoveryConfig(false, new TransportConfiguration[]{transportConfiguration}, username, password, null);
        }
        this.res = new ActiveMQXAResourceWrapper(xaRecoveryConfigs);
        if (this.trace) {
            logger.trace(String.valueOf((Object)this) + " initialised");
        }
        return true;
    }

    public boolean hasMoreResources() {
        if (this.trace) {
            logger.trace(String.valueOf((Object)this) + " hasMoreResources");
        }
        this.hasMore = !this.hasMore;
        return this.hasMore;
    }

    public XAResource getXAResource() {
        if (this.trace) {
            logger.trace(String.valueOf((Object)this) + " getXAResource");
        }
        return this.res;
    }

    public XAResource[] getXAResources() {
        return new XAResource[]{this.res};
    }

    protected void finalize() {
        this.res.close();
    }

    public static class ConfigParser {
        private final String connectorFactoryClassName;
        private final Map<String, Object> connectorParameters;
        private String username;
        private String password;

        public ConfigParser(String config) {
            if (config == null || config.length() == 0) {
                throw new IllegalArgumentException("Must specify provider connector factory class name in config");
            }
            String[] strings = config.split(",");
            if (strings.length < 1) {
                throw new IllegalArgumentException("Must specify provider connector factory class name in config");
            }
            this.connectorFactoryClassName = strings[0].trim();
            if (strings.length >= 2) {
                this.username = strings[1].trim();
                if (this.username.length() == 0) {
                    this.username = null;
                }
                if (strings.length == 2) {
                    throw new IllegalArgumentException("If username is specified, password must be specified too");
                }
                this.password = strings[2].trim();
                if (this.password.length() == 0) {
                    this.password = null;
                }
            }
            this.connectorParameters = new HashMap<String, Object>();
            if (strings.length >= 3) {
                for (int i = 3; i < strings.length; ++i) {
                    String[] str = strings[i].split("=");
                    if (str.length != 2) continue;
                    this.connectorParameters.put(str[0].trim(), str[1].trim());
                }
            }
        }

        public String getConnectorFactoryClassName() {
            return this.connectorFactoryClassName;
        }

        public Map<String, Object> getConnectorParameters() {
            return this.connectorParameters;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

