/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.ejb.cache.timer.ImmutableScheduleExpressionBuilder;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum ImmutableScheduleExpressionMarshaller implements FieldSetMarshaller.Supplied<ImmutableScheduleExpression, ImmutableScheduleExpressionBuilder>
{
    INSTANCE;

    private static final int START_FIELD = 0;
    private static final int END_FIELD = 1;
    private static final int YEAR_FIELD = 2;
    private static final int MONTH_FIELD = 3;
    private static final int DAY_OF_MONTH_FIELD = 4;
    private static final int DAY_OF_WEEK_FIELD = 5;
    private static final int ZONE_FIELD = 6;
    private static final int HOUR_FIELD = 7;
    private static final int MINUTE_FIELD = 8;
    private static final int SECOND_FIELD = 9;
    private static final int FIELDS = 10;
    private final ImmutableScheduleExpression defaultExpression = (ImmutableScheduleExpression)this.createInitialValue().get();

    public ImmutableScheduleExpressionBuilder createInitialValue() {
        return new DefaultImmutableScheduleExpressionBuilder();
    }

    public int getFields() {
        return 10;
    }

    public ImmutableScheduleExpressionBuilder readFrom(ProtoStreamReader reader, int index, WireType type, ImmutableScheduleExpressionBuilder builder) throws IOException {
        switch (index) {
            case 0: {
                return builder.start((Instant)reader.readObject(Instant.class));
            }
            case 1: {
                return builder.end((Instant)reader.readObject(Instant.class));
            }
            case 2: {
                return builder.year(reader.readString());
            }
            case 3: {
                return builder.month(reader.readString());
            }
            case 4: {
                return builder.dayOfMonth(reader.readString());
            }
            case 5: {
                return builder.dayOfWeek(reader.readString());
            }
            case 6: {
                return builder.zone((ZoneId)reader.readObject(ZoneId.class));
            }
            case 7: {
                return builder.hour(reader.readString());
            }
            case 8: {
                return builder.minute(reader.readString());
            }
            case 9: {
                return builder.second(reader.readString());
            }
        }
        reader.skipField(type);
        return builder;
    }

    public void writeTo(ProtoStreamWriter writer, ImmutableScheduleExpression expression) throws IOException {
        String second;
        String minute;
        String hour;
        ZoneId zone;
        String dayOfWeek;
        String dayOfMonth;
        String month;
        String year;
        Instant end;
        Instant start = expression.getStart();
        if (!Objects.equals(start, this.defaultExpression.getStart())) {
            writer.writeObject(0, (Object)start);
        }
        if (!Objects.equals(end = expression.getEnd(), this.defaultExpression.getEnd())) {
            writer.writeObject(1, (Object)end);
        }
        if (!Objects.equals(year = expression.getYear(), this.defaultExpression.getYear())) {
            writer.writeString(2, year);
        }
        if (!Objects.equals(month = expression.getMonth(), this.defaultExpression.getMonth())) {
            writer.writeString(3, month);
        }
        if (!Objects.equals(dayOfMonth = expression.getDayOfMonth(), this.defaultExpression.getDayOfMonth())) {
            writer.writeString(4, dayOfMonth);
        }
        if (!Objects.equals(dayOfWeek = expression.getDayOfWeek(), this.defaultExpression.getDayOfWeek())) {
            writer.writeString(5, dayOfWeek);
        }
        if (!Objects.equals(zone = expression.getZone(), this.defaultExpression.getZone())) {
            writer.writeObject(6, (Object)zone);
        }
        if (!Objects.equals(hour = expression.getHour(), this.defaultExpression.getHour())) {
            writer.writeString(7, hour);
        }
        if (!Objects.equals(minute = expression.getMinute(), this.defaultExpression.getMinute())) {
            writer.writeString(8, minute);
        }
        if (!Objects.equals(second = expression.getSecond(), this.defaultExpression.getSecond())) {
            writer.writeString(9, second);
        }
    }

    public class DefaultImmutableScheduleExpressionBuilder
    implements ImmutableScheduleExpressionBuilder {
        private String second = "0";
        private String minute = "0";
        private String hour = "0";
        private String dayOfMonth = "*";
        private String month = "*";
        private String dayOfWeek = "*";
        private String year = "*";
        private ZoneId zone;
        private Instant start;
        private Instant end;

        @Override
        public ImmutableScheduleExpressionBuilder second(String second) {
            this.second = second;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder minute(String minute) {
            this.minute = minute;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder hour(String hour) {
            this.hour = hour;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder month(String month) {
            this.month = month;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder year(String year) {
            this.year = year;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder zone(ZoneId zone) {
            this.zone = zone;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder start(Instant start) {
            this.start = start;
            return this;
        }

        @Override
        public ImmutableScheduleExpressionBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        @Override
        public ImmutableScheduleExpression get() {
            final String second = this.second;
            final String minute = this.minute;
            final String hour = this.hour;
            final String dayOfMonth = this.dayOfMonth;
            final String month = this.month;
            final String dayOfWeek = this.dayOfWeek;
            final String year = this.year;
            final ZoneId zone = this.zone;
            final Instant start = this.start;
            final Instant end = this.end;
            return new ImmutableScheduleExpression(){

                public String getSecond() {
                    return second;
                }

                public String getMinute() {
                    return minute;
                }

                public String getHour() {
                    return hour;
                }

                public String getDayOfMonth() {
                    return dayOfMonth;
                }

                public String getMonth() {
                    return month;
                }

                public String getDayOfWeek() {
                    return dayOfWeek;
                }

                public String getYear() {
                    return year;
                }

                public ZoneId getZone() {
                    return zone;
                }

                public Instant getStart() {
                    return start;
                }

                public Instant getEnd() {
                    return end;
                }
            };
        }
    }
}

