package org.jboss.as.ee.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.vfs.VirtualFile;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.as.ee.component.ComponentIsStoppedException;
import org.jboss.logging.Logger;
import org.jboss.jandex.DotName;
import java.lang.reflect.Field;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.ee.component.ComponentInstance;
import java.lang.ClassLoader;
import java.lang.IllegalArgumentException;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.jandex.AnnotationTarget;
import javax.annotation.Generated;
import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.invocation.proxy.MethodIdentifier;
import java.lang.reflect.Method;
import java.io.IOException;
import java.lang.Exception;
import org.jboss.as.ee.component.ComponentConfiguration;
import javax.xml.stream.XMLStreamException;
import org.jboss.msc.service.ServiceName;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.concurrent.ConcurrentContext;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.jandex.MethodInfo;
import java.util.Arrays;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-01-05T12:16:25-0600")
public class EeLogger_$logger extends DelegatingBasicLogger implements EeLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EeLogger_$logger.class.getName();
    public EeLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotResolve(final String elementName, final String name) {
        super.log.logf(FQCN, WARN, null, cannotResolve$str(), elementName, name);
    }
    private static final String cannotResolve = "WFLYEE0002: Could not resolve %s %s";
    protected String cannotResolve$str() {
        return cannotResolve;
    }
    @Override
    public final void componentDestroyFailure(final Throwable cause, final ComponentInstance component) {
        super.log.logf(FQCN, WARN, cause, componentDestroyFailure$str(), component);
    }
    private static final String componentDestroyFailure = "WFLYEE0006: Failed to destroy component instance %s";
    protected String componentDestroyFailure$str() {
        return componentDestroyFailure;
    }
    @Override
    public final void componentInstallationFailure(final String name) {
        super.log.logf(FQCN, WARN, null, componentInstallationFailure$str(), name);
    }
    private static final String componentInstallationFailure = "WFLYEE0007: Not installing optional component %s due to an exception (enable DEBUG log level to see the cause)";
    protected String componentInstallationFailure$str() {
        return componentInstallationFailure;
    }
    @Override
    public final void invalidManagedBeanAbstractOrFinal(final String sectionId, final String className) {
        super.log.logf(FQCN, WARN, null, invalidManagedBeanAbstractOrFinal$str(), sectionId, className);
    }
    private static final String invalidManagedBeanAbstractOrFinal = "WFLYEE0009: [Managed Bean spec, section %s] Managed bean implementation class MUST NOT be an interface - %s is an interface, hence won't be considered as a managed bean.";
    protected String invalidManagedBeanAbstractOrFinal$str() {
        return invalidManagedBeanAbstractOrFinal;
    }
    @Override
    public final void invalidManagedBeanInterface(final String sectionId, final String className) {
        super.log.logf(FQCN, WARN, null, invalidManagedBeanInterface$str(), sectionId, className);
    }
    private static final String invalidManagedBeanInterface = "WFLYEE0010: [Managed Bean spec, section %s] Managed bean implementation class MUST NOT be abstract or final - %s won't be considered as a managed bean, since it doesn't meet that requirement.";
    protected String invalidManagedBeanInterface$str() {
        return invalidManagedBeanInterface;
    }
    @Override
    public final void preDestroyInterceptorFailure(final Throwable cause, final Class<?> component) {
        super.log.logf(FQCN, WARN, cause, preDestroyInterceptorFailure$str(), component);
    }
    private static final String preDestroyInterceptorFailure = "WFLYEE0011: Exception while invoking pre-destroy interceptor for component class: %s";
    protected String preDestroyInterceptorFailure$str() {
        return preDestroyInterceptorFailure;
    }
    @Override
    public final void subdeploymentIgnored(final String pathName) {
        super.log.logf(FQCN, WARN, null, subdeploymentIgnored$str(), pathName);
    }
    private static final String subdeploymentIgnored = "WFLYEE0014: %s in subdeployment ignored. jboss-ejb-client.xml is only parsed for top level deployments.";
    protected String subdeploymentIgnored$str() {
        return subdeploymentIgnored;
    }
    private static final String alternateDeploymentDescriptor = "WFLYEE0019: Could not find alternate deployment descriptor %s specified for %s";
    protected String alternateDeploymentDescriptor$str() {
        return alternateDeploymentDescriptor;
    }
    @Override
    public final DeploymentUnitProcessingException alternateDeploymentDescriptor(final VirtualFile deploymentDescriptor, final VirtualFile moduleFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), alternateDeploymentDescriptor$str(), deploymentDescriptor, moduleFile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String annotationAttributeMissing = "WFLYEE0020: %s annotations must provide a %s.";
    protected String annotationAttributeMissing$str() {
        return annotationAttributeMissing;
    }
    @Override
    public final IllegalArgumentException annotationAttributeMissing(final String annotation, final String attribute) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), annotationAttributeMissing$str(), annotation, attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddMoreItems = "WFLYEE0021: Cannot add any more items once getSortedItems() has been called";
    protected String cannotAddMoreItems$str() {
        return cannotAddMoreItems;
    }
    @Override
    public final IllegalStateException cannotAddMoreItems() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAddMoreItems$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBeEmpty = "WFLYEE0022: %s may not be empty";
    protected String cannotBeEmpty$str() {
        return cannotBeEmpty;
    }
    @Override
    public final RuntimeException cannotBeEmpty(final String name) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotBeEmpty$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBeNullOrEmpty = "WFLYEE0023: %s cannot be null or empty: %s";
    protected String cannotBeNullOrEmpty$str() {
        return cannotBeNullOrEmpty;
    }
    @Override
    public final IllegalArgumentException cannotBeNullOrEmpty(final String name, final Object value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotBeNullOrEmpty$str(), name, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConfigureComponent = "WFLYEE0024: Could not configure component %s";
    protected String cannotConfigureComponent$str() {
        return cannotConfigureComponent;
    }
    @Override
    public final DeploymentUnitProcessingException cannotConfigureComponent(final Throwable cause, final String name) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotConfigureComponent$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDetermineType1 = "WFLYEE0025: Could not determine type for resource-env-ref %s";
    protected String cannotDetermineType1$str() {
        return cannotDetermineType1;
    }
    @Override
    public final DeploymentUnitProcessingException cannotDetermineType(final String name) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotDetermineType1$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDetermineType3 = "WFLYEE0026: Could not determine type for %s %s please specify the %s.";
    protected String cannotDetermineType3$str() {
        return cannotDetermineType3;
    }
    @Override
    public final DeploymentUnitProcessingException cannotDetermineType(final String tag, final String value, final String typeTag) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotDetermineType3$str(), tag, value, typeTag));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoad = "WFLYEE0027: Could not load %s referenced in env-entry";
    protected String cannotLoad$str() {
        return cannotLoad;
    }
    @Override
    public final DeploymentUnitProcessingException cannotLoad(final String injectionTarget) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotLoad$str(), injectionTarget));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final DeploymentUnitProcessingException cannotLoad(final Throwable cause, final String injectionTarget) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotLoad$str(), injectionTarget), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadInterceptor1 = "WFLYEE0028: Could not load interceptor class %s";
    protected String cannotLoadInterceptor1$str() {
        return cannotLoadInterceptor1;
    }
    @Override
    public final RuntimeException cannotLoadInterceptor(final Throwable cause, final String className) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotLoadInterceptor1$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadInterceptor2 = "WFLYEE0029: Could not load interceptor class %s on component %s";
    protected String cannotLoadInterceptor2$str() {
        return cannotLoadInterceptor2;
    }
    @Override
    public final DeploymentUnitProcessingException cannotLoadInterceptor(final Throwable cause, final String className, final Class<?> component) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotLoadInterceptor2$str(), className, component), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadViewClass = "WFLYEE0030: Could not load view class %s for component %s";
    protected String cannotLoadViewClass$str() {
        return cannotLoadViewClass;
    }
    @Override
    public final DeploymentUnitProcessingException cannotLoadViewClass(final Throwable cause, final String className, final ComponentConfiguration component) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotLoadViewClass$str(), className, component), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotProcessEarModule = "WFLYEE0031: Unable to process modules in application.xml for EAR [%s], module file %s not found";
    protected String cannotProcessEarModule$str() {
        return cannotProcessEarModule;
    }
    @Override
    public final DeploymentUnitProcessingException cannotProcessEarModule(final VirtualFile earFile, final String moduleFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotProcessEarModule$str(), earFile, moduleFile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotParseResourceRefUri = "WFLYEE0032: Unable to parse resource-ref URI: %s";
    protected String cannotParseResourceRefUri$str() {
        return cannotParseResourceRefUri;
    }
    @Override
    public final DeploymentUnitProcessingException cannotParseResourceRefUri(final Throwable cause, final String uri) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotParseResourceRefUri$str(), uri), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResolveInjectionPoint = "WFLYEE0033: Could not resolve injection point %s on class %s specified in web.xml";
    protected String cannotResolveInjectionPoint$str() {
        return cannotResolveInjectionPoint;
    }
    @Override
    public final DeploymentUnitProcessingException cannotResolveInjectionPoint(final String targetName, final String className) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotResolveInjectionPoint$str(), targetName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResolveMethod = "WFLYEE0034: Could not resolve method %s on class %s with annotations %s";
    protected String cannotResolveMethod$str() {
        return cannotResolveMethod;
    }
    @Override
    public final RuntimeException cannotResolveMethod(final MethodIdentifier method, final Class<?> component, final java.util.Collection<?> annotations) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotResolveMethod$str(), method, component, annotations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSpecifyBoth = "WFLYEE0036: Cannot specify both a %s and a %s in an environment entry.";
    protected String cannotSpecifyBoth$str() {
        return cannotSpecifyBoth;
    }
    @Override
    public final DeploymentUnitProcessingException cannotSpecifyBoth(final String element1, final String element2) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotSpecifyBoth$str(), element1, element2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String circularDependency = "WFLYEE0037: Circular dependency installing %s";
    protected String circularDependency$str() {
        return circularDependency;
    }
    @Override
    public final IllegalArgumentException circularDependency(final String bindingName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), circularDependency$str(), bindingName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classOnlyAnnotation = "WFLYEE0038: %s annotation is only allowed on a class. %s is not a class.";
    protected String classOnlyAnnotation$str() {
        return classOnlyAnnotation;
    }
    @Override
    public final DeploymentUnitProcessingException classOnlyAnnotation(final String annotation, final AnnotationTarget target) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), classOnlyAnnotation$str(), annotation, target));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentAlreadyDefined = "WFLYEE0040: A component named '%s' is already defined in this module";
    protected String componentAlreadyDefined$str() {
        return componentAlreadyDefined;
    }
    @Override
    public final IllegalArgumentException componentAlreadyDefined(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), componentAlreadyDefined$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentClassHasErrors = "WFLYEE0041: Component class %s for component %s has errors: %n%s";
    protected String componentClassHasErrors$str() {
        return componentClassHasErrors;
    }
    @Override
    public final DeploymentUnitProcessingException componentClassHasErrors(final String className, final String componentName, final String errorMsg) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), componentClassHasErrors$str(), className, componentName, errorMsg));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentConstructionFailure = "WFLYEE0042: Failed to construct component instance";
    protected String componentConstructionFailure$str() {
        return componentConstructionFailure;
    }
    @Override
    public final IllegalStateException componentConstructionFailure(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), componentConstructionFailure$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentIsStopped = "WFLYEE0043: Component is stopped";
    protected String componentIsStopped$str() {
        return componentIsStopped;
    }
    @Override
    public final ComponentIsStoppedException componentIsStopped() {
        final ComponentIsStoppedException result = new ComponentIsStoppedException(String.format(getLoggingLocale(), componentIsStopped$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentNotAvailable = "WFLYEE0044: Component not available (interrupted)";
    protected String componentNotAvailable$str() {
        return componentNotAvailable;
    }
    @Override
    public final IllegalStateException componentNotAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), componentNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentNotFound = "WFLYEE0045: No component found for type '%s'";
    protected String componentNotFound$str() {
        return componentNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException componentNotFound(final String typeName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), componentNotFound$str(), typeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String componentViewConstructionFailure = "WFLYEE0046: Failed to instantiate component view";
    protected String componentViewConstructionFailure$str() {
        return componentViewConstructionFailure;
    }
    @Override
    public final IllegalStateException componentViewConstructionFailure(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), componentViewConstructionFailure$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingBinding = "WFLYEE0047: Incompatible conflicting binding at %s source: %s";
    protected String conflictingBinding$str() {
        return conflictingBinding;
    }
    @Override
    public final IllegalArgumentException conflictingBinding(final String bindingName, final InjectionSource source) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), conflictingBinding$str(), bindingName, source));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultConstructorNotFound = "WFLYEE0048: Could not find default constructor for %s";
    protected String defaultConstructorNotFound$str() {
        return defaultConstructorNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException defaultConstructorNotFound(final Class<?> clazz) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), defaultConstructorNotFound$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultConstructorNotFoundOnComponent = "WFLYEE0050: No default constructor for interceptor class %s on component %s";
    protected String defaultConstructorNotFoundOnComponent$str() {
        return defaultConstructorNotFoundOnComponent;
    }
    @Override
    public final DeploymentUnitProcessingException defaultConstructorNotFoundOnComponent(final String className, final Class<?> component) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), defaultConstructorNotFoundOnComponent$str(), className, component));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elementAttributeMissing = "WFLYEE0051: %s elements must provide a %s.";
    protected String elementAttributeMissing$str() {
        return elementAttributeMissing;
    }
    @Override
    public final IllegalArgumentException elementAttributeMissing(final String element, final String attribute) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), elementAttributeMissing$str(), element, attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToInstallComponent = "WFLYEE0052: Failed to install component %s";
    protected String failedToInstallComponent$str() {
        return failedToInstallComponent;
    }
    @Override
    public final DeploymentUnitProcessingException failedToInstallComponent(final Throwable cause, final String name) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToInstallComponent$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParse = "WFLYEE0053: Failed to parse %s";
    protected String failedToParse$str() {
        return failedToParse;
    }
    @Override
    public final DeploymentUnitProcessingException failedToParse(final Throwable cause, final VirtualFile xmlFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToParse$str(), xmlFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToProcessChild = "WFLYEE0054: Failed to process children for EAR [%s]";
    protected String failedToProcessChild$str() {
        return failedToProcessChild;
    }
    @Override
    public final DeploymentUnitProcessingException failedToProcessChild(final Throwable cause, final VirtualFile earFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToProcessChild$str(), earFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToRead2 = "WFLYEE0055: Failed to read %s entries for application [%s]";
    protected String failedToRead2$str() {
        return failedToRead2;
    }
    @Override
    public final String failedToRead(final String entryName, final String appName) {
        return String.format(getLoggingLocale(), failedToRead2$str(), entryName, appName);
    }
    private static final String failedToRead3 = "WFLYEE0056: Failed to read %s entries for module [%s, %s]";
    protected String failedToRead3$str() {
        return failedToRead3;
    }
    @Override
    public final String failedToRead(final String entryName, final String appName, final String moduleName) {
        return String.format(getLoggingLocale(), failedToRead3$str(), entryName, appName, moduleName);
    }
    private static final String failedToRead4 = "WFLYEE0057: Failed to read %s entries for component [%s, %s, %s]";
    protected String failedToRead4$str() {
        return failedToRead4;
    }
    @Override
    public final String failedToRead(final String entryName, final String appName, final String moduleName, final String componentName) {
        return String.format(getLoggingLocale(), failedToRead4$str(), entryName, appName, moduleName, componentName);
    }
    private static final String fieldNotFound = "WFLYEE0058: No matching field found for '%s'";
    protected String fieldNotFound$str() {
        return fieldNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException fieldNotFound(final String name) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), fieldNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String injectionTargetNotFound = "WFLYEE0059: No injection target found";
    protected String injectionTargetNotFound$str() {
        return injectionTargetNotFound;
    }
    @Override
    public final IllegalStateException injectionTargetNotFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), injectionTargetNotFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCharacterLength = "WFLYEE0060: %s of type java.lang.Character is not exactly one character long %s";
    protected String invalidCharacterLength$str() {
        return invalidCharacterLength;
    }
    @Override
    public final DeploymentUnitProcessingException invalidCharacterLength(final String elementName, final String value) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidCharacterLength$str(), elementName, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDescriptor = "WFLYEE0061: %s is not a valid descriptor";
    protected String invalidDescriptor$str() {
        return invalidDescriptor;
    }
    @Override
    public final RuntimeException invalidDescriptor(final String descriptor) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), invalidDescriptor$str(), descriptor));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInjectionTarget = "WFLYEE0062: Injection target %s on class %s is not compatible with the type of injection: %s";
    protected String invalidInjectionTarget$str() {
        return invalidInjectionTarget;
    }
    @Override
    public final DeploymentUnitProcessingException invalidInjectionTarget(final String targetName, final String targetType, final Class<?> type) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidInjectionTarget$str(), targetName, targetType, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumberOfArguments = "WFLYEE0063: Invalid number of arguments for method %s annotated with %s on class %s";
    protected String invalidNumberOfArguments$str() {
        return invalidNumberOfArguments;
    }
    @Override
    public final String invalidNumberOfArguments(final String methodName, final DotName annotation, final DotName className) {
        return String.format(getLoggingLocale(), invalidNumberOfArguments$str(), methodName, annotation, className);
    }
    private static final String invalidReturnType = "WFLYEE0064: A return type of %s is required for method %s annotated with %s on class %s";
    protected String invalidReturnType$str() {
        return invalidReturnType;
    }
    @Override
    public final IllegalArgumentException invalidReturnType(final String returnType, final String methodName, final DotName annotation, final DotName className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidReturnType$str(), returnType, methodName, annotation, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSignature = "WFLYEE0065: Invalid signature for method %s annotated with %s on class %s, signature must be '%s'";
    protected String invalidSignature$str() {
        return invalidSignature;
    }
    @Override
    public final String invalidSignature(final String name, final DotName annotation, final DotName className, final String signatureArg) {
        return String.format(getLoggingLocale(), invalidSignature$str(), name, annotation, className, signatureArg);
    }
    private static final String invalidValue = "WFLYEE0066: Invalid value: %s for '%s' element";
    protected String invalidValue$str() {
        return invalidValue;
    }
    @Override
    public final XMLStreamException invalidValue(final String value, final String element, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidValue$str(), value, element), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNotFound1 = "WFLYEE0067: Method does not exist %s";
    protected String methodNotFound1$str() {
        return methodNotFound1;
    }
    @Override
    public final IllegalStateException methodNotFound(final Method method) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), methodNotFound1$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNotFound3 = "WFLYEE0068: No matching method found for method %s (%s) on %s";
    protected String methodNotFound3$str() {
        return methodNotFound3;
    }
    @Override
    public final DeploymentUnitProcessingException methodNotFound(final String name, final String paramType, final String className) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), methodNotFound3$str(), name, paramType, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodOnlyAnnotation = "WFLYEE0069: @%s is only valid on method targets.";
    protected String methodOnlyAnnotation$str() {
        return methodOnlyAnnotation;
    }
    @Override
    public final DeploymentUnitProcessingException methodOnlyAnnotation(final DotName annotation) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), methodOnlyAnnotation$str(), annotation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleComponentsFound = "WFLYEE0070: Multiple components found for type '%s'";
    protected String multipleComponentsFound$str() {
        return multipleComponentsFound;
    }
    @Override
    public final DeploymentUnitProcessingException multipleComponentsFound(final String typeName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), multipleComponentsFound$str(), typeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleMethodsFound = "WFLYEE0071: More than one matching method found for method '%s (%s) on %s";
    protected String multipleMethodsFound$str() {
        return multipleMethodsFound;
    }
    @Override
    public final DeploymentUnitProcessingException multipleMethodsFound(final String name, final String paramType, final String className) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), multipleMethodsFound$str(), name, paramType, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleSetterMethodsFound = "WFLYEE0072: Multiple setter methods for %s on class %s found when applying <injection-target> for env-entry";
    protected String multipleSetterMethodsFound$str() {
        return multipleSetterMethodsFound;
    }
    @Override
    public final DeploymentUnitProcessingException multipleSetterMethodsFound(final String targetName, final String className) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), multipleSetterMethodsFound$str(), targetName, className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noComponentInstance = "WFLYEE0073: No component instance associated";
    protected String noComponentInstance$str() {
        return noComponentInstance;
    }
    @Override
    public final IllegalStateException noComponentInstance() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noComponentInstance$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullBindingName = "WFLYEE0074: Binding name must not be null: %s";
    protected String nullBindingName$str() {
        return nullBindingName;
    }
    @Override
    public final DeploymentUnitProcessingException nullBindingName(final BindingConfiguration config) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), nullBindingName$str(), config));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullOrEmptyManagedBeanClassName = "WFLYEE0075: Managed bean class name cannot be null or empty";
    protected String nullOrEmptyManagedBeanClassName$str() {
        return nullOrEmptyManagedBeanClassName;
    }
    @Override
    public final IllegalArgumentException nullOrEmptyManagedBeanClassName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullOrEmptyManagedBeanClassName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullOrEmptyResourceReferenceType = "WFLYEE0076: Resource reference type cannot be null or empty";
    protected String nullOrEmptyResourceReferenceType$str() {
        return nullOrEmptyResourceReferenceType;
    }
    @Override
    public final IllegalArgumentException nullOrEmptyResourceReferenceType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullOrEmptyResourceReferenceType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullResourceReference = "WFLYEE0077: Cannot register a null resource reference processor";
    protected String nullResourceReference$str() {
        return nullResourceReference;
    }
    @Override
    public final IllegalArgumentException nullResourceReference() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullResourceReference$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullVar1 = "WFLYEE0078: %s is null";
    protected String nullVar1$str() {
        return nullVar1;
    }
    @Override
    public final IllegalArgumentException nullVar(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullVar1$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String priorityAlreadyExists = "WFLYEE0079: Can't add %s, priority 0x%s is already taken by %s";
    protected String priorityAlreadyExists$str() {
        return priorityAlreadyExists;
    }
    @Override
    public final IllegalArgumentException priorityAlreadyExists(final Object item, final String hexPriority, final Object current) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), priorityAlreadyExists$str(), item, hexPriority, current));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serviceNotStarted = "WFLYEE0082: Service not started";
    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }
    @Override
    public final IllegalStateException serviceNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String setterMethodOnly = "WFLYEE0083: %s injection target is invalid.  Only setter methods are allowed: %s";
    protected String setterMethodOnly$str() {
        return setterMethodOnly;
    }
    @Override
    public final IllegalArgumentException setterMethodOnly(final String annotation, final MethodInfo methodInfo) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), setterMethodOnly$str(), annotation, methodInfo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAnnotationTargetType = "WFLYEE0084: Unknown AnnotationTarget type: %s";
    protected String unknownAnnotationTargetType$str() {
        return unknownAnnotationTargetType;
    }
    @Override
    public final RuntimeException unknownAnnotationTargetType(final AnnotationTarget target) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unknownAnnotationTargetType$str(), target));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownElementType = "WFLYEE0085: Unknown %s type %s";
    protected String unknownElementType$str() {
        return unknownElementType;
    }
    @Override
    public final DeploymentUnitProcessingException unknownElementType(final String elementName, final String type) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), unknownElementType$str(), elementName, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String viewMethodNotFound = "WFLYEE0086: Could not find method %s %s on view %s of %s";
    protected String viewMethodNotFound$str() {
        return viewMethodNotFound;
    }
    @Override
    public final IllegalArgumentException viewMethodNotFound(final String name, final String descriptor, final Class<?> viewClass, final Class<?> component) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), viewMethodNotFound$str(), name, descriptor, viewClass, component));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedElement = "WFLYEE0088: Unexpected element '%s' encountered";
    protected String unexpectedElement$str() {
        return unexpectedElement;
    }
    @Override
    public final XMLStreamException unexpectedElement(final QName name, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), unexpectedElement$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToProcessEJBClientDescriptor = "WFLYEE0089: Failed to process jboss-ejb-client.xml";
    protected String failedToProcessEJBClientDescriptor$str() {
        return failedToProcessEJBClientDescriptor;
    }
    @Override
    public final DeploymentUnitProcessingException failedToProcessEJBClientDescriptor(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToProcessEJBClientDescriptor$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xmlErrorParsingEJBClientDescriptor = "WFLYEE0090: Exception while parsing jboss-ejb-client.xml file found at %s";
    protected String xmlErrorParsingEJBClientDescriptor$str() {
        return xmlErrorParsingEJBClientDescriptor;
    }
    @Override
    public final DeploymentUnitProcessingException xmlErrorParsingEJBClientDescriptor(final XMLStreamException cause, final String fileLocation) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), xmlErrorParsingEJBClientDescriptor$str(), fileLocation), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorParsingEJBClientDescriptor = "WFLYEE0091: %s";
    protected String errorParsingEJBClientDescriptor$str() {
        return errorParsingEJBClientDescriptor;
    }
    @Override
    public final XMLStreamException errorParsingEJBClientDescriptor(final String message, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), errorParsingEJBClientDescriptor$str(), message), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMessageDestination = "WFLYEE0092: No message destination with name %s for binding %s";
    protected String noMessageDestination$str() {
        return noMessageDestination;
    }
    @Override
    public final String noMessageDestination(final String name, final String binding) {
        return String.format(getLoggingLocale(), noMessageDestination$str(), name, binding);
    }
    private static final String moreThanOneMessageDestination = "WFLYEE0093: More than one message destination with name %s for binding %s destinations: %s";
    protected String moreThanOneMessageDestination$str() {
        return moreThanOneMessageDestination;
    }
    @Override
    public final String moreThanOneMessageDestination(final String name, final String binding, final java.util.Set<String> jndiNames) {
        return String.format(getLoggingLocale(), moreThanOneMessageDestination$str(), name, binding, jndiNames);
    }
    private static final String failedToLoadJbossProperties = "WFLYEE0094: Failed to load jboss.properties";
    protected String failedToLoadJbossProperties$str() {
        return failedToLoadJbossProperties;
    }
    @Override
    public final DeploymentUnitProcessingException failedToLoadJbossProperties(final IOException e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToLoadJbossProperties$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedModuleType = "WFLYEE0095: Unsupported ear module type: %s";
    protected String unsupportedModuleType$str() {
        return unsupportedModuleType;
    }
    @Override
    public final DeploymentUnitProcessingException unsupportedModuleType(final String moduleFileName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), unsupportedModuleType$str(), moduleFileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rootAsLibraryDirectory = "WFLYEE0096: library-directory of value / is not supported";
    protected String rootAsLibraryDirectory$str() {
        return rootAsLibraryDirectory;
    }
    @Override
    public final DeploymentUnitProcessingException rootAsLibraryDirectory() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), rootAsLibraryDirectory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String earModuleChildOfLibraryDirectory = "WFLYEE0097: Module may not be a child of the EAR's library directory. Library directory: %s, module file name: %s";
    protected String earModuleChildOfLibraryDirectory$str() {
        return earModuleChildOfLibraryDirectory;
    }
    @Override
    public final DeploymentUnitProcessingException earModuleChildOfLibraryDirectory(final String libraryDirectory, final String moduleFileName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), earModuleChildOfLibraryDirectory$str(), libraryDirectory, moduleFileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managedReferenceWasNull = "WFLYEE0098: ManagedReference was null and injection is not optional for injection into field %s";
    protected String managedReferenceWasNull$str() {
        return managedReferenceWasNull;
    }
    @Override
    public final RuntimeException managedReferenceWasNull(final Field field) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), managedReferenceWasNull$str(), field));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertiesNotAllowedOnGlobalModules = "WFLYEE0100: Global modules may not specify 'annotations', 'meta-inf' or 'services'.";
    protected String propertiesNotAllowedOnGlobalModules$str() {
        return propertiesNotAllowedOnGlobalModules;
    }
    @Override
    public final String propertiesNotAllowedOnGlobalModules() {
        return String.format(getLoggingLocale(), propertiesNotAllowedOnGlobalModules$str());
    }
    private static final String concurrentServiceValueUninitialized = "WFLYEE0102: EE Concurrent Service's value uninitialized.";
    protected String concurrentServiceValueUninitialized$str() {
        return concurrentServiceValueUninitialized;
    }
    @Override
    public final IllegalStateException concurrentServiceValueUninitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), concurrentServiceValueUninitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serializationMustBeHandledByTheFactory = "WFLYEE0103: EE Concurrent ContextHandle serialization must be handled by the factory.";
    protected String serializationMustBeHandledByTheFactory$str() {
        return serializationMustBeHandledByTheFactory;
    }
    @Override
    public final IOException serializationMustBeHandledByTheFactory() {
        final IOException result = new IOException(String.format(getLoggingLocale(), serializationMustBeHandledByTheFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String factoryAlreadyExists = "WFLYEE0104: The EE Concurrent Context %s already has a factory named %s";
    protected String factoryAlreadyExists$str() {
        return factoryAlreadyExists;
    }
    @Override
    public final IllegalArgumentException factoryAlreadyExists(final ConcurrentContext concurrentContext, final String factoryName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), factoryAlreadyExists$str(), concurrentContext, factoryName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String factoryNotFound = "WFLYEE0105: EE Concurrent Context %s does not has a factory named %s";
    protected String factoryNotFound$str() {
        return factoryNotFound;
    }
    @Override
    public final IOException factoryNotFound(final ConcurrentContext concurrentContext, final String factoryName) {
        final IOException result = new IOException(String.format(getLoggingLocale(), factoryNotFound$str(), concurrentContext, factoryName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String concurrentContextServiceNotInstalled = "WFLYEE0106: EE Concurrent Context %s service not installed.";
    protected String concurrentContextServiceNotInstalled$str() {
        return concurrentContextServiceNotInstalled;
    }
    @Override
    public final IOException concurrentContextServiceNotInstalled(final ServiceName serviceName) {
        final IOException result = new IOException(String.format(getLoggingLocale(), concurrentContextServiceNotInstalled$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionSetupProviderServiceNotInstalled = "WFLYEE0107: EE Concurrent Transaction Setup Provider service not installed.";
    protected String transactionSetupProviderServiceNotInstalled$str() {
        return transactionSetupProviderServiceNotInstalled;
    }
    @Override
    public final IllegalStateException transactionSetupProviderServiceNotInstalled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), transactionSetupProviderServiceNotInstalled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String instanceDataCanOnlyBeSetDuringConstruction = "WFLYEE0108: Instance data can only be set during construction";
    protected String instanceDataCanOnlyBeSetDuringConstruction$str() {
        return instanceDataCanOnlyBeSetDuringConstruction;
    }
    @Override
    public final IllegalStateException instanceDataCanOnlyBeSetDuringConstruction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), instanceDataCanOnlyBeSetDuringConstruction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aroundInvokeAnnotationUsedTooManyTimes = "WFLYEE0109: A class must not declare more than one AroundInvoke method. %s has %s methods annotated.";
    protected String aroundInvokeAnnotationUsedTooManyTimes$str() {
        return aroundInvokeAnnotationUsedTooManyTimes;
    }
    @Override
    public final DeploymentUnitProcessingException aroundInvokeAnnotationUsedTooManyTimes(final DotName className, final int numberOfAnnotatedMethods) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), aroundInvokeAnnotationUsedTooManyTimes$str(), className, numberOfAnnotatedMethods));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToRunTask(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToRunTask$str());
    }
    private static final String failedToRunTask = "WFLYEE0110: Failed to run scheduled task";
    protected String failedToRunTask$str() {
        return failedToRunTask;
    }
    private static final String cannotRunScheduledTask = "WFLYEE0111: Cannot run scheduled task %s as container is suspended";
    protected String cannotRunScheduledTask$str() {
        return cannotRunScheduledTask;
    }
    @Override
    public final IllegalStateException cannotRunScheduledTask(final Object delegate) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRunScheduledTask$str(), delegate));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCoreThreadsSize = "WFLYEE0112: The core-threads value must be greater than 0 when the queue-length is %s";
    protected String invalidCoreThreadsSize$str() {
        return invalidCoreThreadsSize;
    }
    @Override
    public final OperationFailedException invalidCoreThreadsSize(final String queueLengthValue) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidCoreThreadsSize$str(), queueLengthValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMaxThreads = "WFLYEE0113: The max-threads value %d cannot be less than the core-threads value %d.";
    protected String invalidMaxThreads$str() {
        return invalidMaxThreads;
    }
    @Override
    public final OperationFailedException invalidMaxThreads(final int maxThreads, final int coreThreads) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidMaxThreads$str(), maxThreads, coreThreads));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classDoesNotImplementAllInterfaces = "WFLYEE0114: Class does not implement all of the provided interfaces";
    protected String classDoesNotImplementAllInterfaces$str() {
        return classDoesNotImplementAllInterfaces;
    }
    @Override
    public final IllegalArgumentException classDoesNotImplementAllInterfaces() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), classDoesNotImplementAllInterfaces$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullName = "WFLYEE0115: The name of the %s is null";
    protected String nullName$str() {
        return nullName;
    }
    @Override
    public final IllegalArgumentException nullName(final String objectType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullName$str(), objectType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullVar3 = "WFLYEE0116: %s is null in the %s %s";
    protected String nullVar3$str() {
        return nullVar3;
    }
    @Override
    public final IllegalArgumentException nullVar(final String variable, final String objectType, final String objectName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullVar3$str(), variable, objectType, objectName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSetField = "WFLYEE0117: Field %s cannot be set - object of %s loaded by %s is not assignable to %s loaded by %s";
    protected String cannotSetField$str() {
        return cannotSetField;
    }
    @Override
    public final IllegalArgumentException cannotSetField(final String fieldName, final Class<?> injectedClass, final ClassLoader injectedClassloader, final Class<?> fieldClass, final ClassLoader fieldClassloader) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotSetField$str(), fieldName, injectedClass, injectedClassloader, fieldClass, fieldClassloader));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
