/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessorRegistry;
import org.jboss.as.ee.concurrent.deployers.injection.ContextServiceResourceReferenceProcessor;
import org.jboss.as.ee.concurrent.deployers.injection.ManagedExecutorServiceResourceReferenceProcessor;
import org.jboss.as.ee.concurrent.deployers.injection.ManagedScheduledExecutorServiceResourceReferenceProcessor;
import org.jboss.as.ee.concurrent.deployers.injection.ManagedThreadFactoryResourceReferenceProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class ResourceReferenceRegistrySetupProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() == null) {
            EEResourceReferenceProcessorRegistry registry = new EEResourceReferenceProcessorRegistry();
            EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            if (eeModuleDescription != null) {
                if (eeModuleDescription.getDefaultResourceJndiNames().getContextService() != null) {
                    registry.registerResourceReferenceProcessor(ContextServiceResourceReferenceProcessor.INSTANCE);
                }
                if (eeModuleDescription.getDefaultResourceJndiNames().getManagedExecutorService() != null) {
                    registry.registerResourceReferenceProcessor(ManagedExecutorServiceResourceReferenceProcessor.INSTANCE);
                }
                if (eeModuleDescription.getDefaultResourceJndiNames().getManagedScheduledExecutorService() != null) {
                    registry.registerResourceReferenceProcessor(ManagedScheduledExecutorServiceResourceReferenceProcessor.INSTANCE);
                }
                if (eeModuleDescription.getDefaultResourceJndiNames().getManagedThreadFactory() != null) {
                    registry.registerResourceReferenceProcessor(ManagedThreadFactoryResourceReferenceProcessor.INSTANCE);
                }
            }
            deploymentUnit.putAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY, (Object)registry);
        } else {
            deploymentUnit.putAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY, deploymentUnit.getParent().getAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY));
        }
    }
}

