/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionLeakContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "TRANSACTION_LEAK";

    @Override
    public SetupContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new TransactionLeakSetupContextHandle((TransactionManager)ContextTransactionManager.getInstance());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 600;
    }

    @Override
    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    @Override
    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new TransactionLeakSetupContextHandle((TransactionManager)ContextTransactionManager.getInstance());
    }

    private static class TransactionLeakResetContextHandle
    implements ResetContextHandle {
        private static final long serialVersionUID = -1726741825781759990L;
        private final TransactionManager transactionManager;
        private final Transaction transactionOnSetup;

        private TransactionLeakResetContextHandle(TransactionManager transactionManager, Transaction transactionOnSetup) {
            this.transactionManager = transactionManager;
            this.transactionOnSetup = transactionOnSetup;
        }

        /*
         * Loose catch block
         */
        @Override
        public void reset() {
            block16: {
                if (this.transactionManager != null) {
                    try {
                        Transaction transactionOnReset = this.transactionManager.getTransaction();
                        if (transactionOnReset == null || transactionOnReset.equals(this.transactionOnSetup)) break block16;
                        switch (transactionOnReset.getStatus()) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 7: 
                            case 8: 
                            case 9: {
                                EeLogger.ROOT_LOGGER.rollbackOfTransactionStartedInEEConcurrentInvocation();
                                this.transactionManager.rollback();
                                try {
                                    this.transactionManager.suspend();
                                }
                                catch (Throwable e) {
                                    EeLogger.ROOT_LOGGER.failedToSuspendTransaction(e);
                                }
                                break;
                                catch (Throwable e) {
                                    try {
                                        EeLogger.ROOT_LOGGER.failedToRollbackTransaction(e);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            this.transactionManager.suspend();
                                        }
                                        catch (Throwable e2) {
                                            EeLogger.ROOT_LOGGER.failedToSuspendTransaction(e2);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        this.transactionManager.suspend();
                                    }
                                    catch (Throwable e3) {
                                        EeLogger.ROOT_LOGGER.failedToSuspendTransaction(e3);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    catch (SystemException e) {
                        EeLogger.ROOT_LOGGER.systemErrorWhileCheckingForTransactionLeak(e);
                    }
                }
            }
        }

        @Override
        public String getFactoryName() {
            return TransactionLeakContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }

    private static class TransactionLeakSetupContextHandle
    implements SetupContextHandle {
        private static final long serialVersionUID = -8142799455606311295L;
        private final TransactionManager transactionManager;

        private TransactionLeakSetupContextHandle(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        @Override
        public ResetContextHandle setup() throws IllegalStateException {
            Transaction transactionOnSetup = null;
            if (this.transactionManager != null) {
                try {
                    transactionOnSetup = this.transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw new IllegalStateException(e);
                }
            }
            return new TransactionLeakResetContextHandle(this.transactionManager, transactionOnSetup);
        }

        @Override
        public String getFactoryName() {
            return TransactionLeakContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }
}

