/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.subsystem.GlobalDirectoryDeploymentService;
import org.jboss.as.ee.subsystem.GlobalDirectoryResourceDefinition;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DelegatingSupplier;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.moduleservice.ExternalModule;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class GlobalDirectoryDependencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceName depUnitServiceName = deploymentUnit.getServiceName();
        DeploymentUnit parent = deploymentUnit.getParent();
        DeploymentUnit topLevelDeployment = parent == null ? deploymentUnit : parent;
        ExternalModule externalModuleService = (ExternalModule)topLevelDeployment.getAttachment(Attachments.EXTERNAL_MODULE_SERVICE);
        ModuleLoader moduleLoader = (ModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        CapabilityServiceSupport capabilitySupport = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        ServiceTarget target = phaseContext.getServiceTarget();
        ServiceTarget externalServiceTarget = (ServiceTarget)deploymentUnit.getAttachment(Attachments.EXTERNAL_SERVICE_TARGET);
        ServiceName allDirReadyServiceName = depUnitServiceName.append(new String[]{"directory-services-ready"});
        ServiceBuilder allDirReadyServiceBuilder = target.addService(allDirReadyServiceName);
        ArrayList<Supplier<GlobalDirectoryResourceDefinition.GlobalDirectory>> allDirReadySuppliers = new ArrayList<Supplier<GlobalDirectoryResourceDefinition.GlobalDirectory>>();
        ServiceName csName = capabilitySupport.getCapabilityServiceName("org.wildfly.ee.global-directory");
        List serviceNames = serviceRegistry.getServiceNames();
        for (ServiceName serviceName : serviceNames) {
            if (!csName.isParentOf(serviceName)) continue;
            Supplier pathRequirement = allDirReadyServiceBuilder.requires(serviceName);
            allDirReadySuppliers.add(pathRequirement);
        }
        if (!allDirReadySuppliers.isEmpty()) {
            GlobalDirectoryDeploymentService globalDirDepService = new GlobalDirectoryDeploymentService(allDirReadySuppliers, externalModuleService, moduleSpecification, moduleLoader, serviceRegistry, externalServiceTarget);
            allDirReadyServiceBuilder.requires(phaseContext.getPhaseServiceName());
            allDirReadyServiceBuilder.setInstance((Service)globalDirDepService).install();
            phaseContext.requires(allDirReadyServiceName, new DelegatingSupplier());
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        ServiceController requiredService = deploymentUnit.getServiceRegistry().getService(deploymentUnit.getServiceName().append(new String[]{"directory-services-ready"}));
        if (requiredService != null) {
            requiredService.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

