/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.security.manager.WildFlySecurityManager;

final class ValidatorJndiInjectable
implements ContextListAndJndiViewManagedReferenceFactory {
    private final ValidatorFactory factory;

    public ValidatorJndiInjectable(ValidatorFactory factory) {
        this.factory = factory;
    }

    public ManagedReference getReference() {
        return new ValueManagedReference((Value)new ImmediateValue((Object)this.factory.getValidator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInstanceSafely() {
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.factory.getClass().getClassLoader());
            Validator validator = this.factory.getValidator();
            return validator;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }

    public String getInstanceClassName() {
        Object instance = this.getInstanceSafely();
        if (instance == null) {
            return ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
        }
        return instance.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJndiViewInstanceValue() {
        Object instance = this.getInstanceSafely();
        if (instance == null) {
            return "null";
        }
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)instance.getClass().getClassLoader());
            String string = instance.toString();
            return string;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }
}

