/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.AbstractComponentConfigurator;
import org.jboss.as.ee.component.AroundConstructInterceptorFactory;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentFactory;
import org.jboss.as.ee.component.ComponentInstantiatorInterceptorFactory;
import org.jboss.as.ee.component.ConstructorComponentFactory;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.InterceptorEnvironment;
import org.jboss.as.ee.component.ManagedReferenceLifecycleMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceReleaseInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.component.interceptors.OrderedItemContainer;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;

class DefaultInterceptorConfigurator
extends AbstractComponentConfigurator
implements ComponentConfigurator {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    DefaultInterceptorConfigurator() {
    }

    @Override
    public void configure(final DeploymentPhaseContext context, final ComponentDescription description, final ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        ComponentInstantiatorInterceptorFactory instantiator;
        HashMap userPostActivatesByInterceptorClass;
        HashMap userPrePassivatesByInterceptorClass;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        final DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        final EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
        final boolean metadataComplete = MetadataCompleteMarker.isMetadataComplete(deploymentUnit);
        ArrayDeque<InterceptorFactory> instantiators = new ArrayDeque<InterceptorFactory>();
        final ArrayDeque<InterceptorFactory> injectors = new ArrayDeque<InterceptorFactory>();
        final ArrayDeque<InterceptorFactory> uninjectors = new ArrayDeque<InterceptorFactory>();
        ArrayDeque<InterceptorFactory> destructors = new ArrayDeque<InterceptorFactory>();
        final HashMap userAroundInvokesByInterceptorClass = new HashMap();
        final HashMap userAroundConstructsByInterceptorClass = new HashMap();
        final HashMap userPostConstructByInterceptorClass = new HashMap();
        final HashMap userPreDestroyByInterceptorClass = new HashMap();
        Set<MethodIdentifier> timeoutMethods = description.getTimerMethods();
        final HashMap userAroundTimeoutsByInterceptorClass = description.isTimerServiceRequired() ? new HashMap() : null;
        if (description.isPassivationApplicable()) {
            userPrePassivatesByInterceptorClass = new HashMap();
            userPostActivatesByInterceptorClass = new HashMap();
        } else {
            userPrePassivatesByInterceptorClass = null;
            userPostActivatesByInterceptorClass = null;
        }
        ComponentFactory instanceFactory = configuration.getInstanceFactory();
        if (instanceFactory != null) {
            instantiator = new ComponentInstantiatorInterceptorFactory(instanceFactory, BasicComponentInstance.INSTANCE_KEY, true);
        } else {
            ClassReflectionIndex componentClassIndex = deploymentReflectionIndex.getClassIndex(configuration.getComponentClass());
            Constructor constructor = componentClassIndex.getConstructor(EMPTY_CLASS_ARRAY);
            if (constructor == null) {
                throw EeMessages.MESSAGES.defaultConstructorNotFound(configuration.getComponentClass());
            }
            instantiator = new ComponentInstantiatorInterceptorFactory(new ConstructorComponentFactory(constructor), BasicComponentInstance.INSTANCE_KEY, true);
        }
        ArrayList<InterceptorDescription> interceptorWithLifecycleCallbacks = new ArrayList<InterceptorDescription>();
        if (!description.isExcludeDefaultInterceptors()) {
            interceptorWithLifecycleCallbacks.addAll(description.getDefaultInterceptors());
        }
        interceptorWithLifecycleCallbacks.addAll(description.getClassInterceptors());
        for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
            ClassIndex interceptorClass;
            final String interceptorClassName = interceptorDescription.getInterceptorClassName();
            try {
                interceptorClass = classIndex.classIndex(interceptorClassName);
            }
            catch (ClassNotFoundException e) {
                throw EeMessages.MESSAGES.cannotLoadInterceptor(e, interceptorClassName);
            }
            InterceptorEnvironment interceptorEnvironment = moduleDescription.getInterceptorEnvironment().get(interceptorClassName);
            if (interceptorEnvironment != null) {
                description.getBindingConfigurations().addAll(interceptorEnvironment.getBindingConfigurations());
                for (ResourceInjectionConfiguration injection : interceptorEnvironment.getResourceInjections()) {
                    description.addResourceInjection(injection);
                }
            }
            final Class contextKey = interceptorClass.getModuleClass();
            configuration.getInterceptorContextKeys().add(contextKey);
            ClassReflectionIndex interceptorIndex = deploymentReflectionIndex.getClassIndex(interceptorClass.getModuleClass());
            Constructor constructor = interceptorIndex.getConstructor(EMPTY_CLASS_ARRAY);
            if (constructor == null) {
                throw EeMessages.MESSAGES.defaultConstructorNotFoundOnComponent(interceptorClassName, configuration.getComponentClass());
            }
            instantiators.addFirst(new ComponentInstantiatorInterceptorFactory(new ConstructorComponentFactory(constructor), contextKey, false));
            destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(contextKey));
            final boolean interceptorHasLifecycleCallbacks = interceptorWithLifecycleCallbacks.contains(interceptorDescription);
            new ClassDescriptionTraversal(interceptorClass.getModuleClass(), applicationClasses){

                @Override
                public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    DefaultInterceptorConfigurator.this.mergeInjectionsForClass(clazz, interceptorClass.getModuleClass(), classDescription, moduleDescription, deploymentReflectionIndex, description, configuration, context, injectors, contextKey, uninjectors, metadataComplete);
                    InterceptorClassDescription interceptorConfig = classDescription != null && !metadataComplete ? InterceptorClassDescription.merge(classDescription.getInterceptorClassDescription(), moduleDescription.getInterceptorClassOverride(clazz.getName())) : InterceptorClassDescription.merge(null, moduleDescription.getInterceptorClassOverride(clazz.getName()));
                    if (interceptorHasLifecycleCallbacks) {
                        MethodIdentifier postConstructMethodIdentifier = interceptorConfig.getPostConstruct();
                        this.handleInterceptorClass(clazz, postConstructMethodIdentifier, userPostConstructByInterceptorClass, true, true);
                        MethodIdentifier preDestroyMethodIdentifier = interceptorConfig.getPreDestroy();
                        this.handleInterceptorClass(clazz, preDestroyMethodIdentifier, userPreDestroyByInterceptorClass, true, true);
                        MethodIdentifier aroundConstructMethodIdentifier = interceptorConfig.getAroundConstruct();
                        this.handleInterceptorClass(clazz, aroundConstructMethodIdentifier, userAroundConstructsByInterceptorClass, true, true);
                    }
                    MethodIdentifier aroundInvokeMethodIdentifier = interceptorConfig.getAroundInvoke();
                    this.handleInterceptorClass(clazz, aroundInvokeMethodIdentifier, userAroundInvokesByInterceptorClass, false, false);
                    if (description.isTimerServiceRequired()) {
                        MethodIdentifier aroundTimeoutMethodIdentifier = interceptorConfig.getAroundTimeout();
                        this.handleInterceptorClass(clazz, aroundTimeoutMethodIdentifier, userAroundTimeoutsByInterceptorClass, false, false);
                    }
                    if (description.isPassivationApplicable()) {
                        this.handleInterceptorClass(clazz, interceptorConfig.getPrePassivate(), userPrePassivatesByInterceptorClass, false, false);
                        this.handleInterceptorClass(clazz, interceptorConfig.getPostActivate(), userPostActivatesByInterceptorClass, false, false);
                    }
                }

                private void handleInterceptorClass(Class<?> clazz, MethodIdentifier methodIdentifier, Map<String, List<InterceptorFactory>> classMap, boolean changeMethod, boolean lifecycleMethod) throws DeploymentUnitProcessingException {
                    Method method;
                    if (methodIdentifier != null && DefaultInterceptorConfigurator.this.isNotOverriden(clazz, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, clazz, (MethodIdentifier)methodIdentifier), interceptorClass.getModuleClass(), deploymentReflectionIndex)) {
                        ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method, changeMethod, lifecycleMethod);
                        List<InterceptorFactory> factories = classMap.get(interceptorClassName);
                        if (factories == null) {
                            factories = new ArrayList<InterceptorFactory>();
                            classMap.put(interceptorClassName, factories);
                        }
                        factories.add(interceptorFactory);
                    }
                }
            }.run();
        }
        ArrayList<InterceptorFactory> userAroundConstruct = new ArrayList<InterceptorFactory>();
        ArrayList<InterceptorFactory> userPostConstruct = new ArrayList<InterceptorFactory>();
        ArrayList<InterceptorFactory> userPreDestroy = new ArrayList<InterceptorFactory>();
        ArrayList<InterceptorFactory> userPrePassivate = new ArrayList<InterceptorFactory>();
        ArrayList<InterceptorFactory> userPostActivate = new ArrayList<InterceptorFactory>();
        for (InterceptorDescription interceptorClass : interceptorWithLifecycleCallbacks) {
            if (userPostConstructByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                userPostConstruct.addAll((Collection)userPostConstructByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
            }
            if (userAroundConstructsByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                userAroundConstruct.addAll((Collection)userAroundConstructsByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
            }
            if (userPreDestroyByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                userPreDestroy.addAll((Collection)userPreDestroyByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
            }
            if (!description.isPassivationApplicable()) continue;
            if (userPrePassivatesByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                userPrePassivate.addAll((Collection)userPrePassivatesByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
            }
            if (!userPostActivatesByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) continue;
            userPostActivate.addAll((Collection)userPostActivatesByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
        }
        OrderedItemContainer<Object> aroundConstructInterceptors = new OrderedItemContainer<Object>();
        if (!injectors.isEmpty()) {
            configuration.addPostConstructInterceptor(DefaultInterceptorConfigurator.weaved(injectors), 2048);
        }
        if (!instantiators.isEmpty()) {
            configuration.addPostConstructInterceptor(DefaultInterceptorConfigurator.weaved(instantiators), 1792);
        }
        if (!userAroundConstruct.isEmpty()) {
            aroundConstructInterceptors.add(DefaultInterceptorConfigurator.weaved(userAroundConstruct), 2560);
        }
        aroundConstructInterceptors.add(instantiator, 3072);
        aroundConstructInterceptors.add(new ImmediateInterceptorFactory(Interceptors.getTerminalInterceptor()), 3328);
        configuration.addPostConstructInterceptor(new AroundConstructInterceptorFactory(DefaultInterceptorConfigurator.weaved(aroundConstructInterceptors.getSortedItems())), 2560);
        if (!userPostConstruct.isEmpty()) {
            configuration.addPostConstructInterceptor(DefaultInterceptorConfigurator.weaved(userPostConstruct), 3840);
        }
        if (!uninjectors.isEmpty()) {
            configuration.addPreDestroyInterceptor(DefaultInterceptorConfigurator.weaved(uninjectors), 1536);
        }
        if (!destructors.isEmpty()) {
            configuration.addPreDestroyInterceptor(DefaultInterceptorConfigurator.weaved(destructors), 2048);
        }
        if (!userPreDestroy.isEmpty()) {
            configuration.addPreDestroyInterceptor(DefaultInterceptorConfigurator.weaved(userPreDestroy), 2560);
        }
        if (description.isPassivationApplicable()) {
            if (!userPrePassivate.isEmpty()) {
                configuration.addPrePassivateInterceptor(DefaultInterceptorConfigurator.weaved(userPrePassivate), 1280);
            }
            if (!userPostActivate.isEmpty()) {
                configuration.addPostActivateInterceptor(DefaultInterceptorConfigurator.weaved(userPostActivate), 1280);
            }
        }
        List<InterceptorDescription> classInterceptors = description.getClassInterceptors();
        Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = description.getMethodInterceptors();
        if (description.isIntercepted()) {
            for (Method method : configuration.getDefinedComponentMethods()) {
                List<InterceptorDescription> methodLevelInterceptors;
                List aroundTimeouts;
                List aroundInvokes;
                String interceptorClassName;
                boolean requiresTimerChain;
                MethodIdentifier identifier = MethodIdentifier.getIdentifier(method.getReturnType(), (String)method.getName(), (Class[])method.getParameterTypes());
                ArrayList<InterceptorFactory> userAroundInvokes = new ArrayList<InterceptorFactory>();
                ArrayList<InterceptorFactory> userAroundTimeouts = new ArrayList<InterceptorFactory>();
                boolean bl = requiresTimerChain = description.isTimerServiceRequired() && timeoutMethods.contains(identifier);
                if (!description.isExcludeDefaultInterceptors() && !description.isExcludeDefaultInterceptors(identifier)) {
                    for (InterceptorDescription interceptorDescription : description.getDefaultInterceptors()) {
                        interceptorClassName = interceptorDescription.getInterceptorClassName();
                        aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                        if (aroundInvokes != null) {
                            userAroundInvokes.addAll(aroundInvokes);
                        }
                        if (!requiresTimerChain || (aroundTimeouts = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName)) == null) continue;
                        userAroundTimeouts.addAll(aroundTimeouts);
                    }
                }
                if (!description.isExcludeClassInterceptors(identifier)) {
                    for (InterceptorDescription interceptorDescription : classInterceptors) {
                        interceptorClassName = interceptorDescription.getInterceptorClassName();
                        aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                        if (aroundInvokes != null) {
                            userAroundInvokes.addAll(aroundInvokes);
                        }
                        if (!requiresTimerChain || (aroundTimeouts = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName)) == null) continue;
                        userAroundTimeouts.addAll(aroundTimeouts);
                    }
                }
                if ((methodLevelInterceptors = methodInterceptors.get(identifier)) != null) {
                    for (InterceptorDescription methodLevelInterceptor : methodLevelInterceptors) {
                        List aroundTimeouts2;
                        String interceptorClassName2 = methodLevelInterceptor.getInterceptorClassName();
                        List aroundInvokes2 = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName2);
                        if (aroundInvokes2 != null) {
                            userAroundInvokes.addAll(aroundInvokes2);
                        }
                        if (!requiresTimerChain || (aroundTimeouts2 = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName2)) == null) continue;
                        userAroundTimeouts.addAll(aroundTimeouts2);
                    }
                }
                configuration.addComponentInterceptor(method, new UserInterceptorFactory(DefaultInterceptorConfigurator.weaved(userAroundInvokes), DefaultInterceptorConfigurator.weaved(userAroundTimeouts)), 2560);
            }
        }
    }
}

