/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentConfigurator;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ManagedReferenceLifecycleMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceReleaseInterceptorFactory;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ContextClassLoaderInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.PrivilegedInterceptor;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

class DefaultComponentConfigurator
extends AbstractComponentConfigurator
implements ComponentConfigurator {
    DefaultComponentConfigurator() {
    }

    @Override
    public void configure(final DeploymentPhaseContext context, final ComponentDescription description, final ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        ArrayList<InterceptorFactory> componentUserPostActivate;
        ArrayList<InterceptorFactory> componentUserPrePassivate;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        final DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        final Object instanceKey = BasicComponentInstance.INSTANCE_KEY;
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        final EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        final boolean metadataComplete = MetadataCompleteMarker.isMetadataComplete(deploymentUnit);
        final ArrayDeque<InterceptorFactory> injectors = new ArrayDeque<InterceptorFactory>();
        final ArrayDeque<InterceptorFactory> uninjectors = new ArrayDeque<InterceptorFactory>();
        ArrayDeque<InterceptorFactory> destructors = new ArrayDeque<InterceptorFactory>();
        final ArrayList<InterceptorFactory> componentUserAroundInvoke = new ArrayList<InterceptorFactory>();
        final ArrayList<InterceptorFactory> userPostConstruct = new ArrayList<InterceptorFactory>();
        final ArrayList<InterceptorFactory> userPreDestroy = new ArrayList<InterceptorFactory>();
        Set<MethodIdentifier> timeoutMethods = description.getTimerMethods();
        final ArrayList<InterceptorFactory> componentUserAroundTimeout = description.isTimerServiceRequired() ? new ArrayList<InterceptorFactory>() : null;
        if (description.isPassivationApplicable()) {
            componentUserPrePassivate = new ArrayList<InterceptorFactory>();
            componentUserPostActivate = new ArrayList<InterceptorFactory>();
        } else {
            componentUserPrePassivate = null;
            componentUserPostActivate = null;
        }
        destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(instanceKey));
        new ClassDescriptionTraversal(configuration.getComponentClass(), applicationClasses){

            @Override
            public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                DefaultComponentConfigurator.this.mergeInjectionsForClass(clazz, configuration.getComponentClass(), classDescription, moduleDescription, deploymentReflectionIndex, description, configuration, context, injectors, instanceKey, uninjectors, metadataComplete);
            }
        }.run();
        new ClassDescriptionTraversal(configuration.getComponentClass(), applicationClasses){

            @Override
            public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                InterceptorClassDescription interceptorConfig = InterceptorClassDescription.merge(ComponentDescription.mergeInterceptorConfig(clazz, classDescription, description, metadataComplete), moduleDescription.getInterceptorClassOverride(clazz.getName()));
                this.handleClassMethod(clazz, interceptorConfig.getPostConstruct(), userPostConstruct, true, true);
                this.handleClassMethod(clazz, interceptorConfig.getPreDestroy(), userPreDestroy, true, true);
                this.handleClassMethod(clazz, interceptorConfig.getAroundInvoke(), componentUserAroundInvoke, false, false);
                if (description.isTimerServiceRequired()) {
                    this.handleClassMethod(clazz, interceptorConfig.getAroundTimeout(), componentUserAroundTimeout, false, false);
                }
                if (description.isPassivationApplicable()) {
                    this.handleClassMethod(clazz, interceptorConfig.getPrePassivate(), componentUserPrePassivate, false, false);
                    this.handleClassMethod(clazz, interceptorConfig.getPostActivate(), componentUserPostActivate, false, false);
                }
            }

            private void handleClassMethod(Class<?> clazz, MethodIdentifier methodIdentifier, List<InterceptorFactory> interceptors, boolean changeMethod, boolean lifecycleMethod) throws DeploymentUnitProcessingException {
                Method method;
                if (methodIdentifier != null && DefaultComponentConfigurator.this.isNotOverriden(clazz, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, clazz, (MethodIdentifier)methodIdentifier), configuration.getComponentClass(), deploymentReflectionIndex)) {
                    ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method, changeMethod, lifecycleMethod);
                    interceptors.add(interceptorFactory);
                }
            }
        }.run();
        ModuleClassLoader classLoader = module.getClassLoader();
        ImmediateInterceptorFactory tcclInterceptor = new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor((ClassLoader)classLoader));
        InterceptorFactory privilegedInterceptor = PrivilegedInterceptor.getFactory();
        if (!injectors.isEmpty()) {
            configuration.addPostConstructInterceptor(DefaultComponentConfigurator.weaved(injectors), 2816);
        }
        if (!userPostConstruct.isEmpty()) {
            configuration.addPostConstructInterceptor(DefaultComponentConfigurator.weaved(userPostConstruct), 4352);
        }
        configuration.addPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 5120);
        configuration.addPostConstructInterceptor((InterceptorFactory)tcclInterceptor, 256);
        configuration.addPostConstructInterceptor(privilegedInterceptor, 0);
        if (!uninjectors.isEmpty()) {
            configuration.addPreDestroyInterceptor(DefaultComponentConfigurator.weaved(uninjectors), 1792);
        }
        if (!destructors.isEmpty()) {
            configuration.addPreDestroyInterceptor(DefaultComponentConfigurator.weaved(destructors), 2304);
        }
        if (!userPreDestroy.isEmpty()) {
            configuration.addPreDestroyInterceptor(DefaultComponentConfigurator.weaved(userPreDestroy), 3072);
        }
        configuration.addPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 3328);
        configuration.addPreDestroyInterceptor((InterceptorFactory)tcclInterceptor, 256);
        configuration.addPreDestroyInterceptor(privilegedInterceptor, 0);
        if (description.isPassivationApplicable()) {
            if (!componentUserPrePassivate.isEmpty()) {
                configuration.addPrePassivateInterceptor(DefaultComponentConfigurator.weaved(componentUserPrePassivate), 1792);
            }
            configuration.addPrePassivateInterceptor(Interceptors.getTerminalInterceptorFactory(), 2048);
            configuration.addPrePassivateInterceptor((InterceptorFactory)tcclInterceptor, 256);
            configuration.addPrePassivateInterceptor(privilegedInterceptor, 0);
            if (!componentUserPostActivate.isEmpty()) {
                configuration.addPostActivateInterceptor(DefaultComponentConfigurator.weaved(componentUserPostActivate), 1792);
            }
            configuration.addPostActivateInterceptor(Interceptors.getTerminalInterceptorFactory(), 2048);
            configuration.addPostActivateInterceptor((InterceptorFactory)tcclInterceptor, 256);
            configuration.addPostActivateInterceptor(privilegedInterceptor, 0);
        }
        if (description.isIntercepted()) {
            for (Method method : configuration.getDefinedComponentMethods()) {
                configuration.addComponentInterceptor(method, Interceptors.getInitialInterceptorFactory(), 256);
                configuration.addComponentInterceptor(method, new ManagedReferenceMethodInterceptorFactory(instanceKey, method), 3328);
                MethodIdentifier identifier = MethodIdentifier.getIdentifier(method.getReturnType(), (String)method.getName(), (Class[])method.getParameterTypes());
                boolean requiresTimerChain = description.isTimerServiceRequired() && timeoutMethods.contains(identifier);
                configuration.addComponentInterceptor(method, new UserInterceptorFactory(DefaultComponentConfigurator.weaved(componentUserAroundInvoke), DefaultComponentConfigurator.weaved(requiresTimerChain ? componentUserAroundTimeout : null)), 3072);
            }
        }
    }
}

