/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ee.component.deployers.DefaultEarSubDeploymentsIsolationProcessor;
import org.jboss.as.ee.structure.AnnotationPropertyReplacementProcessor;
import org.jboss.as.ee.structure.DescriptorPropertyReplacementProcessor;
import org.jboss.as.ee.structure.GlobalModuleDependencyProcessor;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.dmr.ModelNode;

public class EeWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final DefaultEarSubDeploymentsIsolationProcessor isolationProcessor;
    private final GlobalModuleDependencyProcessor moduleDependencyProcessor;
    private final DescriptorPropertyReplacementProcessor specDescriptorPropertyReplacementProcessor;
    private final DescriptorPropertyReplacementProcessor jbossDescriptorPropertyReplacementProcessor;
    private final AnnotationPropertyReplacementProcessor annotationPropertyReplacementProcessor;

    public EeWriteAttributeHandler(DefaultEarSubDeploymentsIsolationProcessor isolationProcessor, GlobalModuleDependencyProcessor moduleDependencyProcessor, DescriptorPropertyReplacementProcessor specDescriptorPropertyReplacementProcessor, DescriptorPropertyReplacementProcessor jbossDescriptorPropertyReplacementProcessor, AnnotationPropertyReplacementProcessor annotationPropertyReplacementProcessor) {
        super(EeSubsystemRootResource.ATTRIBUTES);
        this.isolationProcessor = isolationProcessor;
        this.moduleDependencyProcessor = moduleDependencyProcessor;
        this.specDescriptorPropertyReplacementProcessor = specDescriptorPropertyReplacementProcessor;
        this.jbossDescriptorPropertyReplacementProcessor = jbossDescriptorPropertyReplacementProcessor;
        this.annotationPropertyReplacementProcessor = annotationPropertyReplacementProcessor;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition ad : EeSubsystemRootResource.ATTRIBUTES) {
            registry.registerReadWriteAttribute(ad, null, (OperationStepHandler)this);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        this.applyUpdateToDeploymentUnitProcessor(context, newValue, attributeName);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        this.applyUpdateToDeploymentUnitProcessor(context, valueToRestore, attributeName);
    }

    private void applyUpdateToDeploymentUnitProcessor(OperationContext context, ModelNode newValue, String attributeName) throws OperationFailedException {
        if (GlobalModulesDefinition.INSTANCE.getName().equals(attributeName)) {
            this.moduleDependencyProcessor.setGlobalModules(GlobalModulesDefinition.createModuleList(context, newValue));
        } else if (EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.getName().equals(attributeName)) {
            boolean isolate = newValue.asBoolean();
            this.isolationProcessor.setEarSubDeploymentsIsolated(isolate);
        } else if (EeSubsystemRootResource.SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT.getName().equals(attributeName)) {
            boolean enabled = newValue.asBoolean();
            this.specDescriptorPropertyReplacementProcessor.setDescriptorPropertyReplacement(enabled);
        } else if (EeSubsystemRootResource.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT.getName().equals(attributeName)) {
            boolean enabled = newValue.asBoolean();
            this.jbossDescriptorPropertyReplacementProcessor.setDescriptorPropertyReplacement(enabled);
        } else if (EeSubsystemRootResource.EJB_ANNOTATION_PROPERTY_REPLACEMENT.getName().equals(attributeName)) {
            boolean enabled = newValue.asBoolean();
            this.annotationPropertyReplacementProcessor.setDescriptorPropertyReplacement(enabled);
        }
    }
}

