/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.naming.ContextManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class ContextInjectionSource
extends InjectionSource {
    private final String name;
    private final String fullName;

    public ContextInjectionSource(String name, String fullName) {
        this.name = name;
        this.fullName = fullName;
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        ServiceName contextServiceName;
        ContextManagedReferenceFactory managedReferenceFactory = new ContextManagedReferenceFactory(this.name);
        if (this.fullName.startsWith("java:app")) {
            contextServiceName = ContextNames.contextServiceNameOfApplication((String)resolutionContext.getApplicationName());
        } else if (this.fullName.startsWith("java:module") || this.fullName.startsWith("java:comp") && resolutionContext.isCompUsesModule()) {
            contextServiceName = ContextNames.contextServiceNameOfModule((String)resolutionContext.getApplicationName(), (String)resolutionContext.getModuleName());
        } else if (this.fullName.startsWith("java:comp")) {
            contextServiceName = ContextNames.contextServiceNameOfComponent((String)resolutionContext.getApplicationName(), (String)resolutionContext.getModuleName(), (String)resolutionContext.getComponentName());
        } else {
            throw NamingMessages.MESSAGES.invalidNameForContextBinding(this.fullName);
        }
        serviceBuilder.addDependency(contextServiceName, NamingStore.class, (Injector)managedReferenceFactory.getNamingStoreInjectedValue());
        injector.inject((Object)managedReferenceFactory);
    }
}

