/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.diff.FileSystemDiff;
import org.jboss.galleon.plugin.DiffPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.plugin.ProvisioningPluginWithOptions;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathFilter;
import org.jboss.galleon.xml.ConfigXmlWriter;
import org.wildfly.galleon.plugin.WfDiffConfigGenerator;
import org.wildfly.galleon.plugin.WfDiffResult;
import org.wildfly.galleon.plugin.server.ClassLoaderHelper;

public class WfDiffPlugin
extends ProvisioningPluginWithOptions
implements DiffPlugin {
    private static final PathFilter FILTER_FP = PathFilter.Builder.instance().addDirectories(new String[]{"*" + File.separatorChar + "tmp", "*" + File.separatorChar + "log", "*_xml_history", "model_diff"}).addFiles(new String[]{"standalone.xml", "process-uuid", "logging.properties"}).build();
    private static final PathFilter FILTER = PathFilter.Builder.instance().addDirectories(new String[]{"*" + File.separatorChar + "tmp", "model_diff"}).addFiles(new String[]{"standalone.xml", "logging.properties"}).build();

    protected List<PluginOption> initPluginOptions() {
        return Arrays.asList(WfDiffConfigGenerator.HOST, WfDiffConfigGenerator.PORT, WfDiffConfigGenerator.PROTOCOL, WfDiffConfigGenerator.USERNAME, WfDiffConfigGenerator.PASSWORD, WfDiffConfigGenerator.SERVER_CONFIG);
    }

    public void computeDiff(ProvisioningRuntime runtime, Path customizedInstallation, Path target) throws ProvisioningException {
        ConfigModel config;
        MessageWriter messageWriter = runtime.getMessageWriter();
        messageWriter.verbose((CharSequence)"WildFly diff plug-in");
        FileSystemDiff diff = new FileSystemDiff(messageWriter, runtime.getInstallDir(), customizedInstallation);
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader newCl = ClassLoaderHelper.prepareProvisioningClassLoader(runtime.getInstallDir(), originalCl, new URL[0]);
        Properties props = System.getProperties();
        Thread.currentThread().setContextClassLoader(newCl);
        HashMap<FeaturePackLocation.FPID, ConfigId> includedConfigs = new HashMap<FeaturePackLocation.FPID, ConfigId>();
        try {
            Class<?> wfDiffGenerator = newCl.loadClass("org.jboss.galleon.plugin.wildfly.WfDiffConfigGenerator");
            Method exportDiff = wfDiffGenerator.getMethod("exportDiff", ProvisioningRuntime.class, Map.class, Path.class, Path.class);
            config = (ConfigModel)exportDiff.invoke(null, runtime, includedConfigs, customizedInstallation, target);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ProvisioningException(ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            System.setProperties(props);
            ClassLoaderHelper.close(newCl);
        }
        try {
            ConfigXmlWriter.getInstance().write((Object)config, target.resolve("config.xml"));
            WfDiffResult result = new WfDiffResult(includedConfigs, Collections.singletonList(config), Collections.emptyList(), diff.diff(this.getFilter(runtime)));
            runtime.setDiff(result.merge(runtime.getDiff()));
        }
        catch (IOException | XMLStreamException ex) {
            messageWriter.error((Throwable)ex, "Couldn't compute the WildFly Model diff because of %s", new Object[]{ex.getMessage()});
            Logger.getLogger(WfDiffPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private PathFilter getFilter(ProvisioningRuntime runtime) {
        if ("diff-to-feature-pack".equals(runtime.getOperation())) {
            return FILTER_FP;
        }
        return FILTER;
    }
}

