/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jacorb.TransformUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MigrateOperation
implements OperationStepHandler {
    private static final OperationStepHandler INSTANCE = new MigrateOperation();
    private static final PathElement OPENJDK_EXTENSION_ELEMENT = PathElement.pathElement((String)"extension", (String)"org.wildfly.iiop-openjdk");
    private static final PathElement OPENJDK_SUBSYSTEM_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"iiop-openjdk");
    private static final PathElement JACORB_SUBSYSTEM_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"jacorb");

    static void registerOperation(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("migrate", resourceDescriptionResolver).setRuntimeOnly().build(), INSTANCE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException("the iiop migration can be performed when the server is in admin-only mode");
        }
        PathAddress subsystemsAddress = context.getCurrentAddress().getParent();
        if (context.readResourceFromRoot(subsystemsAddress).hasChild(OPENJDK_SUBSYSTEM_ELEMENT)) {
            throw new OperationFailedException("can not migrate: the new iiop-openjdk subsystem is already defined");
        }
        if (!context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS).hasChild(OPENJDK_EXTENSION_ELEMENT)) {
            this.addOpenjdkExtension(context);
        }
        Resource jacorbResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode jacorbModel = Resource.Tools.readModel((Resource)jacorbResource).clone();
        TransformUtils.checkLegacyModel(jacorbModel, true);
        ModelNode openjdkModel = TransformUtils.transformModel(jacorbModel);
        PathAddress openjdkAddress = subsystemsAddress.append(new PathElement[]{OPENJDK_SUBSYSTEM_ELEMENT});
        this.addOpenjdkSubsystem(context, openjdkAddress, openjdkModel);
        PathAddress jacorbAddress = subsystemsAddress.append(new PathElement[]{JACORB_SUBSYSTEM_ELEMENT});
        this.removeJacorbSubsystem(context, jacorbAddress);
    }

    private void addOpenjdkExtension(OperationContext context) {
        OperationStepHandler addExtensionHandler = context.getRootResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension")}), "add");
        PathAddress openjdkExtensionAddress = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{OPENJDK_EXTENSION_ELEMENT});
        ModelNode openjdkExtensionAddOperation = Util.createAddOperation((PathAddress)openjdkExtensionAddress);
        context.addStep(openjdkExtensionAddOperation, addExtensionHandler, OperationContext.Stage.MODEL);
    }

    private void addOpenjdkSubsystem(OperationContext context, final PathAddress address, ModelNode model) {
        final ModelNode operation = Util.createAddOperation((PathAddress)address);
        for (Property property : model.asPropertyList()) {
            if (!property.getValue().isDefined()) continue;
            operation.get(property.getName()).set(property.getValue());
        }
        context.addStep(operation, new OperationStepHandler(){

            public void execute(OperationContext operationContext, ModelNode modelNode) throws OperationFailedException {
                OperationStepHandler addHandler = operationContext.getRootResourceRegistration().getOperationHandler(address, "add");
                operationContext.addStep(operation, addHandler, OperationContext.Stage.MODEL);
            }
        }, OperationContext.Stage.MODEL);
    }

    private void removeJacorbSubsystem(OperationContext context, PathAddress address) {
        ModelNode removeLegacySubsystemOperation = Util.createRemoveOperation((PathAddress)address);
        context.addStep(removeLegacySubsystemOperation, context.getRootResourceRegistration().getOperationHandler(address, "remove"), OperationContext.Stage.MODEL);
    }
}

