package org.jboss.as.jacorb.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.util.List;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-10-04T11:06:17-0500")
public class JacORBLogger_$logger extends DelegatingBasicLogger implements JacORBLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JacORBLogger_$logger.class.getName();
    public JacORBLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidInitializerConfig$str() {
        return "WFLYORB0038: Illegal initializer value: %s. Should be one of [security,transactions]";
    }
    @Override
    public final XMLStreamException invalidInitializerConfig(final String value, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidInitializerConfig$str(), value), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidSSLConfig$str() {
        return "WFLYORB0039: Illegal SSL config option: %s. Should be one of [0.20,40,60]";
    }
    @Override
    public final XMLStreamException invalidSSLConfig(final String value, final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), invalidSSLConfig$str(), value), location);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotEmulateProperties$str() {
        return "WFLYORB0132: Properties %s cannot be emulated using OpenJDK ORB and are not supported";
    }
    @Override
    public final OperationFailedException cannotEmulateProperties(final List<String> property) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), cannotEmulateProperties$str(), property));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void jacorbEmulationWarning() {
        super.log.logf(FQCN, WARN, null, jacorbEmulationWarning$str());
    }
    protected String jacorbEmulationWarning$str() {
        return "WFLYORB0133: JacORB is not used as an ORB implementation anymore. JacORB subsystem would be emulated using the current OpenJDK ORB implementation. Ability to emulate legacy JacORB configurations using OpenJDK ORB will be removed in future.";
    }
    protected String cannotEmulatePropertiesWarning$str() {
        return "WFLYORB0134: Properties %s cannot be emulated using OpenJDK ORB and are not supported";
    }
    @Override
    public final String cannotEmulatePropertiesWarning(final List<String> property) {
        return String.format(getLoggingLocale(), cannotEmulatePropertiesWarning$str(), property);
    }
    protected String migrationFailed$str() {
        return "WFLYORB0135: Migration failed, see results for more details.";
    }
    @Override
    public final String migrationFailed() {
        return String.format(getLoggingLocale(), migrationFailed$str());
    }
    protected String expressionMigrationWarning$str() {
        return "WFLYORB0136: The properties %s use expressions. Configuration properties that are used to resolve those expressions should be transformed manually to the new iiop-openjdk subsystem format";
    }
    @Override
    public final String expressionMigrationWarning(final String properties) {
        return String.format(getLoggingLocale(), expressionMigrationWarning$str(), properties);
    }
}
