/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi;

import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.as.jacorb.rmi.AbstractAnalysis;
import org.jboss.as.jacorb.rmi.Util;

public class ClassAnalysis
extends AbstractAnalysis {
    protected Class cls;

    private static String javaNameOfClass(Class cls) {
        if (cls == null) {
            throw JacORBLogger.ROOT_LOGGER.cannotAnalyzeNullClass();
        }
        String s = cls.getName();
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public ClassAnalysis(Class cls, String idlName, String javaName) {
        super(idlName, javaName);
        this.cls = cls;
    }

    public ClassAnalysis(Class cls, String javaName) {
        this(cls, Util.javaToIDLName(javaName), javaName);
    }

    public ClassAnalysis(Class cls) {
        this(cls, ClassAnalysis.javaNameOfClass(cls));
    }

    public Class getCls() {
        return this.cls;
    }
}

