/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jboss.as.jacorb.PropertiesMap;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.as.jacorb.security.Util;
import org.jboss.security.JSSESecurityDomain;

public class DomainServerSocketFactory
implements ServerSocketFactory,
Configurable {
    private SSLContext sslContext;
    private JSSESecurityDomain jsseSecurityDomain;
    private boolean request_mutual_auth = false;
    private boolean require_mutual_auth = false;

    public DomainServerSocketFactory(ORB orb) {
        JacORBLogger.ROOT_LOGGER.traceServerSocketFactoryCreation(this.getClass().getName());
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, 50, null);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress inetAddress) throws IOException {
        this.initSSLContext();
        SSLServerSocketFactory serverSocketFactory = this.sslContext.getServerSocketFactory();
        SSLServerSocket serverSocket = (SSLServerSocket)serverSocketFactory.createServerSocket(port, backlog, inetAddress);
        if (this.jsseSecurityDomain.getProtocols() != null) {
            serverSocket.setEnabledProtocols(this.jsseSecurityDomain.getProtocols());
        }
        if (this.jsseSecurityDomain.getCipherSuites() != null) {
            serverSocket.setEnabledCipherSuites(this.jsseSecurityDomain.getCipherSuites());
        }
        if (this.jsseSecurityDomain.isClientAuth() || this.require_mutual_auth) {
            serverSocket.setNeedClientAuth(true);
        } else {
            serverSocket.setWantClientAuth(this.request_mutual_auth);
        }
        return serverSocket;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String securityDomain = configuration.getAttribute("security-domain");
        if (securityDomain == null) {
            throw JacORBLogger.ROOT_LOGGER.errorConfiguringDomainSF();
        }
        try {
            InitialContext context = new InitialContext();
            this.jsseSecurityDomain = (JSSESecurityDomain)context.lookup("java:jboss/jaas/" + securityDomain + "/jsse");
            JacORBLogger.ROOT_LOGGER.debugJSSEDomainRetrieval(securityDomain);
        }
        catch (NamingException ne) {
            JacORBLogger.ROOT_LOGGER.failedToObtainJSSEDomain(securityDomain);
        }
        if (this.jsseSecurityDomain == null) {
            throw JacORBLogger.ROOT_LOGGER.failedToLookupJSSEDomain();
        }
        String optionName = PropertiesMap.JACORB_PROPS_MAP.get("server-supports");
        short serverSupportedOptions = Short.parseShort(configuration.getAttribute(optionName), 16);
        optionName = PropertiesMap.JACORB_PROPS_MAP.get("server-requires");
        short serverRequiredOptions = Short.parseShort(configuration.getAttribute(optionName), 16);
        if ((serverSupportedOptions & 0x40) != 0) {
            this.request_mutual_auth = true;
        }
        if ((serverRequiredOptions & 0x40) != 0) {
            this.require_mutual_auth = true;
        }
    }

    private void initSSLContext() throws IOException {
        if (this.sslContext != null) {
            return;
        }
        this.sslContext = Util.forDomain(this.jsseSecurityDomain);
    }
}

