/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.logging;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.msc.service.StartException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;

@MessageLogger(projectCode="WFLYORB", length=4)
public interface JacORBLogger
extends BasicLogger {
    public static final JacORBLogger ROOT_LOGGER = (JacORBLogger)Logger.getMessageLogger(JacORBLogger.class, (String)"org.jboss.as.jacorb");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating JacORB Subsystem")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2, value="IOR security config metadata: %s")
    public void debugIORSecurityConfigMetaData(IORSecurityConfigMetaData var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3, value="CSIv2Policy not found in IORInfo")
    public void csiv2PolicyNotFoundInIORInfo();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Error fetching CSIv2Policy")
    public void failedToFetchCSIv2Policy(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5, value="Method createSSLTaggedComponent() called with null metadata")
    public void createSSLTaggedComponentWithNullMetaData();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=6, value="Method createSecurityTaggedComponent() called with null metadata")
    public void createSecurityTaggedComponentWithNullMetaData();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Caught exception while encoding GSSUPMechOID")
    public void caughtExceptionEncodingGSSUPMechOID(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=8, value="receive_reply: got SAS reply, type %d")
    public void traceReceiveReply(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=9, value="receive_exception: got SAS reply, type %d")
    public void traceReceiveException(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=10, value="receive_request: %s")
    public void traceReceiveRequest(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=11, value="Received client authentication token")
    public void authTokenReceived();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=12, value="Received identity token")
    public void identityTokenReceived();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=13, value="send_reply: %s")
    public void traceSendReply(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=14, value="send_exception: %s")
    public void traceSendException(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=15, value="Bound name: %s")
    public void debugBoundName(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16, value="Bound context: %s")
    public void debugBoundContext(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17, value="Unbound: %s")
    public void debugUnboundObject(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18, value="Internal error")
    public void logInternalError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=19, value="Failed to create CORBA naming context")
    public void failedToCreateNamingContext(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Unbind failed for %s")
    public void failedToUnbindObject(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=21, value="Unable to obtain id from object")
    public void failedToObtainIdFromObject(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22, value="Getting default ORB %s")
    public void debugGetDefaultORB(ORB var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=23, value="Creating server socket factory: %s")
    public void traceServerSocketFactoryCreation(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=24, value="Obtained JSSE security domain with name %s")
    public void debugJSSEDomainRetrieval(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Failed to obtain JSSE security domain with name %s")
    public void failedToObtainJSSEDomain(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=26, value="Creating socket factory: %s")
    public void traceSocketFactoryCreation(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=27, value="Starting service %s")
    public void debugServiceStartup(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=28, value="Stopping service %s")
    public void debugServiceStop(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="CORBA Naming Service started")
    public void corbaNamingServiceStarted();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=30, value="Naming: [%s]")
    public void debugNamingServiceIOR(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="CORBA ORB Service started")
    public void corbaORBServiceStarted();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=32, value="Intercepting receive_request_service_contexts, operation: %s")
    public void traceReceiveRequestServiceContexts(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=33, value="Compatibility problem: Class javax.rmi.CORBA.ClassDesc does not conform to the Java(TM) Language to IDL Mapping Specification (01-06-07), section 1.3.5.11")
    public void warnClassDescDoesNotConformToSpec();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=34, value="Could not deactivate IR object")
    public void warnCouldNotDeactivateIRObject(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=35, value="Exception converting CORBA servant to reference")
    public void debugExceptionConvertingServantToReference(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Could not deactivate anonymous IR object")
    public void warnCouldNotDeactivateAnonIRObject(@Cause Throwable var1);

    @Message(id=37, value="SSL support has been enabled but no security domain has been specified")
    public OperationFailedException noSecurityDomainSpecified();

    @Message(id=38, value="Illegal initializer value: %s. Should be one of [security,transactions]")
    public XMLStreamException invalidInitializerConfig(String var1, @Param Location var2);

    @Message(id=39, value="Illegal SSL config option: %s. Should be one of [0.20,40,60]")
    public XMLStreamException invalidSSLConfig(String var1, @Param Location var2);

    @Message(id=40, value="SASCurrent narrow failed")
    public BAD_PARAM sasCurrentNarrowFailed();

    @Message(id=41, value="Unexpected exception")
    public RuntimeException unexpectedException(@Param Throwable var1);

    @Message(id=42, value="Unexpected ContextError in SAS reply")
    public NO_PERMISSION unexpectedContextErrorInSASReply(@Param int var1, @Param CompletionStatus var2);

    @Message(id=43, value="Could not parse SAS reply: %s")
    public MARSHAL errorParsingSASReply(Exception var1, @Param int var2, @Param CompletionStatus var3);

    @Message(id=44, value="Could not register initial reference for SASCurrent")
    public RuntimeException errorRegisteringSASCurrentInitRef(@Param Throwable var1);

    @Message(id=45, value="SAS context does not exist")
    public NO_PERMISSION missingSASContext();

    @Message(id=46, value="Could not decode initial context token")
    public NO_PERMISSION errorDecodingInitContextToken();

    @Message(id=47, value="Could not decode target name in initial context token")
    public NO_PERMISSION errorDecodingTargetInContextToken();

    @Message(id=48, value="Could not decode incoming principal name")
    public NO_PERMISSION errorDecodingPrincipalName();

    @Message(id=49, value="Exception decoding context data in %s")
    public RuntimeException errorDecodingContextData(String var1, @Param Throwable var2);

    @Message(id=50, value="Batch size not numeric: %s")
    public IllegalArgumentException illegalBatchSize(String var1);

    @Message(id=51, value="Error getting binding list")
    public NamingException errorGettingBindingList();

    @Message(id=52, value="Error generating object via object factory")
    public NamingException errorGeneratingObjectViaFactory();

    @Message(id=53, value="Error constructing context: either ORB or NamingContext must be supplied")
    public ConfigurationException errorConstructingCNCtx();

    @Message(id=54, value="%s does not name a NamingContext")
    public ConfigurationException notANamingContext(String var1);

    @Message(id=55, value="Cannot convert IOR to NamingContext: %s")
    public ConfigurationException errorConvertingIORToNamingCtx(String var1);

    @Message(id=56, value="ORB.resolve_initial_references(\"NameService\") does not return a NamingContext")
    public ConfigurationException errorResolvingNSInitRef();

    @Message(id=57, value="COS Name Service not registered with ORB under the name 'NameService'")
    public NamingException cosNamingNotRegisteredCorrectly();

    @Message(id=58, value="Cannot connect to ORB")
    public NamingException errorConnectingToORB();

    @Message(id=59, value="Invalid IOR or URL: %s")
    public NamingException invalidURLOrIOR(String var1);

    @Message(id=60, value="Invalid object reference:  %s")
    public NamingException invalidObjectReference(String var1);

    @Message(id=61, value="%s does not contain an IOR")
    public ConfigurationException urlDoesNotContainIOR(String var1);

    @Message(id=62, value="Only instances of org.omg.CORBA.Object can be bound")
    public IllegalArgumentException notACorbaObject();

    @Message(id=63, value="No object reference bound for specified name")
    public NamingException noReferenceFound();

    @Message(id=64, value="Invalid empty name")
    public InvalidNameException invalidEmptyName();

    @Message(id=65, value="%s: unescaped \\ at end of component")
    public InvalidNameException unescapedCharacter(String var1);

    @Message(id=66, value="%s: Invalid character being escaped")
    public InvalidNameException invalidEscapedCharacter(String var1);

    @Message(id=67, value="Invalid %s URL: %s")
    public MalformedURLException invalidURL(String var1, String var2);

    @Message(id=68, value="Problem with PortableRemoteObject.toStub(); object not exported or stub not found")
    public ConfigurationException problemInvokingPortableRemoteObjectToStub();

    @Message(id=69, value="Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)")
    public ConfigurationException cannotInvokePortableRemoteObjectToStub();

    @Message(id=70, value="No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)")
    public IllegalStateException noMethodDefForPortableRemoteObjectToStub();

    @Message(id=71, value="Problem invoking javax.rmi.CORBA.Stub.connect()")
    public ConfigurationException problemInvokingStubConnect();

    @Message(id=72, value="Cannot invoke javax.rmi.CORBA.Stub.connect()")
    public ConfigurationException cannotInvokeStubConnect();

    @Message(id=73, value="No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)")
    public IllegalStateException noMethodDefForStubConnect();

    @Message(id=74, value="Invalid IIOP URL version: %s")
    public MalformedURLException invalidIIOPURLVersion(String var1);

    @Message(id=75, value="javax.rmi packages not available")
    public ConfigurationException unavailableRMIPackages();

    @Message(id=76, value="ISO-Latin-1 decoder unavailable")
    public MalformedURLException unavailableISOLatin1Decoder();

    @Message(id=77, value="Invalid URI encoding: %s")
    public MalformedURLException invalidURIEncoding(String var1);

    @Message(id=80, value="keyManager[] is null for security domain %s")
    public IOException errorObtainingKeyManagers(String var1);

    @Message(id=81, value="Failed to get SSL context")
    public IOException failedToGetSSLContext(@Param Throwable var1);

    @Message(id=82, value="Failed to start the JBoss Corba Naming Service")
    public StartException failedToStartJBossCOSNaming(@Param Throwable var1);

    @Message(id=83, value="Foreign Transaction")
    public UnsupportedOperationException foreignTransaction();

    @Message(id=84, value="Exception raised during encoding")
    public RuntimeException errorEncodingContext(@Param Throwable var1);

    @Message(id=85, value="Exception getting slot in TxServerInterceptor")
    public RuntimeException errorGettingSlotInTxInterceptor(@Param Throwable var1);

    @Message(id=86, value="Exception setting slot in TxServerInterceptor")
    public RuntimeException errorSettingSlotInTxInterceptor(@Param Throwable var1);

    @Message(id=87, value="Cannot analyze a null class")
    public IllegalArgumentException cannotAnalyzeNullClass();

    @Message(id=88, value="Bad type for a constant: %s")
    public IllegalArgumentException badConstantType(String var1);

    @Message(id=89, value="Cannot analyze special class: %s")
    public IllegalArgumentException cannotAnalyzeSpecialClass(String var1);

    @Message(id=90, value="Not an accessor: %s")
    public IllegalArgumentException notAnAccessor(String var1);

    @Message(id=91, value="Not a class or interface: %s")
    public IllegalArgumentException notAnClassOrInterface(String var1);

    @Message(id=92, value="Class %s is not an interface")
    public IllegalArgumentException notAnInterface(String var1);

    @Message(id=93, value="Not a primitive type: %s")
    public IllegalArgumentException notAPrimitive(String var1);

    @Message(id=97, value="Name cannot be null, empty or qualified")
    public IllegalArgumentException nameCannotBeNullEmptyOrQualified();

    @Message(id=98, value="Primitive types have no IR IDs")
    public IllegalArgumentException primitivesHaveNoIRIds();

    @Message(id=99, value="No SHA message digest available")
    public RuntimeException unavailableSHADigest(@Param Throwable var1);

    @Message(id=100, value="Unknown primitive type: %s")
    public RuntimeException unknownPrimitiveType(String var1);

    @Message(id=101, value="Cannot analyze java.lang.String: it is a special case")
    public IllegalArgumentException cannotAnalyzeStringType();

    @Message(id=102, value="Cannot analyze java.lang.Class: it is a special case")
    public IllegalArgumentException cannotAnalyzeClassType();

    @Message(id=105, value="Error loading class %s")
    public RuntimeException errorLoadingClass(String var1, @Param Throwable var2);

    @Message(id=106, value="No read method in helper class %s")
    public RuntimeException noReadMethodInHelper(String var1, @Param Throwable var2);

    @Message(id=107, value="No write method in helper class %s")
    public RuntimeException noWriteMethodInHelper(String var1, @Param Throwable var2);

    @Message(id=108, value="Error unmarshaling %s")
    public RuntimeException errorUnmarshaling(Class<?> var1, @Param Throwable var2);

    @Message(id=109, value="Error marshaling %s")
    public RuntimeException errorMarshaling(Class<?> var1, @Param Throwable var2);

    @Message(id=110, value="Cannot obtain exception repository id for %s")
    public RuntimeException cannotObtainExceptionRepositoryID(String var1, @Param Throwable var2);

    @Message(id=111, value="Cannot marshal parameter: unexpected number of parameters")
    public RuntimeException errorMashalingParams();

    @Message(id=112, value="Cannot change RMI/IIOP mapping")
    public BAD_INV_ORDER cannotChangeRMIIIOPMapping();

    @Message(id=113, value="Bad kind %d for TypeCode")
    public RuntimeException badKindForTypeCode(int var1);

    @Message(id=114, value="UTF-8 encoding not supported")
    public RuntimeException unsupportedUTF8Encoding();

    @Message(id=117, value="Invalid null class")
    public IllegalArgumentException invalidNullClass();

    @Message(id=123, value="Cannot destroy RMI/IIOP mapping")
    public BAD_INV_ORDER cannotDestroyRMIIIOPMapping();

    @Message(id=127, value="Failed to resolve initial reference %s")
    public StartException errorResolvingInitRef(String var1, @Param Throwable var2);

    @Message(id=128, value="Failed to create POA from parent")
    public StartException errorCreatingPOAFromParent(@Param Throwable var1);

    @Message(id=129, value="Unable to instantiate POA: either the running ORB or the parent POA must be specified")
    public StartException invalidPOACreationArgs();

    @Message(id=130, value="Failed to activate POA")
    public StartException errorActivatingPOA(@Param Throwable var1);

    @Message(id=131, value="Cannot use the value 'client' for 'security'. Instead set 'security' to be 'off' and set both the 'org.omg.PortableInterceptor.ORBInitializerClass.org.jboss.as.jacorb.csiv2.CSIv2Initializer' and 'org.omg.PortableInterceptor.ORBInitializerClass.org.jboss.as.jacorb.csiv2.SASClientInitializer' properties to be \"\"")
    public String cannotUseSecurityClient();

    @Message(id=132, value="Properties %s cannot be emulated using OpenJDK ORB and are not supported")
    public OperationFailedException cannotEmulateProperties(List<String> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=133, value="JacORB is not used as an ORB implementation anymore. JacORB subsystem would be emulated using the current OpenJDK ORB implementation. Ability to emulate legacy JacORB configurations using OpenJDK ORB will be removed in future.")
    public void jacorbEmulationWarning();
}

