package org.jboss.as.jaxrs.logging;

import java.util.Locale;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.StringBuilder;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-03T23:21:35-0500")
public class JaxrsLogger_$logger extends DelegatingBasicLogger implements JaxrsLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JaxrsLogger_$logger.class.getName();
    public JaxrsLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void classAnnotationNotFound(final String annotation, final AnnotationTarget target) {
        super.log.logf(FQCN, WARN, null, classAnnotationNotFound$str(), annotation, target);
    }
    private static final String classAnnotationNotFound = "WFLYRS0001: %s annotation not on Class: %s";
    protected String classAnnotationNotFound$str() {
        return classAnnotationNotFound;
    }
    @Override
    public final void classOrMethodAnnotationNotFound(final String annotation, final AnnotationTarget target) {
        super.log.logf(FQCN, WARN, null, classOrMethodAnnotationNotFound$str(), annotation, target);
    }
    private static final String classOrMethodAnnotationNotFound = "WFLYRS0002: %s annotation not on Class or Method: %s";
    protected String classOrMethodAnnotationNotFound$str() {
        return classOrMethodAnnotationNotFound;
    }
    @Override
    public final void moreThanOneServletMapping(final String servletName, final String pattern) {
        super.log.logf(FQCN, ERROR, null, moreThanOneServletMapping$str(), servletName, pattern);
    }
    private static final String moreThanOneServletMapping = "WFLYRS0003: More than one mapping found for JAX-RS servlet: %s the second mapping %s will not work";
    protected String moreThanOneServletMapping$str() {
        return moreThanOneServletMapping;
    }
    @Override
    public final void noServletMappingFound(final String servletName) {
        super.log.logf(FQCN, WARN, null, noServletMappingFound$str(), servletName);
    }
    private static final String noServletMappingFound = "WFLYRS0004: No Servlet mappings found for JAX-RS application: %s either annotate it with @ApplicationPath or add a servlet-mapping in web.xml";
    protected String noServletMappingFound$str() {
        return noServletMappingFound;
    }
    @Override
    public final void resteasyScanWarning(final String param) {
        super.log.logf(FQCN, WARN, null, resteasyScanWarning$str(), param);
    }
    private static final String resteasyScanWarning = "WFLYRS0005: %s found and ignored in web.xml. This is not necessary, as Resteasy will use the container integration in the JAX-RS 1.1 specification in section 2.3.2";
    protected String resteasyScanWarning$str() {
        return resteasyScanWarning;
    }
    private static final String cannotLoadApplicationClass = "WFLYRS0006: Could not load JAX-RS Application class";
    protected String cannotLoadApplicationClass$str() {
        return cannotLoadApplicationClass;
    }
    @Override
    public final DeploymentUnitProcessingException cannotLoadApplicationClass(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotLoadApplicationClass$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moreThanOneApplicationClassFound = "WFLYRS0007: More than one Application class found in deployment %s and %s";
    protected String moreThanOneApplicationClassFound$str() {
        return moreThanOneApplicationClassFound;
    }
    @Override
    public final DeploymentUnitProcessingException moreThanOneApplicationClassFound(final Class<? extends javax.ws.rs.core.Application> app1, final Class<? extends javax.ws.rs.core.Application> app2) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), moreThanOneApplicationClassFound$str(), app1, app2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneApplicationClassAllowed = "WFLYRS0008: Only one JAX-RS Application Class allowed. %s";
    protected String onlyOneApplicationClassAllowed$str() {
        return onlyOneApplicationClassAllowed;
    }
    @Override
    public final String onlyOneApplicationClassAllowed(final StringBuilder sb) {
        return String.format(getLoggingLocale(), onlyOneApplicationClassAllowed$str(), sb);
    }
    private static final String conflictUrlMapping = "WFLYRS0009: Please use either @ApplicationPath or servlet mapping for url path config.";
    protected String conflictUrlMapping$str() {
        return conflictUrlMapping;
    }
    @Override
    public final String conflictUrlMapping() {
        return String.format(getLoggingLocale(), conflictUrlMapping$str());
    }
    private static final String typeNameNotAnEjbView = "WFLYRS0010: JAX-RS resource %s does not correspond to a view on the EJB %s. @Path annotations can only be placed on classes or interfaces that represent a local, remote or no-interface view of an EJB.";
    protected String typeNameNotAnEjbView$str() {
        return typeNameNotAnEjbView;
    }
    @Override
    public final DeploymentUnitProcessingException typeNameNotAnEjbView(final java.util.List<Class<?>> type, final String ejbName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), typeNameNotAnEjbView$str(), type, ejbName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParamValue = "WFLYRS0011: Invalid value for parameter %s: %s";
    protected String invalidParamValue$str() {
        return invalidParamValue;
    }
    @Override
    public final DeploymentUnitProcessingException invalidParamValue(final String param, final String value) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidParamValue$str(), param, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSpringIntegrationJar = "WFLYRS0012: No spring integration jar found";
    protected String noSpringIntegrationJar$str() {
        return noSpringIntegrationJar;
    }
    @Override
    public final DeploymentUnitProcessingException noSpringIntegrationJar() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), noSpringIntegrationJar$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void disablePropertyDeprecated() {
        super.log.logf(FQCN, WARN, null, disablePropertyDeprecated$str());
    }
    private static final String disablePropertyDeprecated = "WFLYRS0013: The context param org.jboss.as.jaxrs.disableSpringIntegration is deprecated, and will be removed in a future release. Please use org.jboss.as.jaxrs.enableSpringIntegration instead";
    protected String disablePropertyDeprecated$str() {
        return disablePropertyDeprecated;
    }
    @Override
    public final void failedToRegisterManagementViewForRESTResources(final String resClass, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToRegisterManagementViewForRESTResources$str(), resClass);
    }
    private static final String failedToRegisterManagementViewForRESTResources = "WFLYRS0014: Failed to register management view for REST resource class: %s";
    protected String failedToRegisterManagementViewForRESTResources$str() {
        return failedToRegisterManagementViewForRESTResources;
    }
    @Override
    public final void noServletDeclaration(final String archiveName) {
        super.log.logf(FQCN, WARN, null, noServletDeclaration$str(), archiveName);
    }
    private static final String noServletDeclaration = "WFLYRS0015: No Servlet declaration found for JAX-RS application.  In %s either provide a class that extends javax.ws.rs.core.Application or declare a servlet class in web.xml.";
    protected String noServletDeclaration$str() {
        return noServletDeclaration;
    }
    @Override
    public final void resteasyVersion(final String version) {
        super.log.logf(FQCN, INFO, null, resteasyVersion$str(), version);
    }
    private static final String resteasyVersion = "WFLYRS0016: RESTEasy version %s";
    protected String resteasyVersion$str() {
        return resteasyVersion;
    }
}
