package org.jboss.as.jdr.logger;

import java.nio.file.Path;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-03-27T17:23:14+0100")
public class JdrLogger_$logger extends DelegatingBasicLogger implements JdrLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JdrLogger_$logger.class.getName();
    public JdrLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void startingCollection() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, startingCollection$str());
    }
    private static final String startingCollection = "WFLYJDR0001: Starting creation of a JBoss Diagnostic Report (JDR).";
    protected String startingCollection$str() {
        return startingCollection;
    }
    @Override
    public final void endingCollection() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, endingCollection$str());
    }
    private static final String endingCollection = "WFLYJDR0002: Completed creation of a JBoss Diagnostic Report (JDR).";
    protected String endingCollection$str() {
        return endingCollection;
    }
    @Override
    public final void jbossHomeNotSet() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, null, jbossHomeNotSet$str());
    }
    private static final String jbossHomeNotSet = "WFLYJDR0003: Unable to create JDR report, JBoss Home directory cannot be determined.";
    protected String jbossHomeNotSet$str() {
        return jbossHomeNotSet;
    }
    @Override
    public final void pythonExceptionEncountered(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, pythonExceptionEncountered$str());
    }
    private static final String pythonExceptionEncountered = "WFLYJDR0004: JDR python interpreter encountered an exception.";
    protected String pythonExceptionEncountered$str() {
        return pythonExceptionEncountered;
    }
    @Override
    public final void urlDecodeExceptionEncountered(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, urlDecodeExceptionEncountered$str());
    }
    private static final String urlDecodeExceptionEncountered = "WFLYJDR0005: Unable to decode a url while creating JDR report.";
    protected String urlDecodeExceptionEncountered$str() {
        return urlDecodeExceptionEncountered;
    }
    @Override
    public final void contribNotADirectory() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, contribNotADirectory$str());
    }
    private static final String contribNotADirectory = "WFLYJDR0006: Plugin contrib location is not a directory.  Ignoring.";
    protected String contribNotADirectory$str() {
        return contribNotADirectory;
    }
    private static final String couldNotCreateZipfile = "WFLYJDR0007: Could not create zipfile.";
    protected String couldNotCreateZipfile$str() {
        return couldNotCreateZipfile;
    }
    @Override
    public final String couldNotCreateZipfile() {
        return String.format(couldNotCreateZipfile$str());
    }
    private static final String couldNotConfigureJDR = "WFLYJDR0008: Could not configure JDR. At least one configuration step failed.";
    protected String couldNotConfigureJDR$str() {
        return couldNotConfigureJDR;
    }
    @Override
    public final String couldNotConfigureJDR() {
        return String.format(couldNotConfigureJDR$str());
    }
    private static final String noCommandsToRun = "WFLYJDR0009: No JDR commands were loaded. Be sure that a valid Plugin class is specified in plugins.properties.";
    protected String noCommandsToRun$str() {
        return noCommandsToRun;
    }
    @Override
    public final String noCommandsToRun() {
        return String.format(noCommandsToRun$str());
    }
    private static final String varNull = "WFLYJDR0010: Parameter %s may not be null.";
    protected String varNull$str() {
        return varNull;
    }
    @Override
    public final IllegalArgumentException varNull(final String var) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(varNull$str(), var));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotFindJDRPropertiesFile() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, null, couldNotFindJDRPropertiesFile$str());
    }
    private static final String couldNotFindJDRPropertiesFile = "WFLYJDR0011: Could not find JDR properties file.";
    protected String couldNotFindJDRPropertiesFile$str() {
        return couldNotFindJDRPropertiesFile;
    }
    @Override
    public final void couldNotCreateJDRPropertiesFile(final IOException ioex, final Path path) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, ioex, couldNotCreateJDRPropertiesFile$str(), path);
    }
    private static final String couldNotCreateJDRPropertiesFile = "WFLYJDR0012: Could not create JDR properties file at %s";
    protected String couldNotCreateJDRPropertiesFile$str() {
        return couldNotCreateJDRPropertiesFile;
    }
    private static final String jdrHelpMessage = "Display this message and exit";
    protected String jdrHelpMessage$str() {
        return jdrHelpMessage;
    }
    @Override
    public final String jdrHelpMessage() {
        return String.format(jdrHelpMessage$str());
    }
    private static final String jdrHostnameMessage = "hostname that the management api is bound to. (default: localhost)";
    protected String jdrHostnameMessage$str() {
        return jdrHostnameMessage;
    }
    @Override
    public final String jdrHostnameMessage() {
        return String.format(jdrHostnameMessage$str());
    }
    private static final String jdrPortMessage = "port that the management api is bound to. (default: 9990)";
    protected String jdrPortMessage$str() {
        return jdrPortMessage;
    }
    @Override
    public final String jdrPortMessage() {
        return String.format(jdrPortMessage$str());
    }
    private static final String jdrProtocolMessage = "Protocol that is used to connect. Can be remote, http or https (default: http)";
    protected String jdrProtocolMessage$str() {
        return jdrProtocolMessage;
    }
    @Override
    public final String jdrProtocolMessage() {
        return String.format(jdrProtocolMessage$str());
    }
    private static final String jdrConfigMessage = "Configuration file of the server if it is not running.";
    protected String jdrConfigMessage$str() {
        return jdrConfigMessage;
    }
    @Override
    public final String jdrConfigMessage() {
        return String.format(jdrConfigMessage$str());
    }
    private static final String jdrDescriptionMessage = "JBoss Diagnostic Reporter (JDR) is a subsystem built to collect information to aid in troubleshooting. The jdr script is a utility for generating JDR reports.";
    protected String jdrDescriptionMessage$str() {
        return jdrDescriptionMessage;
    }
    @Override
    public final String jdrDescriptionMessage() {
        return String.format(jdrDescriptionMessage$str());
    }
}
