/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportService;
import org.jboss.as.jdr.logger.JdrLogger;

public class CommandLineMain {
    private static CommandLineParser parser = new GnuParser();
    private static Options options = new Options();
    private static HelpFormatter formatter = new HelpFormatter();
    private static final String usage = "jdr.{sh,bat} [options]";

    public static void main(String[] args) {
        String port = "9990";
        String host = "localhost";
        String protocol = "http-remoting";
        try {
            CommandLine line = parser.parse(options, args, false);
            if (line.hasOption("help")) {
                formatter.printHelp(usage, options);
                return;
            }
            if (line.hasOption("host")) {
                host = line.getOptionValue("host");
            }
            if (line.hasOption("port")) {
                port = line.getOptionValue("port");
            }
            if (line.hasOption("protocol")) {
                protocol = line.getOptionValue("protocol");
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp(usage, options);
            return;
        }
        System.out.println("Initializing JBoss Diagnostic Reporter...");
        JdrReportService reportService = new JdrReportService();
        JdrReport response = null;
        try {
            response = reportService.standaloneCollect(protocol, host, port);
            System.out.println("JDR started: " + response.getStartTime().toString());
            System.out.println("JDR ended: " + response.getEndTime().toString());
            System.out.println("JDR location: " + response.getLocation());
        }
        catch (OperationFailedException e) {
            System.out.println("Failed to complete the JDR report: " + e.getMessage());
        }
        System.exit(0);
    }

    static {
        options.addOption("h", "help", false, JdrLogger.ROOT_LOGGER.jdrHelpMessage());
        options.addOption("H", "host", true, JdrLogger.ROOT_LOGGER.jdrHostnameMessage());
        options.addOption("p", "port", true, JdrLogger.ROOT_LOGGER.jdrPortMessage());
        options.addOption("s", "protocol", true, JdrLogger.ROOT_LOGGER.jdrProtocolMessage());
    }
}

