/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.beanmanager;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import java.util.ArrayList;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;

public class BeanManagerAfterDeploymentValidation
implements Extension {
    private boolean afterDeploymentValidation = false;
    private final ArrayList<DeferredCall> deferredCalls = new ArrayList();

    public BeanManagerAfterDeploymentValidation(boolean afterDeploymentValidation) {
        this.afterDeploymentValidation = afterDeploymentValidation;
    }

    public BeanManagerAfterDeploymentValidation() {
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        this.markPersistenceUnitAvailable();
    }

    public synchronized void register(PersistenceProviderAdaptor persistenceProviderAdaptor, Object wrapperBeanManagerLifeCycle) {
        if (this.afterDeploymentValidation) {
            persistenceProviderAdaptor.markPersistenceUnitAvailable(wrapperBeanManagerLifeCycle);
        } else {
            this.deferredCalls.add(new DeferredCall(persistenceProviderAdaptor, wrapperBeanManagerLifeCycle));
        }
    }

    public synchronized void markPersistenceUnitAvailable() {
        this.afterDeploymentValidation = true;
        for (DeferredCall deferredCall : this.deferredCalls) {
            deferredCall.markPersistenceUnitAvailable();
        }
        this.deferredCalls.clear();
    }

    private static class DeferredCall {
        private final PersistenceProviderAdaptor persistenceProviderAdaptor;
        private final Object wrapperBeanManagerLifeCycle;

        DeferredCall(PersistenceProviderAdaptor persistenceProviderAdaptor, Object wrapperBeanManagerLifeCycle) {
            this.persistenceProviderAdaptor = persistenceProviderAdaptor;
            this.wrapperBeanManagerLifeCycle = wrapperBeanManagerLifeCycle;
        }

        void markPersistenceUnitAvailable() {
            this.persistenceProviderAdaptor.markPersistenceUnitAvailable(this.wrapperBeanManagerLifeCycle);
        }
    }
}

