/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.management;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jpa.management.EntityManagerFactoryLookup;
import org.jboss.as.jpa.management.PathWrapper;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.messages.JpaMessages;
import org.jboss.dmr.ModelNode;
import org.jipijapa.management.spi.EntityManagerFactoryAccess;
import org.jipijapa.management.spi.Statistics;

public class DynamicManagementStatisticsResource
extends PlaceholderResource.PlaceholderResourceEntry {
    private final String puName;
    private final ModelNode model = new ModelNode();
    private final Statistics statistics;
    private final String identificationLabel;
    private final EntityManagerFactoryLookup entityManagerFactoryLookup;

    public DynamicManagementStatisticsResource(Statistics statistics, String puName, String identificationLabel, EntityManagerFactoryLookup entityManagerFactoryLookup) {
        super(identificationLabel, puName);
        this.puName = puName;
        this.statistics = statistics;
        this.identificationLabel = identificationLabel;
        this.entityManagerFactoryLookup = entityManagerFactoryLookup;
    }

    public ModelNode getModel() {
        return this.model;
    }

    public boolean isModelDefined() {
        return this.model.isDefined();
    }

    public boolean hasChild(PathElement element) {
        try {
            Statistics statistics = this.getStatistics();
            if (statistics.getChildrenNames().contains(element.getKey())) {
                Statistics childStatistics = statistics.getChild(element.getKey());
                return childStatistics != null && childStatistics.getDynamicChildrenNames((EntityManagerFactoryAccess)this.entityManagerFactoryLookup, (org.jipijapa.management.spi.PathAddress)PathWrapper.path(this.puName)).contains(element.getValue());
            }
            return super.hasChild(element);
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
            return false;
        }
    }

    public Resource getChild(PathElement element) {
        try {
            Statistics statistics = this.getStatistics();
            if (statistics.getChildrenNames().contains(element.getKey())) {
                Statistics childStatistics = statistics.getChild(element.getKey());
                return childStatistics != null && childStatistics.getDynamicChildrenNames((EntityManagerFactoryAccess)this.entityManagerFactoryLookup, (org.jipijapa.management.spi.PathAddress)PathWrapper.path(this.puName)).contains(element.getValue()) ? PlaceholderResource.INSTANCE : null;
            }
            return super.getChild(element);
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
            return super.getChild(element);
        }
    }

    public Resource requireChild(PathElement element) {
        try {
            Statistics statistics = this.getStatistics();
            if (statistics.getChildrenNames().contains(element.getKey())) {
                Statistics childStatistics = statistics.getChild(element.getKey());
                if (childStatistics != null && childStatistics.getDynamicChildrenNames((EntityManagerFactoryAccess)this.entityManagerFactoryLookup, (org.jipijapa.management.spi.PathAddress)PathWrapper.path(this.puName)).contains(element.getValue())) {
                    return PlaceholderResource.INSTANCE;
                }
                throw new Resource.NoSuchResourceException(element);
            }
            return super.requireChild(element);
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
            return super.requireChild(element);
        }
    }

    public boolean hasChildren(String childType) {
        try {
            Statistics statistics = this.getStatistics();
            if (statistics.getChildrenNames().contains(childType)) {
                Statistics childStatistics = statistics.getChild(childType);
                return childStatistics != null && childStatistics.getNames().size() > 0;
            }
            return super.hasChildren(childType);
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
            return false;
        }
    }

    public Resource navigate(PathAddress address) {
        Statistics statistics = this.getStatistics();
        if (address.size() > 0 && statistics.getChildrenNames().contains(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            return PlaceholderResource.INSTANCE;
        }
        return super.navigate(address);
    }

    public Set<String> getChildTypes() {
        try {
            HashSet<String> result = new HashSet<String>(super.getChildTypes());
            Statistics statistics = this.getStatistics();
            result.addAll(statistics.getChildrenNames());
            return result;
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
            return Collections.EMPTY_SET;
        }
    }

    public Set<String> getChildrenNames(String childType) {
        try {
            Statistics statistics = this.getStatistics();
            if (statistics.getChildrenNames().contains(childType)) {
                Statistics childStatistics = statistics.getChild(childType);
                HashSet<String> result = new HashSet<String>();
                for (String name : childStatistics.getDynamicChildrenNames((EntityManagerFactoryAccess)this.entityManagerFactoryLookup, (org.jipijapa.management.spi.PathAddress)PathWrapper.path(this.puName))) {
                    result.add(name);
                }
                return result;
            }
            return super.getChildrenNames(childType);
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
            return Collections.EMPTY_SET;
        }
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        try {
            Statistics statistics = this.getStatistics();
            if (statistics.getChildrenNames().contains(childType)) {
                HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
                Statistics childStatistics = statistics.getChild(childType);
                for (String name : childStatistics.getDynamicChildrenNames((EntityManagerFactoryAccess)this.entityManagerFactoryLookup, (org.jipijapa.management.spi.PathAddress)PathWrapper.path(this.puName))) {
                    result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry(childType, name));
                }
                return result;
            }
            return super.getChildren(childType);
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
            return Collections.EMPTY_SET;
        }
    }

    public void registerChild(PathElement address, Resource resource) {
        try {
            Statistics statistics = this.getStatistics();
            if (statistics.getChildrenNames().contains(address.getKey())) {
                throw JpaMessages.MESSAGES.resourcesOfTypeCannotBeRegistered(address.getKey());
            }
            super.registerChild(address, resource);
        }
        catch (IllegalStateException e) {
            JpaLogger.JPA_LOGGER.unexpectedStatisticsProblem(e);
        }
    }

    public Resource removeChild(PathElement address) {
        Statistics statistics = this.getStatistics();
        if (statistics.getChildrenNames().contains(address.getKey())) {
            throw JpaMessages.MESSAGES.resourcesOfTypeCannotBeRemoved(address.getKey());
        }
        return super.removeChild(address);
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public DynamicManagementStatisticsResource clone() {
        return new DynamicManagementStatisticsResource(this.statistics, this.puName, this.identificationLabel, this.entityManagerFactoryLookup);
    }

    private Statistics getStatistics() {
        return this.statistics;
    }
}

