/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor.secondLevelCache;

import java.security.AccessController;
import java.util.Properties;
import java.util.UUID;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.jpa.processor.secondLevelCache.CacheDeploymentListener;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.spi.EventListener;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class InfinispanCacheDeploymentListener
implements EventListener {
    public static final String CACHE_TYPE = "cachetype";
    public static final String CACHE_PRIVATE = "private";
    public static final String CONTAINER = "container";
    public static final String COLLECTION = "collection";
    public static final String ENTITY = "entity";
    public static final String NAME = "name";
    public static final String QUERY = "query";
    public static final String TIMESTAMPS = "timestamps";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";

    public void beforeEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public void afterEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public Wrapper startCache(Classification classification, Properties properties) throws Exception {
        EmbeddedCacheManager embeddedCacheManager;
        ServiceName serviceName;
        String cache_type = properties.getProperty(CACHE_TYPE);
        String container = properties.getProperty(CONTAINER);
        if (CACHE_PRIVATE.equals(cache_type)) {
            String name = properties.getProperty(NAME);
            serviceName = ServiceName.JBOSS.append(new String[]{DEFAULT_CACHE_CONTAINER, name != null ? name : UUID.randomUUID().toString()});
            ServiceContainer target = InfinispanCacheDeploymentListener.currentServiceContainer();
            InjectedValue manager = new InjectedValue();
            ServiceBuilder builder = target.addService(serviceName, (Service)new ValueService((Value)manager)).addDependency(EmbeddedCacheManagerService.getServiceName((String)container), EmbeddedCacheManager.class, (Injector)manager).setInitialMode(ServiceController.Mode.ACTIVE);
            embeddedCacheManager = (EmbeddedCacheManager)ServiceContainerHelper.getValue((ServiceController)builder.install());
        } else {
            serviceName = EmbeddedCacheManagerService.getServiceName((String)container);
            ServiceContainer registry = InfinispanCacheDeploymentListener.currentServiceContainer();
            embeddedCacheManager = (EmbeddedCacheManager)registry.getRequiredService(serviceName).getValue();
        }
        return new CacheWrapper(embeddedCacheManager, serviceName);
    }

    public void addCacheDependencies(Classification classification, Properties properties) {
        String container = properties.getProperty(CONTAINER);
        String entity = properties.getProperty(ENTITY);
        String collection = properties.getProperty(COLLECTION);
        String query = properties.getProperty(QUERY);
        String timestamps = properties.getProperty(TIMESTAMPS);
        CacheDeploymentListener.getInternalDeploymentServiceBuilder().addDependency(ServiceBuilder.DependencyType.OPTIONAL, ChannelService.getServiceName((String)container));
        CacheDeploymentListener.getInternalDeploymentServiceBuilder().addDependency(CacheConfigurationService.getServiceName((String)container, (String)entity));
        CacheDeploymentListener.getInternalDeploymentServiceBuilder().addDependency(CacheConfigurationService.getServiceName((String)container, (String)collection));
        if (query != null) {
            CacheDeploymentListener.getInternalDeploymentServiceBuilder().addDependency(CacheConfigurationService.getServiceName((String)container, (String)timestamps));
            CacheDeploymentListener.getInternalDeploymentServiceBuilder().addDependency(CacheConfigurationService.getServiceName((String)container, (String)query));
        }
    }

    public void stopCache(Classification classification, Wrapper wrapper, boolean ignoreStop) {
        if (!ignoreStop) {
            CacheWrapper cacheWrapper = (CacheWrapper)wrapper;
            ServiceContainerHelper.remove((ServiceController)InfinispanCacheDeploymentListener.currentServiceContainer().getRequiredService(cacheWrapper.serviceName));
        }
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static class CacheWrapper
    implements Wrapper {
        private final EmbeddedCacheManager embeddedCacheManager;
        private final ServiceName serviceName;

        public CacheWrapper(EmbeddedCacheManager embeddedCacheManager, ServiceName serviceName) {
            this.embeddedCacheManager = embeddedCacheManager;
            this.serviceName = serviceName;
        }

        public Object getValue() {
            return this.embeddedCacheManager;
        }
    }
}

