/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jsf.deployment.JSFModuleIdFactory;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.WebCommonMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.vfs.VirtualFile;

public class JSFVersionProcessor
implements DeploymentUnitProcessor {
    public static final String JSF_CONFIG_NAME_PARAM = "org.jboss.jbossfaces.JSF_CONFIG_NAME";
    public static final String WAR_BUNDLES_JSF_IMPL_PARAM = "org.jboss.jbossfaces.WAR_BUNDLES_JSF_IMPL";
    private static final DotName[] JSF_ANNOTATIONS = new DotName[]{DotName.createSimple((String)"javax.faces.view.facelets.FaceletsResourceResolver"), DotName.createSimple((String)"javax.faces.component.behavior.FacesBehavior"), DotName.createSimple((String)"javax.faces.render.FacesBehaviorRenderer"), DotName.createSimple((String)"javax.faces.component.FacesComponent"), DotName.createSimple((String)"javax.faces.convert.FacesConverter"), DotName.createSimple((String)"javax.faces.annotation.FacesConfig"), DotName.createSimple((String)"javax.faces.validator.FacesValidator"), DotName.createSimple((String)"javax.faces.event.ListenerFor"), DotName.createSimple((String)"javax.faces.event.ListenersFor"), DotName.createSimple((String)"javax.faces.bean.ManagedBean"), DotName.createSimple((String)"javax.faces.event.NamedEvent"), DotName.createSimple((String)"javax.faces.application.ResourceDependencies"), DotName.createSimple((String)"javax.faces.application.ResourceDependency")};
    private static final DotName[] JSF_INTERFACES = new DotName[]{DotName.createSimple((String)"javax.faces.convert.Converter"), DotName.createSimple((String)"javax.faces.event.PhaseListener"), DotName.createSimple((String)"javax.faces.render.Renderer"), DotName.createSimple((String)"javax.faces.component.UIComponent"), DotName.createSimple((String)"javax.faces.validator.Validator")};
    private static final String META_INF_FACES = "META-INF/faces-config.xml";
    private static final String WEB_INF_FACES = "WEB-INF/faces-config.xml";
    private static final String JAVAX_FACES_WEBAPP_FACES_SERVLET = "javax.faces.webapp.FacesServlet";
    private static final String CONFIG_FILES = "javax.faces.application.CONFIG_FILES";

    public JSFVersionProcessor(String jsfSlot) {
        JSFModuleIdFactory.getInstance().setDefaultSlot(jsfSlot);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (!this.shouldJsfActivate(deploymentUnit, metaData)) {
            JsfVersionMarker.setVersion(deploymentUnit, "NONE");
            return;
        }
        if (metaData == null) {
            return;
        }
        ArrayList contextParams = new ArrayList();
        if (metaData.getWebMetaData() != null && metaData.getWebMetaData().getContextParams() != null) {
            contextParams.addAll(metaData.getWebMetaData().getContextParams());
        }
        if (metaData.getWebFragmentsMetaData() != null) {
            for (WebFragmentMetaData fragmentMetaData : metaData.getWebFragmentsMetaData().values()) {
                if (fragmentMetaData.getContextParams() == null) continue;
                contextParams.addAll(fragmentMetaData.getContextParams());
            }
        }
        for (ParamValueMetaData param : contextParams) {
            if (param.getParamName().equals(WAR_BUNDLES_JSF_IMPL_PARAM) && param.getParamValue() != null && param.getParamValue().toLowerCase(Locale.ENGLISH).equals("true")) {
                JsfVersionMarker.setVersion(topLevelDeployment, "WAR_BUNDLES_JSF_IMPL");
                break;
            }
            if (!param.getParamName().equals(JSF_CONFIG_NAME_PARAM)) continue;
            JsfVersionMarker.setVersion(topLevelDeployment, param.getParamValue());
            break;
        }
    }

    private boolean shouldJsfActivate(DeploymentUnit deploymentUnit, WarMetaData warMetaData) {
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return false;
        }
        if (warMetaData != null) {
            WebMetaData jBossWebMetaData = warMetaData.getWebMetaData();
            if (this.isJsfDeclarationsPresent((WebCommonMetaData)jBossWebMetaData)) {
                return true;
            }
            if (warMetaData.getWebFragmentsMetaData() != null) {
                for (WebFragmentMetaData webFragmentMetaData : warMetaData.getWebFragmentsMetaData().values()) {
                    if (!this.isJsfDeclarationsPresent((WebCommonMetaData)webFragmentMetaData)) continue;
                    return true;
                }
            }
        }
        HashSet<Object> roots = new HashSet<Object>();
        roots.add(deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT));
        roots.addAll(deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS));
        for (ResourceRoot resourceRoot : roots) {
            VirtualFile c = resourceRoot.getRoot().getChild(META_INF_FACES);
            if (c.exists()) {
                return true;
            }
            c = resourceRoot.getRoot().getChild(WEB_INF_FACES);
            if (!c.exists()) continue;
            return true;
        }
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (DotName annotation : JSF_ANNOTATIONS) {
            List annotations = index.getAnnotations(annotation);
            if (annotations.isEmpty()) continue;
            return true;
        }
        for (DotName annotation : JSF_INTERFACES) {
            Set implementors = index.getAllKnownImplementors(annotation);
            if (implementors.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isJsfDeclarationsPresent(WebCommonMetaData jBossWebMetaData) {
        if (jBossWebMetaData != null) {
            List sc;
            ServletsMetaData servlets = jBossWebMetaData.getServlets();
            if (servlets != null) {
                for (ServletMetaData servlet : servlets) {
                    if (!JAVAX_FACES_WEBAPP_FACES_SERVLET.equals(servlet.getServletClass())) continue;
                    return true;
                }
            }
            if ((sc = jBossWebMetaData.getContextParams()) != null) {
                for (ParamValueMetaData p : sc) {
                    if (!CONFIG_FILES.equals(p.getParamName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

