/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomHandlerResourceDefinition;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.SyslogHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class LoggingSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    static final LoggingSubsystemWriter INSTANCE = new LoggingSubsystemWriter();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        List profiles;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        this.writeContent(writer, model);
        if (model.hasDefined("logging-profile") && !(profiles = model.get("logging-profile").asPropertyList()).isEmpty()) {
            writer.writeStartElement("logging-profiles");
            for (Property profile : profiles) {
                String name = profile.getName();
                writer.writeStartElement("logging-profile");
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                this.writeContent(writer, profile.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeContent(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        ModelNode handler;
        String name;
        ModelNode handlers;
        if (model.hasDefined("async-handler")) {
            handlers = model.get("async-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeAsynchHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("console-handler")) {
            handlers = model.get("console-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeConsoleHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("file-handler")) {
            handlers = model.get("file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeFileHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("custom-handler")) {
            handlers = model.get("custom-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeCustomHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("periodic-rotating-file-handler")) {
            handlers = model.get("periodic-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writePeriodicRotatingFileHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("size-rotating-file-handler")) {
            handlers = model.get("size-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSizeRotatingFileHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("syslog-handler")) {
            handlers = model.get("syslog-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSyslogHandler(writer, handler, name);
            }
        }
        if (model.hasDefined("logger")) {
            for (String name2 : model.get("logger").keys()) {
                this.writeLogger(writer, name2, model.get(new String[]{"logger", name2}));
            }
        }
        if (model.hasDefined("root-logger")) {
            this.writeRootLogger(writer, model.get(new String[]{"root-logger", "ROOT"}));
        }
        if (model.hasDefined(PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName())) {
            for (String name2 : model.get(PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName()).keys()) {
                this.writePatternFormatter(writer, model.get(new String[]{PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName(), name2}), name2);
            }
        }
    }

    private void writeCommonLogger(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.HANDLERS.marshallAsElement(model, (XMLStreamWriter)writer);
    }

    private void writeCommonHandler(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.ENCODING.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(model, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.NAMED_FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
    }

    private void writeConsoleHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CONSOLE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        ConsoleHandlerResourceDefinition.TARGET.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.FILE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeCustomHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CUSTOM_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CustomHandlerResourceDefinition.CLASS.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CustomHandlerResourceDefinition.MODULE.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CustomHandlerResourceDefinition.PROPERTIES.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writePeriodicRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.PERIODIC_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        PeriodicHandlerResourceDefinition.SUFFIX.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSizeRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SIZE_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSyslogHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SYSLOG_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.SERVER_ADDRESS.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.HOSTNAME.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.PORT.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.APP_NAME.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.FACILITY.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeAsynchHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.ASYNC_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        CommonAttributes.LEVEL.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(model, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.QUEUE_LENGTH.marshallAsElement(model, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.OVERFLOW_ACTION.marshallAsElement(model, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.SUBHANDLERS.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeLogger(XMLExtendedStreamWriter writer, String name, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.LOGGER.getLocalName());
        writer.writeAttribute(LoggerResourceDefinition.CATEGORY.getXmlName(), name);
        LoggerResourceDefinition.USE_PARENT_HANDLERS.marshallAsAttribute(model, (XMLStreamWriter)writer);
        this.writeCommonLogger(writer, model);
        writer.writeEndElement();
    }

    private void writeRootLogger(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.ROOT_LOGGER.getLocalName());
        this.writeCommonLogger(writer, model);
        writer.writeEndElement();
    }

    private void writePatternFormatter(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.FORMATTER.getLocalName());
        writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
        PatternFormatterResourceDefinition.PATTERN_FORMATTER.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }
}

