/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.CustomServerConfig;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.MailSessionManagedReferenceFactory;
import org.jboss.as.mail.extension.MailSessionService;
import org.jboss.as.mail.extension.MailSubsystemModel;
import org.jboss.as.mail.extension.ServerConfig;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class MailSessionAdd
extends AbstractAddStepHandler {
    static final MailSessionAdd INSTANCE = new MailSessionAdd();
    @Deprecated
    static final ServiceName MAIL_SESSION_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mail-session"});

    protected MailSessionAdd() {
        super(MailSessionDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ModelNode fullTree = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        MailSessionAdd.installRuntimeServices(context, address, fullTree);
    }

    private static void addCredentialStoreReference(ServerConfig serverConfig, OperationContext context, ModelNode model, ServiceBuilder serviceBuilder, PathElement credRefParentAddress) throws OperationFailedException {
        if (serverConfig != null) {
            String servertype = credRefParentAddress.getKey();
            String serverprotocol = credRefParentAddress.getValue();
            ModelNode filteredModelNode = model;
            if (!filteredModelNode.hasDefined(new String[]{servertype, serverprotocol})) {
                return;
            }
            filteredModelNode = filteredModelNode.get(new String[]{servertype, serverprotocol});
            String keySuffix = servertype + "." + serverprotocol;
            ModelNode value = MailServerDefinition.CREDENTIAL_REFERENCE.resolveModelAttribute(context, filteredModelNode);
            if (value.isDefined()) {
                serverConfig.getCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)MailServerDefinition.CREDENTIAL_REFERENCE, (ModelNode)filteredModelNode, (ServiceBuilder)serviceBuilder, (String)keySuffix));
            }
        }
    }

    static void installRuntimeServices(OperationContext context, PathAddress address, ModelNode fullModel) throws OperationFailedException {
        final String jndiName = MailSessionAdd.getJndiName(fullModel, context);
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        MailSessionConfig config = MailSessionAdd.from(context, fullModel);
        MailSessionService service = new MailSessionService(config);
        CapabilityServiceBuilder mailSessionBuilder = serviceTarget.addCapability(MailSessionDefinition.SESSION_CAPABILITY.fromBaseCapability(address.getLastElement().getValue())).setInstance((Service)service);
        MailSessionAdd.addOutboundSocketDependency(service, mailSessionBuilder, config.getImapServer());
        MailSessionAdd.addCredentialStoreReference(config.getImapServer(), context, fullModel, (ServiceBuilder)mailSessionBuilder, MailSubsystemModel.IMAP_SERVER_PATH);
        MailSessionAdd.addOutboundSocketDependency(service, mailSessionBuilder, config.getPop3Server());
        MailSessionAdd.addCredentialStoreReference(config.getPop3Server(), context, fullModel, (ServiceBuilder)mailSessionBuilder, MailSubsystemModel.POP3_SERVER_PATH);
        MailSessionAdd.addOutboundSocketDependency(service, mailSessionBuilder, config.getSmtpServer());
        MailSessionAdd.addCredentialStoreReference(config.getSmtpServer(), context, fullModel, (ServiceBuilder)mailSessionBuilder, MailSubsystemModel.SMTP_SERVER_PATH);
        for (CustomServerConfig server : config.getCustomServers()) {
            if (server.getOutgoingSocketBinding() != null) {
                MailSessionAdd.addOutboundSocketDependency(service, mailSessionBuilder, server);
            }
            MailSessionAdd.addCredentialStoreReference(server, context, fullModel, (ServiceBuilder)mailSessionBuilder, PathElement.pathElement((String)MailSubsystemModel.CUSTOM_SERVER_PATH.getKey(), (String)server.getProtocol()));
        }
        mailSessionBuilder.addAliases(new ServiceName[]{MAIL_SESSION_SERVICE_NAME.append(new String[]{address.getLastElement().getValue()})});
        MailSessionManagedReferenceFactory valueManagedReferenceFactory = new MailSessionManagedReferenceFactory(service);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        binderService.getManagedObjectInjector().inject((Object)valueManagedReferenceFactory);
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (org.jboss.msc.service.Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener(new LifecycleListener(){
            private volatile boolean bound;

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        MailLogger.ROOT_LOGGER.boundMailSession(jndiName);
                        this.bound = true;
                        break;
                    }
                    case DOWN: {
                        if (!this.bound) break;
                        MailLogger.ROOT_LOGGER.unboundMailSession(jndiName);
                        break;
                    }
                    case REMOVED: {
                        MailLogger.ROOT_LOGGER.removedMailSession(jndiName);
                    }
                }
            }
        });
        mailSessionBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static String getJndiName(ModelNode modelNode, OperationContext context) throws OperationFailedException {
        String rawJndiName = MailSessionDefinition.JNDI_NAME.resolveModelAttribute(context, modelNode).asString();
        return MailSessionAdd.getJndiName(rawJndiName);
    }

    public static String getJndiName(String rawJndiName) {
        String jndiName = !rawJndiName.startsWith("java:") ? "java:jboss/mail/" + rawJndiName : rawJndiName;
        return jndiName;
    }

    private static void addOutboundSocketDependency(MailSessionService service, CapabilityServiceBuilder<?> mailSessionBuilder, ServerConfig server) {
        if (server != null) {
            String ref = server.getOutgoingSocketBinding();
            mailSessionBuilder.addCapabilityRequirement("org.wildfly.network.outbound-socket-binding", OutboundSocketBinding.class, service.getSocketBindingInjector(ref), new String[]{ref});
        }
    }

    static MailSessionConfig from(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        MailSessionConfig cfg = new MailSessionConfig();
        cfg.setJndiName(MailSessionDefinition.JNDI_NAME.resolveModelAttribute(operationContext, model).asString());
        cfg.setDebug(MailSessionDefinition.DEBUG.resolveModelAttribute(operationContext, model).asBoolean());
        if (MailSessionDefinition.FROM.resolveModelAttribute(operationContext, model).isDefined()) {
            cfg.setFrom(MailSessionDefinition.FROM.resolveModelAttribute(operationContext, model).asString());
        }
        if (model.hasDefined("server")) {
            ModelNode server = model.get("server");
            if (server.hasDefined("smtp")) {
                cfg.setSmtpServer(MailSessionAdd.readServerConfig(operationContext, server.get("smtp")));
            }
            if (server.hasDefined("pop3")) {
                cfg.setPop3Server(MailSessionAdd.readServerConfig(operationContext, server.get("pop3")));
            }
            if (server.hasDefined("imap")) {
                cfg.setImapServer(MailSessionAdd.readServerConfig(operationContext, server.get("imap")));
            }
        }
        if (model.hasDefined("custom")) {
            for (Property server : model.get("custom").asPropertyList()) {
                cfg.addCustomServer(MailSessionAdd.readCustomServerConfig(server.getName(), operationContext, server.getValue()));
            }
        }
        return cfg;
    }

    private static ServerConfig readServerConfig(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        String socket = MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(operationContext, model).asString();
        Credentials credentials = MailSessionAdd.readCredentials(operationContext, model);
        boolean ssl = MailServerDefinition.SSL.resolveModelAttribute(operationContext, model).asBoolean();
        boolean tls = MailServerDefinition.TLS.resolveModelAttribute(operationContext, model).asBoolean();
        return new ServerConfig(socket, credentials, ssl, tls, null);
    }

    private static CustomServerConfig readCustomServerConfig(String protocol, OperationContext operationContext, ModelNode model) throws OperationFailedException {
        ModelNode socketModel = MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF_OPTIONAL.resolveModelAttribute(operationContext, model);
        String socket = socketModel.isDefined() ? socketModel.asString() : null;
        Credentials credentials = MailSessionAdd.readCredentials(operationContext, model);
        boolean ssl = MailServerDefinition.SSL.resolveModelAttribute(operationContext, model).asBoolean();
        boolean tls = MailServerDefinition.TLS.resolveModelAttribute(operationContext, model).asBoolean();
        Map properties = MailServerDefinition.PROPERTIES.unwrap((ExpressionResolver)operationContext, model);
        return new CustomServerConfig(protocol, socket, credentials, ssl, tls, properties);
    }

    private static Credentials readCredentials(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        if (model.get("username").isDefined()) {
            String un = MailServerDefinition.USERNAME.resolveModelAttribute(operationContext, model).asString();
            String pw = MailServerDefinition.PASSWORD.resolveModelAttribute(operationContext, model).asStringOrNull();
            ModelNode value = MailServerDefinition.CREDENTIAL_REFERENCE.resolveValue(operationContext, model);
            String secret = null;
            if (value.isDefined()) {
                secret = CredentialReference.credentialReferencePartAsStringIfDefined((ModelNode)value, (String)"clear-text");
            }
            if (secret != null) {
                return new Credentials(un, secret);
            }
            return new Credentials(un, pw);
        }
        return null;
    }
}

