/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.mail.extension.ConfigurableSessionProviderService;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.CustomServerConfig;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.MailSessionManagedReferenceFactory;
import org.jboss.as.mail.extension.MailSessionRemove;
import org.jboss.as.mail.extension.MailSessionService;
import org.jboss.as.mail.extension.MailSubsystemModel;
import org.jboss.as.mail.extension.ServerConfig;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class MailSessionAdd
extends AbstractAddStepHandler {
    MailSessionAdd() {
        super(MailSessionDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        MailSessionAdd.installRuntimeServices(context, fullModel);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            MailSessionRemove.removeRuntimeServices(context, resource.getModel());
            for (Resource.ResourceEntry entry : resource.getChildren("server")) {
                ModelNode resolvedValue = MailServerDefinition.CREDENTIAL_REFERENCE.resolveModelAttribute(context, entry.getModel());
                if (!resolvedValue.isDefined()) continue;
                CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)MailServerDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (ModelNode)resolvedValue);
            }
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void addCredentialStoreReference(ServerConfig serverConfig, OperationContext context, ModelNode model, ServiceBuilder<?> serviceBuilder, PathElement credRefParentAddress) throws OperationFailedException {
        if (serverConfig != null) {
            String servertype = credRefParentAddress.getKey();
            String serverprotocol = credRefParentAddress.getValue();
            ModelNode filteredModelNode = model;
            if (!filteredModelNode.hasDefined(new String[]{servertype, serverprotocol})) {
                return;
            }
            filteredModelNode = filteredModelNode.get(new String[]{servertype, serverprotocol});
            String keySuffix = servertype + "." + serverprotocol;
            ModelNode value = MailServerDefinition.CREDENTIAL_REFERENCE.resolveModelAttribute(context, filteredModelNode);
            if (value.isDefined()) {
                serverConfig.getCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)MailServerDefinition.CREDENTIAL_REFERENCE, (ModelNode)filteredModelNode, serviceBuilder, (String)keySuffix));
            }
        }
    }

    static void installSessionProviderService(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        MailSessionAdd.installSessionProviderService(context, context.getCurrentAddress(), fullModel);
    }

    static void installSessionProviderService(OperationContext context, PathAddress address, ModelNode fullModel) throws OperationFailedException {
        ServiceName serviceName = MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(address).append(new String[]{"provider"});
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName);
        MailSessionConfig config = MailSessionAdd.from(context, fullModel, builder);
        MailSessionAdd.addCredentialStoreReference(config.getImapServer(), context, fullModel, builder, MailSubsystemModel.IMAP_SERVER_PATH);
        MailSessionAdd.addCredentialStoreReference(config.getPop3Server(), context, fullModel, builder, MailSubsystemModel.POP3_SERVER_PATH);
        MailSessionAdd.addCredentialStoreReference(config.getSmtpServer(), context, fullModel, builder, MailSubsystemModel.SMTP_SERVER_PATH);
        for (CustomServerConfig server : config.getCustomServers()) {
            MailSessionAdd.addCredentialStoreReference(server, context, fullModel, builder, PathElement.pathElement((String)MailSubsystemModel.CUSTOM_SERVER_PATH.getKey(), (String)server.getProtocol()));
        }
        ConfigurableSessionProviderService providerService = new ConfigurableSessionProviderService(builder.provides(new ServiceName[]{serviceName}), config);
        builder.setInstance((Service)providerService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    static void installBinderService(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        final String jndiName = MailSessionAdd.getJndiName(fullModel, context);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        String bindName = bindInfo.getBindName();
        BinderService service = new BinderService(bindName);
        ServiceBuilder builder = context.getServiceTarget().addService(bindInfo.getBinderServiceName(), (org.jboss.msc.service.Service)service).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindName})});
        Supplier provider = builder.requires(MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress()).append(new String[]{"provider"}));
        service.getManagedObjectInjector().inject((Object)new MailSessionManagedReferenceFactory(provider));
        builder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)service.getNamingStoreInjector());
        builder.addListener(new LifecycleListener(){
            private volatile boolean bound;

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        MailLogger.ROOT_LOGGER.boundMailSession(jndiName);
                        this.bound = true;
                        break;
                    }
                    case DOWN: {
                        if (!this.bound) break;
                        MailLogger.ROOT_LOGGER.unboundMailSession(jndiName);
                        break;
                    }
                    case REMOVED: {
                        MailLogger.ROOT_LOGGER.removedMailSession(jndiName);
                    }
                }
            }
        });
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static void installRuntimeServices(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        MailSessionAdd.installSessionProviderService(context, fullModel);
        ServiceName sessionServiceName = MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
        ServiceName providerServiceName = sessionServiceName.append(new String[]{"provider"});
        CapabilityServiceBuilder mailSessionBuilder = context.getCapabilityServiceTarget().addCapability(MailSessionDefinition.SESSION_CAPABILITY);
        MailSessionService mailService = new MailSessionService(mailSessionBuilder.provides(new ServiceName[]{sessionServiceName}), mailSessionBuilder.requires(providerServiceName));
        mailSessionBuilder.setInstance((Service)mailService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        MailSessionAdd.installBinderService(context, fullModel);
    }

    static String getJndiName(ModelNode modelNode, OperationContext context) throws OperationFailedException {
        String rawJndiName = MailSessionDefinition.JNDI_NAME.resolveModelAttribute(context, modelNode).asString();
        return MailSessionAdd.getJndiName(rawJndiName);
    }

    public static String getJndiName(String rawJndiName) {
        Object jndiName = !rawJndiName.startsWith("java:") ? "java:jboss/mail/" + rawJndiName : rawJndiName;
        return jndiName;
    }

    private static Supplier<OutboundSocketBinding> requireOutboundSocketBinding(OperationContext context, ServiceBuilder<?> builder, String ref) {
        return ref != null ? builder.requires(context.getCapabilityServiceName("org.wildfly.network.outbound-socket-binding", OutboundSocketBinding.class, new String[]{ref})) : null;
    }

    static MailSessionConfig from(OperationContext operationContext, ModelNode model, ServiceBuilder<?> builder) throws OperationFailedException {
        MailSessionConfig cfg = new MailSessionConfig();
        cfg.setJndiName(MailSessionDefinition.JNDI_NAME.resolveModelAttribute(operationContext, model).asString());
        cfg.setDebug(MailSessionDefinition.DEBUG.resolveModelAttribute(operationContext, model).asBoolean());
        if (MailSessionDefinition.FROM.resolveModelAttribute(operationContext, model).isDefined()) {
            cfg.setFrom(MailSessionDefinition.FROM.resolveModelAttribute(operationContext, model).asString());
        }
        if (model.hasDefined("server")) {
            ModelNode server = model.get("server");
            if (server.hasDefined("smtp")) {
                cfg.setSmtpServer(MailSessionAdd.readServerConfig(operationContext, server.get("smtp"), builder));
            }
            if (server.hasDefined("pop3")) {
                cfg.setPop3Server(MailSessionAdd.readServerConfig(operationContext, server.get("pop3"), builder));
            }
            if (server.hasDefined("imap")) {
                cfg.setImapServer(MailSessionAdd.readServerConfig(operationContext, server.get("imap"), builder));
            }
        }
        if (model.hasDefined("custom")) {
            for (Property server : model.get("custom").asPropertyList()) {
                cfg.addCustomServer(MailSessionAdd.readCustomServerConfig(server.getName(), operationContext, server.getValue(), builder));
            }
        }
        return cfg;
    }

    private static ServerConfig readServerConfig(OperationContext operationContext, ModelNode model, ServiceBuilder<?> builder) throws OperationFailedException {
        String socket = MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(operationContext, model).asString();
        Credentials credentials = MailSessionAdd.readCredentials(operationContext, model);
        boolean ssl = MailServerDefinition.SSL.resolveModelAttribute(operationContext, model).asBoolean();
        boolean tls = MailServerDefinition.TLS.resolveModelAttribute(operationContext, model).asBoolean();
        return new ServerConfig(MailSessionAdd.requireOutboundSocketBinding(operationContext, builder, socket), credentials, ssl, tls, null);
    }

    private static CustomServerConfig readCustomServerConfig(String protocol, OperationContext operationContext, ModelNode model, ServiceBuilder<?> builder) throws OperationFailedException {
        String socket = MailServerDefinition.OUTBOUND_SOCKET_BINDING_REF_OPTIONAL.resolveModelAttribute(operationContext, model).asStringOrNull();
        Credentials credentials = MailSessionAdd.readCredentials(operationContext, model);
        boolean ssl = MailServerDefinition.SSL.resolveModelAttribute(operationContext, model).asBoolean();
        boolean tls = MailServerDefinition.TLS.resolveModelAttribute(operationContext, model).asBoolean();
        Map properties = MailServerDefinition.PROPERTIES.unwrap((ExpressionResolver)operationContext, model);
        return new CustomServerConfig(protocol, MailSessionAdd.requireOutboundSocketBinding(operationContext, builder, socket), credentials, ssl, tls, properties);
    }

    private static Credentials readCredentials(OperationContext operationContext, ModelNode model) throws OperationFailedException {
        if (model.get("username").isDefined()) {
            String un = MailServerDefinition.USERNAME.resolveModelAttribute(operationContext, model).asString();
            String pw = MailServerDefinition.PASSWORD.resolveModelAttribute(operationContext, model).asStringOrNull();
            ModelNode value = MailServerDefinition.CREDENTIAL_REFERENCE.resolveValue(operationContext, model);
            String secret = null;
            if (value.isDefined()) {
                secret = CredentialReference.credentialReferencePartAsStringIfDefined((ModelNode)value, (String)"clear-text");
            }
            if (secret != null) {
                return new Credentials(un, secret);
            }
            return new Credentials(un, pw);
        }
        return null;
    }
}

