/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.apache.activemq.artemis.api.jms.management.JMSServerControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class ConnectionFactoryRemove
extends AbstractRemoveStepHandler {
    public static final ConnectionFactoryRemove INSTANCE = new ConnectionFactoryRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        context.removeService(JMSServices.getConnectionFactoryBaseServiceName(serviceName).append(new String[]{name}));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
        JMSServerControl control = (JMSServerControl)JMSServerControl.class.cast(server.getManagementService().getResource("jms.server"));
        if (control != null) {
            try {
                control.destroyConnectionFactory(name);
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

