/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicService;

public class JMSTopicAdd
extends AbstractAddStepHandler {
    public static final JMSTopicAdd INSTANCE = new JMSTopicAdd();

    private JMSTopicAdd() {
        super(JMSTopicDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String[] jndiBindings;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceTarget serviceTarget = context.getServiceTarget();
        JMSTopicService jmsTopicService = JMSTopicService.installService(name, serviceName, serviceTarget, new String[0]);
        ModelNode entries = CommonAttributes.DESTINATION_ENTRIES.resolveModelAttribute(context, model);
        ServiceName jmsTopicServiceName = JMSServices.getJmsTopicBaseServiceName(serviceName).append(new String[]{name});
        for (String jndiBinding : jndiBindings = JMSServices.getJndiBindings(entries)) {
            BinderServiceUtil.installBinderService(serviceTarget, jndiBinding, jmsTopicService, jmsTopicServiceName);
        }
    }
}

