/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.activemq.artemis.cli.commands.tools.XmlDataExporter;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.PathDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ExportJournalOperation
extends AbstractRuntimeOnlyHandler {
    static final ExportJournalOperation INSTANCE = new ExportJournalOperation();
    private static final String FILE_NAME_FORMAT = "journal-%1$tY%<tm%<td-%<tH%<tM%<tS%<TL%<tz-dump.xml";

    private ExportJournalOperation() {
    }

    static void registerOperation(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("export-journal", resourceDescriptionResolver).setRuntimeOnly().setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)INSTANCE);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw MessagingLogger.ROOT_LOGGER.managementOperationAllowedOnlyInRunningMode("export-journal", RunningMode.ADMIN_ONLY);
        }
        Resource serverResource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ServiceController service = context.getServiceRegistry(false).getService(PathManagerService.SERVICE_NAME);
        PathManager pathManager = (PathManager)service.getService().getValue();
        String journal = ExportJournalOperation.resolvePath(context, pathManager, MessagingExtension.JOURNAL_DIRECTORY_PATH, serverResource);
        String bindings = ExportJournalOperation.resolvePath(context, pathManager, MessagingExtension.BINDINGS_DIRECTORY_PATH, serverResource);
        String paging = ExportJournalOperation.resolvePath(context, pathManager, MessagingExtension.PAGING_DIRECTORY_PATH, serverResource);
        String largeMessages = ExportJournalOperation.resolvePath(context, pathManager, MessagingExtension.LARGE_MESSAGES_DIRECTORY_PATH, serverResource);
        XmlDataExporter exporter = new XmlDataExporter();
        String name = String.format(FILE_NAME_FORMAT, new Date());
        File dump = new File(new File(journal).getParent(), name);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dump);
            exporter.process((OutputStream)fos, bindings, journal, paging, largeMessages);
            context.getResult().set(dump.getAbsolutePath());
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String resolvePath(OperationContext context, PathManager pathManager, PathElement pathElement, Resource serverResource) throws OperationFailedException {
        ModelNode pathModel = serverResource.hasChild(pathElement) ? serverResource.getChild(pathElement).getModel() : new ModelNode();
        String relativeTo = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, pathModel).asString();
        String path = PathDefinition.PATHS.get(pathElement.getValue()).resolveModelAttribute(context, pathModel).asString();
        return pathManager.resolveRelativePathEntry(path, relativeTo);
    }
}

