/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Collection;
import java.util.Collections;
import org.apache.activemq.artemis.core.security.Role;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.SecurityRoleAdd;
import org.wildfly.extension.messaging.activemq.SecurityRoleAttributeHandler;
import org.wildfly.extension.messaging.activemq.SecurityRoleReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.SecurityRoleRemove;

public class SecurityRoleDefinition
extends PersistentResourceDefinition {
    static final SimpleAttributeDefinition SEND = SecurityRoleDefinition.create("send");
    static final SimpleAttributeDefinition CONSUME = SecurityRoleDefinition.create("consume");
    static final SimpleAttributeDefinition CREATE_DURABLE_QUEUE = SecurityRoleDefinition.create("create-durable-queue");
    static final SimpleAttributeDefinition DELETE_DURABLE_QUEUE = SecurityRoleDefinition.create("delete-durable-queue");
    static final SimpleAttributeDefinition CREATE_NON_DURABLE_QUEUE = SecurityRoleDefinition.create("create-non-durable-queue");
    static final SimpleAttributeDefinition DELETE_NON_DURABLE_QUEUE = SecurityRoleDefinition.create("delete-non-durable-queue");
    static final SimpleAttributeDefinition MANAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"manage", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{SEND, CONSUME, CREATE_DURABLE_QUEUE, DELETE_DURABLE_QUEUE, CREATE_NON_DURABLE_QUEUE, DELETE_NON_DURABLE_QUEUE, MANAGE};
    static final SimpleAttributeDefinition NAME = SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).build();
    private final boolean runtimeOnly;
    static final SecurityRoleDefinition RUNTIME_INSTANCE = new SecurityRoleDefinition(true);
    static final SecurityRoleDefinition INSTANCE = new SecurityRoleDefinition(false);

    public static ObjectTypeAttributeDefinition getObjectTypeAttributeDefinition() {
        SimpleAttributeDefinition[] attrs = new SimpleAttributeDefinition[ATTRIBUTES.length + 1];
        attrs[0] = NAME;
        System.arraycopy(ATTRIBUTES, 0, attrs, 1, ATTRIBUTES.length);
        return ObjectTypeAttributeDefinition.Builder.of((String)"role", (AttributeDefinition[])attrs).build();
    }

    private static SimpleAttributeDefinition create(String name) {
        return ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    }

    static Role transform(OperationContext context, String name, ModelNode node) throws OperationFailedException {
        boolean send = SEND.resolveModelAttribute(context, node).asBoolean();
        boolean consume = CONSUME.resolveModelAttribute(context, node).asBoolean();
        boolean createDurableQueue = CREATE_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean deleteDurableQueue = DELETE_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean createNonDurableQueue = CREATE_NON_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean deleteNonDurableQueue = DELETE_NON_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean manage = MANAGE.resolveModelAttribute(context, node).asBoolean();
        return new Role(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage);
    }

    private SecurityRoleDefinition(boolean runtimeOnly) {
        super(MessagingExtension.ROLE_PATH, MessagingExtension.getResourceDescriptionResolver("security-role"), (OperationStepHandler)(runtimeOnly ? null : SecurityRoleAdd.INSTANCE), (OperationStepHandler)(runtimeOnly ? null : SecurityRoleRemove.INSTANCE), runtimeOnly);
        this.runtimeOnly = runtimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptyList();
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        if (this.runtimeOnly) {
            for (SimpleAttributeDefinition attr : ATTRIBUTES) {
                SimpleAttributeDefinition readOnlyAttr = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)attr).setStorageRuntime()).build();
                registry.registerReadOnlyAttribute((AttributeDefinition)readOnlyAttr, (OperationStepHandler)SecurityRoleReadAttributeHandler.INSTANCE);
            }
        } else {
            for (SimpleAttributeDefinition attr : ATTRIBUTES) {
                if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
                registry.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)SecurityRoleAttributeHandler.INSTANCE);
            }
        }
    }
}

