/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class MessagingDependencyProcessor
implements DeploymentUnitProcessor {
    public static final ModuleIdentifier AS_MESSAGING = ModuleIdentifier.create((String)"org.wildfly.extension.messaging-activemq");
    public static final ModuleIdentifier JMS_API = ModuleIdentifier.create((String)"javax.jms.api");
    public static final ModuleIdentifier JTS = ModuleIdentifier.create((String)"org.jboss.jts");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JMS_API);
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            this.addDependency(moduleSpecification, moduleLoader, AS_MESSAGING);
            this.addDependency(moduleSpecification, moduleLoader, JTS);
        }
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

