/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;

public class SharedStoreMasterDefinition
extends PersistentResourceDefinition {
    public static final Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(HAAttributes.FAILOVER_ON_SERVER_SHUTDOWN));
    public static final SharedStoreMasterDefinition INSTANCE = new SharedStoreMasterDefinition(MessagingExtension.SHARED_STORE_MASTER_PATH, false);
    public static final SharedStoreMasterDefinition CONFIGURATION_INSTANCE = new SharedStoreMasterDefinition(MessagingExtension.CONFIGURATION_MASTER_PATH, true);

    private SharedStoreMasterDefinition(PathElement path, boolean allowSibling) {
        super(path, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation(path.getKey(), allowSibling, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static HAPolicyConfiguration buildConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        return new SharedStoreMasterPolicyConfiguration().setFailoverOnServerShutdown(HAAttributes.FAILOVER_ON_SERVER_SHUTDOWN.resolveModelAttribute(context, model).asBoolean());
    }
}

