/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

class QueueService
implements Service<Void> {
    private final Supplier<ActiveMQServer> activeMQServerSupplier;
    private final CoreQueueConfiguration queueConfiguration;
    private final boolean temporary;
    private final boolean createQueue;

    public QueueService(Supplier<ActiveMQServer> activeMQServerSupplier, CoreQueueConfiguration queueConfiguration, boolean temporary, boolean createQueue) {
        if (queueConfiguration == null) {
            throw MessagingLogger.ROOT_LOGGER.nullVar("queueConfiguration");
        }
        this.activeMQServerSupplier = activeMQServerSupplier;
        this.queueConfiguration = queueConfiguration;
        this.temporary = temporary;
        this.createQueue = createQueue;
    }

    public synchronized void start(StartContext context) throws StartException {
        if (this.createQueue) {
            try {
                ActiveMQServer server = this.activeMQServerSupplier.get();
                MessagingLogger.ROOT_LOGGER.debugf("Deploying queue on server %s with address: %s ,  name: %s, filter: %s ands durable: %s, temporary: %s", new Object[]{server.getNodeID(), new SimpleString(this.queueConfiguration.getAddress()), new SimpleString(this.queueConfiguration.getName()), SimpleString.toSimpleString((String)this.queueConfiguration.getFilterString()), this.queueConfiguration.isDurable(), this.temporary});
                SimpleString resourceName = new SimpleString(this.queueConfiguration.getName());
                SimpleString address = new SimpleString(this.queueConfiguration.getAddress());
                SimpleString filterString = SimpleString.toSimpleString((String)this.queueConfiguration.getFilterString());
                server.createQueue(address, this.queueConfiguration.getRoutingType(), resourceName, filterString, this.queueConfiguration.isDurable(), this.temporary);
            }
            catch (Exception e) {
                throw new StartException((Throwable)e);
            }
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            ActiveMQServer server = this.activeMQServerSupplier.get();
            server.destroyQueue(new SimpleString(this.queueConfiguration.getName()), null, false);
            MessagingLogger.ROOT_LOGGER.debugf("Destroying queue from server %s queue with name: %s", server.getNodeID(), new SimpleString(this.queueConfiguration.getName()));
        }
        catch (Exception e) {
            MessagingLogger.ROOT_LOGGER.failedToDestroy("queue", this.queueConfiguration.getName());
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }
}

