package org.jboss.as.messaging.logging;

import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.messaging.Element;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.as.controller.PathElement;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.service.StartException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.annotation.Generated;
import org.jboss.as.controller.OperationFailedException;
import javax.jms.IllegalStateRuntimeException;
import javax.xml.stream.XMLStreamException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceController.State;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import org.jboss.dmr.ModelType;
import java.util.Collection;
import java.lang.Object;
import org.jboss.as.controller.ModelVersion;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-03-27T17:24:23+0100")
public class MessagingLogger_$logger extends DelegatingBasicLogger implements MessagingLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MessagingLogger_$logger.class.getName();
    public MessagingLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void aioWarning() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, aioWarning$str());
    }
    private static final String aioWarning = "WFLYMSG0001: AIO wasn't located on this platform, it will fall back to using pure Java NIO.";
    protected String aioWarning$str() {
        return aioWarning;
    }
    @Override
    public final void boundJndiName(final String jndiName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, boundJndiName$str(), jndiName);
    }
    private static final String boundJndiName = "WFLYMSG0002: Bound messaging object to jndi name %s";
    protected String boundJndiName$str() {
        return boundJndiName;
    }
    @Override
    public final void errorStoppingJmsServer(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, errorStoppingJmsServer$str());
    }
    private static final String errorStoppingJmsServer = "WFLYMSG0003: Exception while stopping JMS server";
    protected String errorStoppingJmsServer$str() {
        return errorStoppingJmsServer;
    }
    @Override
    public final void failedToDestroy(final Throwable cause, final String description, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, failedToDestroy$str(), description, name);
    }
    private static final String failedToDestroy = "WFLYMSG0004: Failed to destroy %s: %s";
    protected String failedToDestroy$str() {
        return failedToDestroy;
    }
    @Override
    public final void failedToDestroy(final String description, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, failedToDestroy$str(), description, name);
    }
    @Override
    public final void revertOperationFailed(final Throwable cause, final String className, final String operation, final PathAddress address) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, revertOperationFailed$str(), className, operation, address);
    }
    private static final String revertOperationFailed = "WFLYMSG0005: %s caught exception attempting to revert operation %s at address %s";
    protected String revertOperationFailed$str() {
        return revertOperationFailed;
    }
    @Override
    public final void unboundJndiName(final String jndiName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, unboundJndiName$str(), jndiName);
    }
    private static final String unboundJndiName = "WFLYMSG0006: Unbound messaging object to jndi name %s";
    protected String unboundJndiName$str() {
        return unboundJndiName;
    }
    @Override
    public final void couldNotCloseFile(final String file, final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, couldNotCloseFile$str(), file);
    }
    private static final String couldNotCloseFile = "WFLYMSG0007: Could not close file %s";
    protected String couldNotCloseFile$str() {
        return couldNotCloseFile;
    }
    @Override
    public final void failedToUnbindJndiName(final String jndiName, final long timeout, final String timeUnit) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, failedToUnbindJndiName$str(), jndiName, timeout, timeUnit);
    }
    private static final String failedToUnbindJndiName = "WFLYMSG0008: Failed to unbind messaging object bound to jndi name %s in %d %s";
    protected String failedToUnbindJndiName$str() {
        return failedToUnbindJndiName;
    }
    @Override
    public final void deprecatedXMLElement(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedXMLElement1$str(), name);
    }
    private static final String deprecatedXMLElement1 = "WFLYMSG0009: Element %s is deprecated and will not be taken into account";
    protected String deprecatedXMLElement1$str() {
        return deprecatedXMLElement1;
    }
    @Override
    public final void deprecatedXMLAttribute(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedXMLAttribute$str(), name);
    }
    private static final String deprecatedXMLAttribute = "WFLYMSG0010: Attribute %s is deprecated and will not be taken into account";
    protected String deprecatedXMLAttribute$str() {
        return deprecatedXMLAttribute;
    }
    @Override
    public final void startedService(final String type, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, startedService$str(), type, name);
    }
    private static final String startedService = "WFLYMSG0011: Started %s %s";
    protected String startedService$str() {
        return startedService;
    }
    @Override
    public final void stoppedService(final String type, final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, stoppedService$str(), type, name);
    }
    private static final String stoppedService = "WFLYMSG0012: Stopped %s %s";
    protected String stoppedService$str() {
        return stoppedService;
    }
    @Override
    public final void deprecatedAttribute(final String name, final PathAddress address) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedAttribute$str(), name, address);
    }
    private static final String deprecatedAttribute = "WFLYMSG0013: Attribute %s of the resource at %s is deprecated and setting its value will not be taken into account";
    protected String deprecatedAttribute$str() {
        return deprecatedAttribute;
    }
    private static final String canNotChangeClusteredAttribute = "WFLYMSG0014: Can not change the clustered attribute to false: The hornetq-server resource at %s has cluster-connection children resources and will remain clustered.";
    protected String canNotChangeClusteredAttribute$str() {
        return canNotChangeClusteredAttribute;
    }
    @Override
    public final String canNotChangeClusteredAttribute(final PathAddress address) {
        return String.format(canNotChangeClusteredAttribute$str(), address);
    }
    @Override
    public final void unknownPooledConnectionFactoryAttribute(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, unknownPooledConnectionFactoryAttribute$str(), name);
    }
    private static final String unknownPooledConnectionFactoryAttribute = "WFLYMSG0015: Ignoring %s property that is not a known property for pooled connection factory.";
    protected String unknownPooledConnectionFactoryAttribute$str() {
        return unknownPooledConnectionFactoryAttribute;
    }
    @Override
    public final void registeredHTTPUpgradeHandler(final String name, final String acceptor) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, registeredHTTPUpgradeHandler$str(), name, acceptor);
    }
    private static final String registeredHTTPUpgradeHandler = "WFLYMSG0016: Registered HTTP upgrade for %s protocol handled by %s acceptor";
    protected String registeredHTTPUpgradeHandler$str() {
        return registeredHTTPUpgradeHandler;
    }
    @Override
    public final void deprecatedXMLElement(final String name, final String replacement) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, deprecatedXMLElement2$str(), name, replacement);
    }
    private static final String deprecatedXMLElement2 = "WFLYMSG0017: Element %s is deprecated and %s will be used in its place";
    protected String deprecatedXMLElement2$str() {
        return deprecatedXMLElement2;
    }
    @Override
    public final void connectorForPooledConnectionFactory(final String name, final String connectorName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, connectorForPooledConnectionFactory$str(), name, connectorName);
    }
    private static final String connectorForPooledConnectionFactory = "WFLYMSG0018: No connectors were explicitly defined for the pooled connection factory %s. Using %s as the connector.";
    protected String connectorForPooledConnectionFactory$str() {
        return connectorForPooledConnectionFactory;
    }
    private static final String altAttributeAlreadyDefined = "WFLYMSG0019: Alternative attribute of (%s) is already defined.";
    protected String altAttributeAlreadyDefined$str() {
        return altAttributeAlreadyDefined;
    }
    @Override
    public final String altAttributeAlreadyDefined(final String name) {
        return String.format(altAttributeAlreadyDefined$str(), name);
    }
    private static final String attributeDefinitionsMustMatch = "WFLYMSG0020: All attribute definitions must have the same xml name -- found %s but already had %s";
    protected String attributeDefinitionsMustMatch$str() {
        return attributeDefinitionsMustMatch;
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsMustMatch(final String nameFound, final String nameRequired) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(attributeDefinitionsMustMatch$str(), nameFound, nameRequired));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeDefinitionsNotUnique = "WFLYMSG0021: All attribute definitions must have unique names -- already found %s";
    protected String attributeDefinitionsNotUnique$str() {
        return attributeDefinitionsNotUnique;
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsNotUnique(final String nameFound) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(attributeDefinitionsNotUnique$str(), nameFound));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotBindJndiName = "WFLYMSG0022: Cannot bind a null or empty string as jndi name";
    protected String cannotBindJndiName$str() {
        return cannotBindJndiName;
    }
    @Override
    public final IllegalArgumentException cannotBindJndiName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotBindJndiName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotIncludeOperationParameters = "WFLYMSG0023: Operation cannot include both parameter %s and parameter %s";
    protected String cannotIncludeOperationParameters$str() {
        return cannotIncludeOperationParameters;
    }
    @Override
    public final String cannotIncludeOperationParameters(final String paramName1, final String paramName2) {
        return String.format(cannotIncludeOperationParameters$str(), paramName1, paramName2);
    }
    private static final String cannotMarshalAttribute = "WFLYMSG0024: %s cannot be marshalled as an attribute; use marshallAsElement";
    protected String cannotMarshalAttribute$str() {
        return cannotMarshalAttribute;
    }
    @Override
    public final UnsupportedOperationException cannotMarshalAttribute(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(cannotMarshalAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUnbindJndiName = "WFLYMSG0025: Cannot unbind a null or empty string as jndi name";
    protected String cannotUnbindJndiName$str() {
        return cannotUnbindJndiName;
    }
    @Override
    public final IllegalArgumentException cannotUnbindJndiName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotUnbindJndiName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String childResourceAlreadyExists = "WFLYMSG0026: A child resource of type %1$s already exists; the messaging subsystem only allows a single resource of type %1$s";
    protected String childResourceAlreadyExists$str() {
        return childResourceAlreadyExists;
    }
    @Override
    public final String childResourceAlreadyExists(final String type) {
        return String.format(childResourceAlreadyExists$str(), type);
    }
    private static final String connectorNotDefined = "WFLYMSG0027: Connector %s not defined";
    protected String connectorNotDefined$str() {
        return connectorNotDefined;
    }
    @Override
    public final IllegalStateException connectorNotDefined(final String connectorName) {
        final IllegalStateException result = new IllegalStateException(String.format(connectorNotDefined$str(), connectorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreate = "WFLYMSG0028: Failed to create %s";
    protected String failedToCreate$str() {
        return failedToCreate;
    }
    @Override
    public final StartException failedToCreate(final Throwable cause, final String name) {
        final StartException result = new StartException(String.format(failedToCreate$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindBroadcastSocketBinding = "WFLYMSG0029: Failed to find SocketBinding for broadcast binding: %s";
    protected String failedToFindBroadcastSocketBinding$str() {
        return failedToFindBroadcastSocketBinding;
    }
    @Override
    public final StartException failedToFindBroadcastSocketBinding(final String name) {
        final StartException result = new StartException(String.format(failedToFindBroadcastSocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindConnectorSocketBinding = "WFLYMSG0030: Failed to find SocketBinding for connector: %s";
    protected String failedToFindConnectorSocketBinding$str() {
        return failedToFindConnectorSocketBinding;
    }
    @Override
    public final StartException failedToFindConnectorSocketBinding(final String name) {
        final StartException result = new StartException(String.format(failedToFindConnectorSocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindDiscoverySocketBinding = "WFLYMSG0031: Failed to find SocketBinding for discovery binding: %s";
    protected String failedToFindDiscoverySocketBinding$str() {
        return failedToFindDiscoverySocketBinding;
    }
    @Override
    public final StartException failedToFindDiscoverySocketBinding(final String name) {
        final StartException result = new StartException(String.format(failedToFindDiscoverySocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShutdownServer = "WFLYMSG0032: Failed to shutdown %s server";
    protected String failedToShutdownServer$str() {
        return failedToShutdownServer;
    }
    @Override
    public final RuntimeException failedToShutdownServer(final Throwable cause, final String server) {
        final RuntimeException result = new RuntimeException(String.format(failedToShutdownServer$str(), server), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToStartService = "WFLYMSG0033: Failed to start service";
    protected String failedToStartService$str() {
        return failedToStartService;
    }
    @Override
    public final StartException failedToStartService(final Throwable cause) {
        final StartException result = new StartException(String.format(failedToStartService$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ignoringUnhandledElement = "WFLYMSG0034: Ignoring unhandled element: %s, at: %s";
    protected String ignoringUnhandledElement$str() {
        return ignoringUnhandledElement;
    }
    @Override
    public final XMLStreamException ignoringUnhandledElement(final Element element, final String location) {
        final XMLStreamException result = new XMLStreamException(String.format(ignoringUnhandledElement$str(), element, location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalElement = "WFLYMSG0035: Illegal element %s: cannot be used when %s is used";
    protected String illegalElement$str() {
        return illegalElement;
    }
    @Override
    public final String illegalElement(final String illegalElement, final String element) {
        return String.format(illegalElement$str(), illegalElement, element);
    }
    private static final String illegalValue2 = "WFLYMSG0036: Illegal value %s for element %s";
    protected String illegalValue2$str() {
        return illegalValue2;
    }
    @Override
    public final String illegalValue(final Object value, final String element) {
        return String.format(illegalValue2$str(), value, element);
    }
    private static final String illegalValue3 = "WFLYMSG0036: Illegal value %s for element %s as it could not be converted to required type %s";
    protected String illegalValue3$str() {
        return illegalValue3;
    }
    @Override
    public final String illegalValue(final Object value, final String element, final ModelType expectedType) {
        return String.format(illegalValue3$str(), value, element, expectedType);
    }
    private static final String immutableResource = "WFLYMSG0037: Resource is immutable";
    protected String immutableResource$str() {
        return immutableResource;
    }
    @Override
    public final UnsupportedOperationException immutableResource() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(immutableResource$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalid = "WFLYMSG0038: %s is invalid";
    protected String invalid$str() {
        return invalid;
    }
    @Override
    public final String invalid(final Object obj) {
        return String.format(invalid$str(), obj);
    }
    private static final String invalidAttributeType = "WFLYMSG0039: Attribute %s has unexpected type %s";
    protected String invalidAttributeType$str() {
        return invalidAttributeType;
    }
    @Override
    public final IllegalStateException invalidAttributeType(final String name, final ModelType type) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidAttributeType$str(), name, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOperationParameters = "WFLYMSG0040: Operation must include parameter %s or parameter %s";
    protected String invalidOperationParameters$str() {
        return invalidOperationParameters;
    }
    @Override
    public final String invalidOperationParameters(final String paramName1, final String paramName2) {
        return String.format(invalidOperationParameters$str(), paramName1, paramName2);
    }
    private static final String invalidParameterValue = "WFLYMSG0041: %s is an invalid value for parameter %s. Values must be one of: %s";
    protected String invalidParameterValue$str() {
        return invalidParameterValue;
    }
    @Override
    public final String invalidParameterValue(final Object value, final String name, final Collection<? extends Object> allowedValues) {
        return String.format(invalidParameterValue$str(), value, name, allowedValues);
    }
    private static final String invalidServiceState = "WFLYMSG0042: Service %s is not in state %s, it is in state %s";
    protected String invalidServiceState$str() {
        return invalidServiceState;
    }
    @Override
    public final IllegalStateException invalidServiceState(final ServiceName service, final State validState, final State currentState) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidServiceState$str(), service, validState, currentState));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameAlreadyRegistered = "WFLYMSG0043: JNDI name %s is already registered";
    protected String jndiNameAlreadyRegistered$str() {
        return jndiNameAlreadyRegistered;
    }
    @Override
    public final String jndiNameAlreadyRegistered(final String jndiName) {
        return String.format(jndiNameAlreadyRegistered$str(), jndiName);
    }
    private static final String multipleChildrenFound = "WFLYMSG0044: Multiple %s children found; only one is allowed";
    protected String multipleChildrenFound$str() {
        return multipleChildrenFound;
    }
    @Override
    public final IllegalStateException multipleChildrenFound(final String element) {
        final IllegalStateException result = new IllegalStateException(String.format(multipleChildrenFound$str(), element));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String required1 = "WFLYMSG0045: %s is required";
    protected String required1$str() {
        return required1;
    }
    @Override
    public final String required(final Object obj) {
        return String.format(required1$str(), obj);
    }
    private static final String required2 = "WFLYMSG0046: Either %s or %s is required";
    protected String required2$str() {
        return required2;
    }
    @Override
    public final String required(final Object obj1, final Object obj2) {
        return String.format(required2$str(), obj1, obj2);
    }
    private static final String nullVar = "WFLYMSG0047: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final IllegalArgumentException nullVar(final String varName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(nullVar$str(), varName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterNotDefined = "WFLYMSG0048: Parameter not defined: %s";
    protected String parameterNotDefined$str() {
        return parameterNotDefined;
    }
    @Override
    public final String parameterNotDefined(final Object parameter) {
        return String.format(parameterNotDefined$str(), parameter);
    }
    private static final String unknownAttribute = "WFLYMSG0049: No such attribute (%s)";
    protected String unknownAttribute$str() {
        return unknownAttribute;
    }
    @Override
    public final String unknownAttribute(final String name) {
        return String.format(unknownAttribute$str(), name);
    }
    private static final String unsupportedAttribute = "WFLYMSG0050: Read support for attribute %s was not properly implemented";
    protected String unsupportedAttribute$str() {
        return unsupportedAttribute;
    }
    @Override
    public final IllegalStateException unsupportedAttribute(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(unsupportedAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedElement = "WFLYMSG0051: Implement support for element %s";
    protected String unsupportedElement$str() {
        return unsupportedElement;
    }
    @Override
    public final UnsupportedOperationException unsupportedElement(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(unsupportedElement$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedOperation = "WFLYMSG0052: Support for operation %s was not properly implemented";
    protected String unsupportedOperation$str() {
        return unsupportedOperation;
    }
    @Override
    public final IllegalStateException unsupportedOperation(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(unsupportedOperation$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedRuntimeAttribute = "WFLYMSG0053: Runtime handling for %s is not implemented";
    protected String unsupportedRuntimeAttribute$str() {
        return unsupportedRuntimeAttribute;
    }
    @Override
    public final UnsupportedOperationException unsupportedRuntimeAttribute(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(unsupportedRuntimeAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hornetQServerNotInstalled = "WFLYMSG0054: No HornetQ Server is available under name %s";
    protected String hornetQServerNotInstalled$str() {
        return hornetQServerNotInstalled;
    }
    @Override
    public final OperationFailedException hornetQServerNotInstalled(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(hornetQServerNotInstalled$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotParseDeployment = "WFLYMSG0055: Could not parse file %s";
    protected String couldNotParseDeployment$str() {
        return couldNotParseDeployment;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotParseDeployment(final String file, final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(couldNotParseDeployment$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationNotValid = "WFLYMSG0056: Handler cannot handle operation %s";
    protected String operationNotValid$str() {
        return operationNotValid;
    }
    @Override
    public final IllegalStateException operationNotValid(final String operation) {
        final IllegalStateException result = new IllegalStateException(String.format(operationNotValid$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDestinationRegisteredForAddress = "WFLYMSG0057: No message destination registered at address %s";
    protected String noDestinationRegisteredForAddress$str() {
        return noDestinationRegisteredForAddress;
    }
    @Override
    public final String noDestinationRegisteredForAddress(final PathAddress address) {
        return String.format(noDestinationRegisteredForAddress$str(), address);
    }
    private static final String securityDomainContextNotSet = "WFLYMSG0058: SecurityDomainContext has not been set";
    protected String securityDomainContextNotSet$str() {
        return securityDomainContextNotSet;
    }
    @Override
    public final IllegalStateException securityDomainContextNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(securityDomainContextNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneRequired = "WFLYMSG0059: Only one of %s or %s is required";
    protected String onlyOneRequired$str() {
        return onlyOneRequired;
    }
    @Override
    public final String onlyOneRequired(final Object obj1, final Object obj2) {
        return String.format(onlyOneRequired$str(), obj1, obj2);
    }
    private static final String failedToRecover = "WFLYMSG0060: Failed to recover %s";
    protected String failedToRecover$str() {
        return failedToRecover;
    }
    @Override
    public final OperationFailedException failedToRecover(final Throwable cause, final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(failedToRecover$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAttributeInVersion = "WFLYMSG0061: Attribute(s) %s are not supported by messaging management model %s";
    protected String unsupportedAttributeInVersion$str() {
        return unsupportedAttributeInVersion;
    }
    @Override
    public final String unsupportedAttributeInVersion(final String attributes, final ModelVersion version) {
        return String.format(unsupportedAttributeInVersion$str(), attributes, version);
    }
    private static final String canNotWriteClusteredAttribute = "WFLYMSG0062: The clustered attribute is deprecated. To create a clustered HornetQ server, define at least one cluster-connection";
    protected String canNotWriteClusteredAttribute$str() {
        return canNotWriteClusteredAttribute;
    }
    @Override
    public final UnsupportedOperationException canNotWriteClusteredAttribute() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(canNotWriteClusteredAttribute$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRegisterResourceOfType = "WFLYMSG0063: Resources of type %s cannot be registered";
    protected String canNotRegisterResourceOfType$str() {
        return canNotRegisterResourceOfType;
    }
    @Override
    public final UnsupportedOperationException canNotRegisterResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(canNotRegisterResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRemoveResourceOfType = "WFLYMSG0064: Resources of type %s cannot be removed";
    protected String canNotRemoveResourceOfType$str() {
        return canNotRemoveResourceOfType;
    }
    @Override
    public final UnsupportedOperationException canNotRemoveResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(canNotRemoveResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hqServerManagementServiceResourceNotFound = "WFLYMSG0065: No resource exists at address %s";
    protected String hqServerManagementServiceResourceNotFound$str() {
        return hqServerManagementServiceResourceNotFound;
    }
    @Override
    public final String hqServerManagementServiceResourceNotFound(final PathAddress address) {
        return String.format(hqServerManagementServiceResourceNotFound$str(), address);
    }
    private static final String hqServerInBackupMode = "WFLYMSG0066: Resource at the address %s can not be managed, the hornetq-server is in backup mode";
    protected String hqServerInBackupMode$str() {
        return hqServerInBackupMode;
    }
    @Override
    public final String hqServerInBackupMode(final PathAddress address) {
        return String.format(hqServerInBackupMode$str(), address);
    }
    private static final String wrongConnectorRefInBroadCastGroup = "WFLYMSG0067: The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.";
    protected String wrongConnectorRefInBroadCastGroup$str() {
        return wrongConnectorRefInBroadCastGroup;
    }
    @Override
    public final OperationFailedException wrongConnectorRefInBroadCastGroup(final String bgName, final String connectorRef, final Collection<String> presentConnectors) {
        final OperationFailedException result = new OperationFailedException(String.format(wrongConnectorRefInBroadCastGroup$str(), bgName, connectorRef, presentConnectors));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String callNotPermittedOnInjectedJMSContext = "WFLYMSG0068: It is not permitted to call this method on injected JMSContext (see JMS 2.0 spec, §12.4.5).";
    protected String callNotPermittedOnInjectedJMSContext$str() {
        return callNotPermittedOnInjectedJMSContext;
    }
    @Override
    public final IllegalStateRuntimeException callNotPermittedOnInjectedJMSContext() {
        final IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(callNotPermittedOnInjectedJMSContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefineAttributeWithoutAlternative = "WFLYMSG0069: Attribute (%s) can not been undefined as the resource does not define any alternative to this attribute.";
    protected String undefineAttributeWithoutAlternative$str() {
        return undefineAttributeWithoutAlternative;
    }
    @Override
    public final String undefineAttributeWithoutAlternative(final String name) {
        return String.format(undefineAttributeWithoutAlternative$str(), name);
    }
    private static final String inconsistentStatisticsSettings = "WFLYMSG0070: Attributes %s is an alias for attribute %s; both cannot be set with conflicting values.";
    protected String inconsistentStatisticsSettings$str() {
        return inconsistentStatisticsSettings;
    }
    @Override
    public final OperationFailedException inconsistentStatisticsSettings(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(inconsistentStatisticsSettings$str(), attrOne, attrTwo));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noMatchingExpiryAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, noMatchingExpiryAddress$str(), address, addressSettings);
    }
    private static final String noMatchingExpiryAddress = "WFLYMSG0071: There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!";
    protected String noMatchingExpiryAddress$str() {
        return noMatchingExpiryAddress;
    }
    @Override
    public final void noMatchingDeadLetterAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, noMatchingDeadLetterAddress$str(), address, addressSettings);
    }
    private static final String noMatchingDeadLetterAddress = "WFLYMSG0072: There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!";
    protected String noMatchingDeadLetterAddress$str() {
        return noMatchingDeadLetterAddress;
    }
    private static final String canNotRemoveLastJNDIName = "WFLYMSG0073: Can not remove JNDI name %s. The resource must have at least one JNDI name";
    protected String canNotRemoveLastJNDIName$str() {
        return canNotRemoveLastJNDIName;
    }
    @Override
    public final String canNotRemoveLastJNDIName(final String jndiName) {
        return String.format(canNotRemoveLastJNDIName$str(), jndiName);
    }
    private static final String invalidParameterName = "WFLYMSG0074: Invalid parameter key: %s, the allowed keys are %s.";
    protected String invalidParameterName$str() {
        return invalidParameterName;
    }
    @Override
    public final OperationFailedException invalidParameterName(final String parameterName, final Set<String> allowedKeys) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidParameterName$str(), parameterName, allowedKeys));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void aioWarningLinux() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, aioWarningLinux$str());
    }
    private static final String aioWarningLinux = "WFLYMSG0075: AIO wasn't located on this platform, it will fall back to using pure Java NIO. Your platform is Linux, install LibAIO to enable the AIO journal.";
    protected String aioWarningLinux$str() {
        return aioWarningLinux;
    }
    private static final String duplicateElements = "WFLYMSG0076: Parameter %s contains duplicate elements [%s]";
    protected String duplicateElements$str() {
        return duplicateElements;
    }
    @Override
    public final OperationFailedException duplicateElements(final String parameterName, final ModelNode elements) {
        final OperationFailedException result = new OperationFailedException(String.format(duplicateElements$str(), parameterName, elements));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRemoveUnknownEntry = "WFLYMSG0077: Can not remove unknown entry %s";
    protected String canNotRemoveUnknownEntry$str() {
        return canNotRemoveUnknownEntry;
    }
    @Override
    public final OperationFailedException canNotRemoveUnknownEntry(final String entry) {
        final OperationFailedException result = new OperationFailedException(String.format(canNotRemoveUnknownEntry$str(), entry));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYMSG0078: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement address) {
        final IllegalStateException result = new IllegalStateException(String.format(indexedChildResourceRegistrationNotAvailable$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String migrateOperationAllowedOnlyInAdminOnly = "WFLYMSG0079: The migrate operation can not be performed: the server must be in admin-only mode";
    protected String migrateOperationAllowedOnlyInAdminOnly$str() {
        return migrateOperationAllowedOnlyInAdminOnly;
    }
    @Override
    public final OperationFailedException migrateOperationAllowedOnlyInAdminOnly() {
        final OperationFailedException result = new OperationFailedException(String.format(migrateOperationAllowedOnlyInAdminOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotMigrateBroadcastGroupAttribute = "WFLYMSG0080: Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this broadcast-group.";
    protected String couldNotMigrateBroadcastGroupAttribute$str() {
        return couldNotMigrateBroadcastGroupAttribute;
    }
    @Override
    public final String couldNotMigrateBroadcastGroupAttribute(final String attribute, final PathAddress address) {
        return String.format(couldNotMigrateBroadcastGroupAttribute$str(), attribute, address);
    }
    private static final String migrationFailed = "WFLYMSG0081: Migration failed, see results for more details.";
    protected String migrationFailed$str() {
        return migrationFailed;
    }
    @Override
    public final String migrationFailed() {
        return String.format(migrationFailed$str());
    }
    private static final String couldNotMigrateInterceptors = "WFLYMSG0082: Classes providing the %s are discarded during the migration. To use them in the new messaging-activemq subsystem, you will have to extend the Artemis-based Interceptor.";
    protected String couldNotMigrateInterceptors$str() {
        return couldNotMigrateInterceptors;
    }
    @Override
    public final String couldNotMigrateInterceptors(final String legacyInterceptorsAttributeName) {
        return String.format(couldNotMigrateInterceptors$str(), legacyInterceptorsAttributeName);
    }
    private static final String couldNotMigrateHA = "WFLYMSG0083: Can not migrate the HA configuration of %s. Its shared-store and backup attributes holds expressions and it is not possible to determine unambiguously how to create the corresponding ha-policy for the messaging-activemq's server.";
    protected String couldNotMigrateHA$str() {
        return couldNotMigrateHA;
    }
    @Override
    public final String couldNotMigrateHA(final PathAddress address) {
        return String.format(couldNotMigrateHA$str(), address);
    }
    private static final String couldNotMigrateDiscoveryGroupAttribute = "WFLYMSG0084: Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this discovery-group.";
    protected String couldNotMigrateDiscoveryGroupAttribute$str() {
        return couldNotMigrateDiscoveryGroupAttribute;
    }
    @Override
    public final String couldNotMigrateDiscoveryGroupAttribute(final String attribute, final PathAddress address) {
        return String.format(couldNotMigrateDiscoveryGroupAttribute$str(), attribute, address);
    }
    private static final String couldNotCreateLegacyConnectionFactoryUsingInVMConnector = "WFLYMSG0085: Can not create a legacy-connection-factory based on connection-factory %s. It uses a HornetQ in-vm connector that is not compatible with Artemis in-vm connector ";
    protected String couldNotCreateLegacyConnectionFactoryUsingInVMConnector$str() {
        return couldNotCreateLegacyConnectionFactoryUsingInVMConnector;
    }
    @Override
    public final String couldNotCreateLegacyConnectionFactoryUsingInVMConnector(final PathAddress address) {
        return String.format(couldNotCreateLegacyConnectionFactoryUsingInVMConnector$str(), address);
    }
    private static final String couldNotMigrateResourceAttributeWithExpression = "WFLYMSG0086: Can not migrate attribute %s to resource %s. The attribute uses an expression that can be resolved differently depending on system properties. After migration, this attribute must be added back with an actual value instead of the expression.";
    protected String couldNotMigrateResourceAttributeWithExpression$str() {
        return couldNotMigrateResourceAttributeWithExpression;
    }
    @Override
    public final String couldNotMigrateResourceAttributeWithExpression(final String attribute, final PathAddress address) {
        return String.format(couldNotMigrateResourceAttributeWithExpression$str(), attribute, address);
    }
    private static final String couldNotMigrateUnsupportedAttribute = "WFLYMSG0087: Can not migrate attribute %s to resource %s. This attribute is not supported by the new messaging-activemq subsystem.";
    protected String couldNotMigrateUnsupportedAttribute$str() {
        return couldNotMigrateUnsupportedAttribute;
    }
    @Override
    public final String couldNotMigrateUnsupportedAttribute(final String attribute, final PathAddress address) {
        return String.format(couldNotMigrateUnsupportedAttribute$str(), attribute, address);
    }
    private static final String couldNotMigrateFailbackDelayAttribute = "WFLYMSG0088: Can not migrate attribute failback-delay to resource %s. Artemis detects failback deterministically and it no longer requires to specify a delay for failback to occur.";
    protected String couldNotMigrateFailbackDelayAttribute$str() {
        return couldNotMigrateFailbackDelayAttribute;
    }
    @Override
    public final String couldNotMigrateFailbackDelayAttribute(final PathAddress address) {
        return String.format(couldNotMigrateFailbackDelayAttribute$str(), address);
    }
}
