/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.MultistepUtil;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class MigrateOperation
implements OperationStepHandler {
    private static final String MESSAGING_ACTIVEMQ_EXTENSION = "org.wildfly.extension.messaging-activemq";
    private static final String MESSAGING_ACTIVEMQ_MODULE = "org.wildfly.extension.messaging-activemq";
    private static final PathAddress MESSAGING_EXTENSION = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)"org.jboss.as.messaging")});
    private static final String NEW_ENTRY_SUFFIX = "-new";
    private static final String HORNETQ_NETTY_CONNECTOR_FACTORY = "org.hornetq.core.remoting.impl.netty.NettyConnectorFactory";
    private static final String HORNETQ_NETTY_ACCEPTOR_FACTORY = "org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory";
    private static final String ARTEMIS_NETTY_CONNECTOR_FACTORY = "org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory";
    private static final String ARTEMIS_NETTY_ACCEPTOR_FACTORY = "org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory";
    public static final String MIGRATE = "migrate";
    public static final String MIGRATION_WARNINGS = "migration-warnings";
    public static final String MIGRATION_ERROR = "migration-error";
    public static final String MIGRATION_OPERATIONS = "migration-operations";
    public static final String DESCRIBE_MIGRATION = "describe-migration";
    public static final StringListAttributeDefinition MIGRATION_WARNINGS_ATTR = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("migration-warnings").setRequired(false)).build();
    public static final SimpleMapAttributeDefinition MIGRATION_ERROR_ATTR = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("migration-error", ModelType.OBJECT, true).setValueType(ModelType.OBJECT).setRequired(false)).build();
    private static final OperationStepHandler DESCRIBE_MIGRATION_INSTANCE = new MigrateOperation(true);
    private static final OperationStepHandler MIGRATE_INSTANCE = new MigrateOperation(false);
    private static final AttributeDefinition ADD_LEGACY_ENTRIES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"add-legacy-entries", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(ModelNode.FALSE)).build();
    public static final String HA_POLICY = "ha-policy";
    private final boolean describe;

    private MigrateOperation(boolean describe) {
        this.describe = describe;
    }

    static void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(MIGRATE, resourceDescriptionResolver).setParameters(new AttributeDefinition[]{ADD_LEGACY_ENTRIES}).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR, MIGRATION_ERROR_ATTR}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).build(), MIGRATE_INSTANCE);
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(DESCRIBE_MIGRATION, resourceDescriptionResolver).addParameter(ADD_LEGACY_ENTRIES).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).setReadOnly().build(), DESCRIBE_MIGRATION_INSTANCE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.describe && context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw MessagingLogger.ROOT_LOGGER.migrateOperationAllowedOnlyInAdminOnly();
        }
        final boolean addLegacyEntries = ADD_LEGACY_ENTRIES.resolveModelAttribute(context, operation).asBoolean();
        final ArrayList warnings = new ArrayList();
        final ModelNode legacyModelAddOps = new ModelNode();
        final LinkedHashMap<PathAddress, ModelNode> migrationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        this.describeLegacyMessagingResources(context, legacyModelAddOps);
        this.addMessagingActiveMQExtension(context, migrationOperations, this.describe);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                MigrateOperation.this.transformResources(context, legacyModelAddOps, migrationOperations, addLegacyEntries, warnings);
                MigrateOperation.this.removeMessagingSubsystem(migrationOperations, context.getProcessType() == ProcessType.STANDALONE_SERVER);
                PathAddress parentAddress = context.getCurrentAddress().getParent();
                MigrateOperation.this.fixAddressesForDomainMode(parentAddress, migrationOperations);
                if (MigrateOperation.this.describe) {
                    Collection values = migrationOperations.values();
                    ModelNode result = new ModelNode();
                    MigrateOperation.this.fillWarnings(result, warnings);
                    result.get(MigrateOperation.MIGRATION_OPERATIONS).set(values);
                    context.getResult().set(result);
                } else {
                    final Map migrateOpResponses = MigrateOperation.this.migrateSubsystems(context, migrationOperations);
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            ModelNode result = new ModelNode();
                            MigrateOperation.this.fillWarnings(result, warnings);
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                for (Map.Entry entry : migrateOpResponses.entrySet()) {
                                    if (!((ModelNode)entry.getValue()).hasDefined("failure-description")) continue;
                                    ModelNode desc = new ModelNode();
                                    desc.get("operation").set((ModelNode)migrationOperations.get(entry.getKey()));
                                    desc.get("result").set((ModelNode)entry.getValue());
                                    result.get(MigrateOperation.MIGRATION_ERROR).set(desc);
                                    break;
                                }
                                context.getFailureDescription().set(MessagingLogger.ROOT_LOGGER.migrationFailed());
                            }
                            context.getResult().set(result);
                        }
                    });
                }
            }
        }, OperationContext.Stage.MODEL);
    }

    protected void fillWarnings(ModelNode result, List<String> warnings) {
        ModelNode rw = new ModelNode().setEmptyList();
        for (String warning : warnings) {
            rw.add(warning);
        }
        result.get(MIGRATION_WARNINGS).set(rw);
    }

    private void fixAddressesForDomainMode(PathAddress parentAddress, Map<PathAddress, ModelNode> migrationOperations) {
        if (parentAddress.size() == 0) {
            return;
        }
        LinkedHashMap<PathAddress, ModelNode> fixedMigrationOperations = new LinkedHashMap<PathAddress, ModelNode>(migrationOperations);
        migrationOperations.clear();
        for (Map.Entry entry : fixedMigrationOperations.entrySet()) {
            PathAddress fixedAddress = parentAddress.append((PathAddress)entry.getKey());
            ((ModelNode)entry.getValue()).get("address").set(fixedAddress.toModelNode());
            migrationOperations.put(fixedAddress, (ModelNode)entry.getValue());
        }
    }

    private void addMessagingActiveMQExtension(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, boolean describe) {
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        if (root.getChildrenNames("extension").contains("org.wildfly.extension.messaging-activemq")) {
            return;
        }
        PathAddress extensionAddress = PathAddress.pathAddress((String)"extension", (String)"org.wildfly.extension.messaging-activemq");
        OperationEntry addEntry = context.getRootResourceRegistration().getOperationEntry(extensionAddress, "add");
        ModelNode addOperation = Util.createAddOperation((PathAddress)extensionAddress);
        addOperation.get("module").set("org.wildfly.extension.messaging-activemq");
        if (describe) {
            migrationOperations.put(extensionAddress, addOperation);
        } else {
            context.addStep(context.getResult().get(extensionAddress.toString()), addOperation, addEntry.getOperationHandler(), OperationContext.Stage.MODEL);
        }
    }

    private void removeMessagingSubsystem(Map<PathAddress, ModelNode> migrationOperations, boolean standalone) {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{MessagingExtension.SUBSYSTEM_PATH});
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)subsystemAddress);
        migrationOperations.put(subsystemAddress, removeOperation);
        if (standalone) {
            removeOperation = Util.createRemoveOperation((PathAddress)MESSAGING_EXTENSION);
            migrationOperations.put(MESSAGING_EXTENSION, removeOperation);
        }
    }

    private Map<PathAddress, ModelNode> migrateSubsystems(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) throws OperationFailedException {
        LinkedHashMap<PathAddress, ModelNode> result = new LinkedHashMap<PathAddress, ModelNode>();
        MultistepUtil.recordOperationSteps((OperationContext)context, migrationOperations, result);
        return result;
    }

    private ModelNode transformAddress(ModelNode legacyAddress) {
        ModelNode newAddress = new ModelNode();
        for (Property segment : legacyAddress.asPropertyList()) {
            Property newSegment;
            switch (segment.getName()) {
                case "subsystem": {
                    newSegment = new Property("subsystem", new ModelNode("messaging-activemq"));
                    break;
                }
                case "hornetq-server": {
                    newSegment = new Property("server", segment.getValue());
                    break;
                }
                default: {
                    newSegment = segment;
                }
            }
            newAddress.add(newSegment);
        }
        return newAddress;
    }

    private void transformResources(OperationContext context, ModelNode legacyModelDescription, Map<PathAddress, ModelNode> newAddOperations, boolean addLegacyEntries, List<String> warnings) throws OperationFailedException {
        block28: for (ModelNode legacyAddOp : legacyModelDescription.get("result").asList()) {
            ModelNode newAddOp = legacyAddOp.clone();
            ModelNode legacyAddress = legacyAddOp.get("address");
            ModelNode newAddress = this.transformAddress(legacyAddress.clone());
            newAddOp.get("address").set(newAddress);
            PathAddress address = PathAddress.pathAddress((ModelNode)newAddress);
            if (address.size() == 2 && "server".equals(address.getLastElement().getKey())) {
                this.migrateServer(PathAddress.pathAddress((ModelNode)legacyAddress), newAddOp, newAddOperations, warnings);
                continue;
            }
            if (newAddress.asList().size() > 2) {
                String parentType = address.getElement(1).getKey();
                String resourceType = address.getElement(2).getKey();
                if ("server".equals(parentType)) {
                    switch (resourceType) {
                        case "broadcast-group": {
                            this.migrateBroadcastGroup(newAddOp, warnings);
                            break;
                        }
                        case "discovery-group": {
                            this.migrateDiscoveryGroup(newAddOp, warnings);
                            break;
                        }
                        case "connection-factory": {
                            if (addLegacyEntries) {
                                if (this.connectionFactoryIsUsingInVMConnectors(context, legacyAddOp)) {
                                    warnings.add(MessagingLogger.ROOT_LOGGER.couldNotCreateLegacyConnectionFactoryUsingInVMConnector(address));
                                } else {
                                    PathAddress legacyConnectionFactoryAddress = address.getParent().append("legacy-connection-factory", address.getLastElement().getValue());
                                    ModelNode addLegacyConnectionFactoryOp = legacyAddOp.clone();
                                    addLegacyConnectionFactoryOp.get("address").set(legacyConnectionFactoryAddress.toModelNode());
                                    this.migrateConnectionFactory(addLegacyConnectionFactoryOp, "");
                                    newAddOperations.put(legacyConnectionFactoryAddress, addLegacyConnectionFactoryOp);
                                }
                            }
                            this.migrateConnectionFactory(newAddOp, addLegacyEntries ? NEW_ENTRY_SUFFIX : "");
                            break;
                        }
                        case "pooled-connection-factory": {
                            this.migratePooledConnectionFactory(newAddOp);
                            break;
                        }
                        case "cluster-connection": {
                            this.migrateClusterConnection(newAddOp, warnings);
                            break;
                        }
                        case "bridge": {
                            this.migrateBridge(newAddOp);
                            break;
                        }
                        case "jms-queue": 
                        case "jms-topic": {
                            if (!addLegacyEntries) break;
                            this.addLegacyEntries(newAddOp);
                            break;
                        }
                        case "acceptor": 
                        case "connector": {
                            this.migrateGenericTransport(newAddOp);
                        }
                        case "http-acceptor": 
                        case "remote-acceptor": 
                        case "http-connector": 
                        case "remote-connector": 
                        case "connector-service": {
                            if (address.size() != 4) break;
                            String name = address.getLastElement().getValue();
                            ModelNode value = newAddOp.get("value");
                            ModelNode parentAddOp = newAddOperations.get(address.getParent());
                            if (name.equals("http-upgrade-endpoint") && address.getParent().getLastElement().getKey().equals("http-connector")) {
                                parentAddOp.get("endpoint").set(value);
                                continue block28;
                            }
                            if (this.parameterIsAllowed(name, resourceType)) {
                                parentAddOp.get("params").add(new Property(name, value));
                                continue block28;
                            }
                            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateUnsupportedAttribute(name, address.getParent()));
                            continue block28;
                        }
                    }
                }
            }
            if (!newAddOp.isDefined()) continue;
            newAddOperations.put(address, newAddOp);
        }
    }

    private boolean parameterIsAllowed(String name, String resourceType) {
        switch (resourceType) {
            case "remote-acceptor": 
            case "http-acceptor": 
            case "remote-connector": 
            case "http-connector": {
                return !"use-nio".equals(name);
            }
        }
        return true;
    }

    private boolean connectionFactoryIsUsingInVMConnectors(OperationContext context, ModelNode connectionFactoryAddOp) {
        ModelNode connector = connectionFactoryAddOp.get("connector");
        if (connector.isDefined()) {
            PathAddress connectionFactoryAddress = PathAddress.pathAddress((ModelNode)connectionFactoryAddOp.get("address"));
            PathElement relativeLegacyServerAddress = connectionFactoryAddress.getParent().getLastElement();
            Resource serverResource = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{relativeLegacyServerAddress}), false);
            Set definedInVMConnectors = serverResource.getChildrenNames("in-vm-connector");
            List connectorProps = connector.asPropertyList();
            for (Property connectorProp : connectorProps) {
                String connectorName = connectorProp.getName();
                if (!definedInVMConnectors.contains(connectorName)) continue;
                return true;
            }
        }
        return false;
    }

    private void migrateDiscoveryGroup(ModelNode newAddOp, List<String> warnings) {
        for (String property : Arrays.asList(CommonAttributes.LOCAL_BIND_ADDRESS.getName(), CommonAttributes.GROUP_ADDRESS.getName(), CommonAttributes.GROUP_PORT.getName())) {
            if (!newAddOp.has(property)) continue;
            newAddOp.remove(property);
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateDiscoveryGroupAttribute(property, PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        this.removePropertiesWithExpression(newAddOp, warnings, CommonAttributes.JGROUPS_CHANNEL.getName(), CommonAttributes.JGROUPS_STACK.getName());
        if (!newAddOp.hasDefined(CommonAttributes.SOCKET_BINDING.getName())) {
            if (!newAddOp.hasDefined(CommonAttributes.JGROUPS_CHANNEL.getName())) {
                warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateDiscoveryGroup(PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
                newAddOp.clear();
            } else {
                newAddOp.get("jgroups-cluster").set(newAddOp.get(CommonAttributes.JGROUPS_CHANNEL.getName()));
            }
        }
    }

    private void migrateBroadcastGroup(ModelNode newAddOp, List<String> warnings) {
        List<String> unmigratedProperties = Arrays.asList(CommonAttributes.LOCAL_BIND_ADDRESS.getName(), CommonAttributes.LOCAL_BIND_PORT.getName(), CommonAttributes.GROUP_ADDRESS.getName(), CommonAttributes.GROUP_PORT.getName());
        for (Property property : newAddOp.asPropertyList()) {
            if (!unmigratedProperties.contains(property.getName())) continue;
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateBroadcastGroupAttribute(property.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
        boolean clearOp = false;
        if (!newAddOp.hasDefined("connectors")) {
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateBroadcastGroupWithoutConnectors(PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
            clearOp = true;
        }
        this.removePropertiesWithExpression(newAddOp, warnings, CommonAttributes.JGROUPS_CHANNEL.getName(), CommonAttributes.JGROUPS_STACK.getName());
        if (!newAddOp.hasDefined(CommonAttributes.SOCKET_BINDING.getName())) {
            if (!newAddOp.hasDefined(CommonAttributes.JGROUPS_CHANNEL.getName())) {
                warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateBroadcastGroup(PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
                clearOp = true;
            } else {
                newAddOp.get("jgroups-cluster").set(newAddOp.get(CommonAttributes.JGROUPS_CHANNEL.getName()));
            }
        }
        if (clearOp) {
            newAddOp.clear();
        }
    }

    private void removePropertiesWithExpression(ModelNode newAddOp, List<String> warnings, String ... properties) {
        for (String property : properties) {
            if (!newAddOp.hasDefined(property) || newAddOp.get(property).getType() != ModelType.EXPRESSION) continue;
            newAddOp.remove(property);
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateResourceAttributeWithExpression(property, PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
    }

    private void addLegacyEntries(ModelNode newAddOp) {
        newAddOp.get("legacy-entries").set(newAddOp.get("entries"));
        newAddOp.remove("entries");
        for (ModelNode legacyEntry : newAddOp.get("legacy-entries").asList()) {
            String newEntry = legacyEntry.asString() + NEW_ENTRY_SUFFIX;
            newAddOp.get("entries").add(newEntry);
        }
    }

    private void describeLegacyMessagingResources(OperationContext context, ModelNode legacyModelDescription) {
        ModelNode describeLegacySubsystem = Util.createOperation((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (PathAddress)context.getCurrentAddress());
        context.addStep(legacyModelDescription, describeLegacySubsystem, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
    }

    private void migrateConnectionFactory(ModelNode addOperation, String entrySuffix) {
        this.migrateConnectorAttribute(addOperation);
        this.migrateDiscoveryGroupNameAttribute(addOperation);
        if (!entrySuffix.isEmpty()) {
            List entries = addOperation.get("entries").asList();
            addOperation.remove("entries");
            for (ModelNode entry : entries) {
                String newEntry = entry.asString() + entrySuffix;
                addOperation.get("entries").add(newEntry);
            }
        }
    }

    private void migratePooledConnectionFactory(ModelNode addOperation) {
        this.migrateConnectorAttribute(addOperation);
        this.migrateDiscoveryGroupNameAttribute(addOperation);
        addOperation.get("allow-local-transactions").set(ModelNode.TRUE);
    }

    private void migrateClusterConnection(ModelNode addOperation, List<String> warnings) {
        addOperation.get("connector-name").set(addOperation.get("connector-ref"));
        addOperation.remove("connector-ref");
        ModelNode forwardWhenNoConsumers = addOperation.get(ClusterConnectionDefinition.FORWARD_WHEN_NO_CONSUMERS.getName());
        if (forwardWhenNoConsumers.getType() == ModelType.EXPRESSION) {
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateResourceAttributeWithExpression(ClusterConnectionDefinition.FORWARD_WHEN_NO_CONSUMERS.getName(), PathAddress.pathAddress((ModelNode)addOperation.get("address"))));
        } else {
            boolean value = forwardWhenNoConsumers.asBoolean(ClusterConnectionDefinition.FORWARD_WHEN_NO_CONSUMERS.getDefaultValue().asBoolean());
            String messageLoadBalancingType = value ? "STRICT" : "ON_DEMAND";
            addOperation.get("message-load-balancing-type").set(messageLoadBalancingType);
        }
        addOperation.remove(ClusterConnectionDefinition.FORWARD_WHEN_NO_CONSUMERS.getName());
        this.migrateDiscoveryGroupNameAttribute(addOperation);
    }

    private void migrateConnectorAttribute(ModelNode addOperation) {
        ModelNode connector = addOperation.get("connector");
        if (connector.isDefined()) {
            List connectorProps = connector.asPropertyList();
            for (Property connectorProp : connectorProps) {
                addOperation.get("connectors").add(connectorProp.getName());
            }
            addOperation.remove("connector");
        }
    }

    private void migrateDiscoveryGroupNameAttribute(ModelNode addOperation) {
        ModelNode discoveryGroup = addOperation.get("discovery-group-name");
        if (discoveryGroup.isDefined()) {
            addOperation.get("discovery-group").set(discoveryGroup);
            addOperation.remove("discovery-group-name");
        }
    }

    private void migrateBridge(ModelNode addOperation) {
        this.migrateDiscoveryGroupNameAttribute(addOperation);
    }

    private void migrateGenericTransport(ModelNode addOperation) {
        String newFactoryClass;
        String factoryClass;
        switch (factoryClass = addOperation.get(CommonAttributes.FACTORY_CLASS.getName()).asString()) {
            case "org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory": {
                newFactoryClass = ARTEMIS_NETTY_ACCEPTOR_FACTORY;
                break;
            }
            case "org.hornetq.core.remoting.impl.netty.NettyConnectorFactory": {
                newFactoryClass = ARTEMIS_NETTY_CONNECTOR_FACTORY;
                break;
            }
            default: {
                newFactoryClass = factoryClass;
            }
        }
        addOperation.get(CommonAttributes.FACTORY_CLASS.getName()).set(newFactoryClass);
    }

    private void migrateServer(PathAddress legacyAddress, ModelNode addOperation, Map<PathAddress, ModelNode> newAddOperations, List<String> warnings) {
        this.discardInterceptors(addOperation, CommonAttributes.REMOTING_INTERCEPTORS.getName(), warnings);
        this.discardInterceptors(addOperation, CommonAttributes.REMOTING_INCOMING_INTERCEPTORS.getName(), warnings);
        this.discardInterceptors(addOperation, CommonAttributes.REMOTING_OUTGOING_INTERCEPTORS.getName(), warnings);
        newAddOperations.put(PathAddress.pathAddress((ModelNode)addOperation.get("address")), addOperation);
        this.migrateHAPolicy(legacyAddress, addOperation, newAddOperations, warnings);
    }

    private void migrateHAPolicy(PathAddress legacyAddress, ModelNode serverAddOperation, Map<PathAddress, ModelNode> newAddOperations, List<String> warnings) {
        PathAddress haPolicyAddress;
        PathAddress serverAddress = PathAddress.pathAddress((ModelNode)serverAddOperation.get("address"));
        ModelNode sharedStoreAttr = serverAddOperation.get(CommonAttributes.SHARED_STORE.getName());
        ModelNode backupAttr = serverAddOperation.get(CommonAttributes.BACKUP.getName());
        if (sharedStoreAttr.getType() == ModelType.EXPRESSION || backupAttr.getType() == ModelType.EXPRESSION) {
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateHA(legacyAddress));
            return;
        }
        boolean sharedStore = sharedStoreAttr.isDefined() ? sharedStoreAttr.asBoolean() : CommonAttributes.SHARED_STORE.getDefaultValue().asBoolean();
        boolean backup = backupAttr.isDefined() ? backupAttr.asBoolean() : CommonAttributes.BACKUP.getDefaultValue().asBoolean();
        ModelNode haPolicyAddOperation = Util.createAddOperation();
        if (sharedStore) {
            if (backup) {
                haPolicyAddress = serverAddress.append(HA_POLICY, "shared-store-slave");
                this.setAndDiscard(haPolicyAddOperation, serverAddOperation, (AttributeDefinition)CommonAttributes.ALLOW_FAILBACK, "allow-failback");
                this.setAndDiscard(haPolicyAddOperation, serverAddOperation, (AttributeDefinition)CommonAttributes.FAILOVER_ON_SHUTDOWN, "failover-on-server-shutdown");
                this.discardFailbackDelay(serverAddOperation, warnings);
            } else {
                haPolicyAddress = serverAddress.append(HA_POLICY, "shared-store-master");
                this.setAndDiscard(haPolicyAddOperation, serverAddOperation, (AttributeDefinition)CommonAttributes.FAILOVER_ON_SHUTDOWN, "failover-on-server-shutdown");
                this.discardFailbackDelay(serverAddOperation, warnings);
            }
        } else if (backup) {
            haPolicyAddress = serverAddress.append(HA_POLICY, "replication-slave");
            this.setAndDiscard(haPolicyAddOperation, serverAddOperation, (AttributeDefinition)CommonAttributes.ALLOW_FAILBACK, "allow-failback");
            this.setAndDiscard(haPolicyAddOperation, serverAddOperation, CommonAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE, "max-saved-replicated-journal-size");
            this.setAndDiscard(haPolicyAddOperation, serverAddOperation, CommonAttributes.BACKUP_GROUP_NAME, "group-name");
            this.discardFailbackDelay(serverAddOperation, warnings);
        } else {
            haPolicyAddress = serverAddress.append(HA_POLICY, "replication-master");
            this.setAndDiscard(haPolicyAddOperation, serverAddOperation, (AttributeDefinition)CommonAttributes.CHECK_FOR_LIVE_SERVER, "check-for-live-server");
            this.setAndDiscard(haPolicyAddOperation, serverAddOperation, CommonAttributes.BACKUP_GROUP_NAME, "group-name");
        }
        haPolicyAddOperation.get("address").set(haPolicyAddress.toModelNode());
        newAddOperations.put(haPolicyAddress, haPolicyAddOperation);
    }

    private void discardInterceptors(ModelNode addOperation, String legacyInterceptorsAttributeName, List<String> warnings) {
        if (!addOperation.get(legacyInterceptorsAttributeName).isDefined()) {
            return;
        }
        warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateInterceptors(legacyInterceptorsAttributeName));
        addOperation.remove(legacyInterceptorsAttributeName);
    }

    private void setAndDiscard(ModelNode setNode, ModelNode discardNode, AttributeDefinition legacyAttributeDefinition, String newAttributeName) {
        ModelNode attribute = discardNode.get(legacyAttributeDefinition.getName());
        if (attribute.isDefined()) {
            setNode.get(newAttributeName).set(attribute);
            discardNode.remove(legacyAttributeDefinition.getName());
        }
    }

    private void discardUnsupportedAttribute(ModelNode newAddOp, AttributeDefinition legacyAttributeDefinition, List<String> warnings) {
        if (newAddOp.hasDefined(legacyAttributeDefinition.getName())) {
            newAddOp.remove(legacyAttributeDefinition.getName());
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateUnsupportedAttribute(legacyAttributeDefinition.getName(), PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
    }

    private void discardFailbackDelay(ModelNode newAddOp, List<String> warnings) {
        if (newAddOp.hasDefined(CommonAttributes.FAILBACK_DELAY.getName())) {
            newAddOp.remove(CommonAttributes.FAILBACK_DELAY.getName());
            warnings.add(MessagingLogger.ROOT_LOGGER.couldNotMigrateFailbackDelayAttribute(PathAddress.pathAddress((ModelNode)newAddOp.get("address"))));
        }
    }
}

