package org.jboss.as.messaging.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.messaging.Element;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelType;
import java.util.Collection;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-08-28T22:24:42-0500")
public class MessagingLogger_$logger extends DelegatingBasicLogger implements MessagingLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MessagingLogger_$logger.class.getName();
    public MessagingLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void deprecatedXMLElement(final String name) {
        super.log.logf(FQCN, WARN, null, deprecatedXMLElement1$str(), name);
    }
    protected String deprecatedXMLElement1$str() {
        return "WFLYMSG0009: Element %s is deprecated and will not be taken into account";
    }
    @Override
    public final void deprecatedXMLAttribute(final String name) {
        super.log.logf(FQCN, WARN, null, deprecatedXMLAttribute$str(), name);
    }
    protected String deprecatedXMLAttribute$str() {
        return "WFLYMSG0010: Attribute %s is deprecated and will not be taken into account";
    }
    @Override
    public final void deprecatedAttribute(final String name, final PathAddress address) {
        super.log.logf(FQCN, WARN, null, deprecatedAttribute$str(), name, address);
    }
    protected String deprecatedAttribute$str() {
        return "WFLYMSG0013: Attribute %s of the resource at %s is deprecated and setting its value will not be taken into account";
    }
    protected String canNotChangeClusteredAttribute$str() {
        return "WFLYMSG0014: Can not change the clustered attribute to false: The hornetq-server resource at %s has cluster-connection children resources and will remain clustered.";
    }
    @Override
    public final String canNotChangeClusteredAttribute(final PathAddress address) {
        return String.format(getLoggingLocale(), canNotChangeClusteredAttribute$str(), address);
    }
    @Override
    public final void deprecatedXMLElement(final String name, final String replacement) {
        super.log.logf(FQCN, WARN, null, deprecatedXMLElement2$str(), name, replacement);
    }
    protected String deprecatedXMLElement2$str() {
        return "WFLYMSG0017: Element %s is deprecated and %s will be used in its place";
    }
    protected String altAttributeAlreadyDefined$str() {
        return "WFLYMSG0019: Alternative attribute of (%s) is already defined.";
    }
    @Override
    public final String altAttributeAlreadyDefined(final String name) {
        return String.format(getLoggingLocale(), altAttributeAlreadyDefined$str(), name);
    }
    protected String attributeDefinitionsMustMatch$str() {
        return "WFLYMSG0020: All attribute definitions must have the same xml name -- found %s but already had %s";
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsMustMatch(final String nameFound, final String nameRequired) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), attributeDefinitionsMustMatch$str(), nameFound, nameRequired));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String attributeDefinitionsNotUnique$str() {
        return "WFLYMSG0021: All attribute definitions must have unique names -- already found %s";
    }
    @Override
    public final IllegalArgumentException attributeDefinitionsNotUnique(final String nameFound) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), attributeDefinitionsNotUnique$str(), nameFound));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotIncludeOperationParameters$str() {
        return "WFLYMSG0023: Operation cannot include both parameter %s and parameter %s";
    }
    @Override
    public final String cannotIncludeOperationParameters(final String paramName1, final String paramName2) {
        return String.format(getLoggingLocale(), cannotIncludeOperationParameters$str(), paramName1, paramName2);
    }
    protected String ignoringUnhandledElement$str() {
        return "WFLYMSG0034: Ignoring unhandled element: %s, at: %s";
    }
    @Override
    public final XMLStreamException ignoringUnhandledElement(final Element element, final String location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), ignoringUnhandledElement$str(), element, location));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalElement$str() {
        return "WFLYMSG0035: Illegal element %s: cannot be used when %s is used";
    }
    @Override
    public final String illegalElement(final String illegalElement, final String element) {
        return String.format(getLoggingLocale(), illegalElement$str(), illegalElement, element);
    }
    protected String illegalValue2$str() {
        return "WFLYMSG0036: Illegal value %s for element %s";
    }
    @Override
    public final String illegalValue(final Object value, final String element) {
        return String.format(getLoggingLocale(), illegalValue2$str(), value, element);
    }
    protected String illegalValue3$str() {
        return "WFLYMSG0036: Illegal value %s for element %s as it could not be converted to required type %s";
    }
    @Override
    public final String illegalValue(final Object value, final String element, final ModelType expectedType) {
        return String.format(getLoggingLocale(), illegalValue3$str(), value, element, expectedType);
    }
    protected String invalid$str() {
        return "WFLYMSG0038: %s is invalid";
    }
    @Override
    public final String invalid(final Object obj) {
        return String.format(getLoggingLocale(), invalid$str(), obj);
    }
    protected String invalidOperationParameters$str() {
        return "WFLYMSG0040: Operation must include parameter %s or parameter %s";
    }
    @Override
    public final String invalidOperationParameters(final String paramName1, final String paramName2) {
        return String.format(getLoggingLocale(), invalidOperationParameters$str(), paramName1, paramName2);
    }
    protected String multipleChildrenFound$str() {
        return "WFLYMSG0044: Multiple %s children found; only one is allowed";
    }
    @Override
    public final IllegalStateException multipleChildrenFound(final String element) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipleChildrenFound$str(), element));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String required1$str() {
        return "WFLYMSG0045: %s is required";
    }
    @Override
    public final String required(final Object obj) {
        return String.format(getLoggingLocale(), required1$str(), obj);
    }
    protected String required2$str() {
        return "WFLYMSG0046: Either %s or %s is required";
    }
    @Override
    public final String required(final Object obj1, final Object obj2) {
        return String.format(getLoggingLocale(), required2$str(), obj1, obj2);
    }
    protected String unsupportedElement$str() {
        return "WFLYMSG0051: Implement support for element %s";
    }
    @Override
    public final UnsupportedOperationException unsupportedElement(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedElement$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String onlyOneRequired$str() {
        return "WFLYMSG0059: Only one of %s or %s is required";
    }
    @Override
    public final String onlyOneRequired(final Object obj1, final Object obj2) {
        return String.format(getLoggingLocale(), onlyOneRequired$str(), obj1, obj2);
    }
    protected String wrongConnectorRefInBroadCastGroup$str() {
        return "WFLYMSG0067: The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.";
    }
    @Override
    public final OperationFailedException wrongConnectorRefInBroadCastGroup(final String bgName, final String connectorRef, final Collection<String> presentConnectors) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), wrongConnectorRefInBroadCastGroup$str(), bgName, connectorRef, presentConnectors));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String undefineAttributeWithoutAlternative$str() {
        return "WFLYMSG0069: Attribute (%s) can not been undefined as the resource does not define any alternative to this attribute.";
    }
    @Override
    public final String undefineAttributeWithoutAlternative(final String name) {
        return String.format(getLoggingLocale(), undefineAttributeWithoutAlternative$str(), name);
    }
    protected String inconsistentStatisticsSettings$str() {
        return "WFLYMSG0070: Attributes %s is an alias for attribute %s; both cannot be set with conflicting values.";
    }
    @Override
    public final OperationFailedException inconsistentStatisticsSettings(final String attrOne, final String attrTwo) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), inconsistentStatisticsSettings$str(), attrOne, attrTwo));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void noMatchingExpiryAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, WARN, null, noMatchingExpiryAddress$str(), address, addressSettings);
    }
    protected String noMatchingExpiryAddress$str() {
        return "WFLYMSG0071: There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!";
    }
    @Override
    public final void noMatchingDeadLetterAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, WARN, null, noMatchingDeadLetterAddress$str(), address, addressSettings);
    }
    protected String noMatchingDeadLetterAddress$str() {
        return "WFLYMSG0072: There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!";
    }
    protected String duplicateElements$str() {
        return "WFLYMSG0076: Parameter %s contains duplicate elements [%s]";
    }
    @Override
    public final OperationFailedException duplicateElements(final String parameterName, final ModelNode elements) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), duplicateElements$str(), parameterName, elements));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String migrateOperationAllowedOnlyInAdminOnly$str() {
        return "WFLYMSG0079: The migrate operation can not be performed: the server must be in admin-only mode";
    }
    @Override
    public final OperationFailedException migrateOperationAllowedOnlyInAdminOnly() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), migrateOperationAllowedOnlyInAdminOnly$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotMigrateBroadcastGroupAttribute$str() {
        return "WFLYMSG0080: Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this broadcast-group.";
    }
    @Override
    public final String couldNotMigrateBroadcastGroupAttribute(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateBroadcastGroupAttribute$str(), attribute, address);
    }
    protected String migrationFailed$str() {
        return "WFLYMSG0081: Migration failed, see results for more details.";
    }
    @Override
    public final String migrationFailed() {
        return String.format(getLoggingLocale(), migrationFailed$str());
    }
    protected String couldNotMigrateInterceptors$str() {
        return "WFLYMSG0082: Classes providing the %s are discarded during the migration. To use them in the new messaging-activemq subsystem, you will have to extend the Artemis-based Interceptor.";
    }
    @Override
    public final String couldNotMigrateInterceptors(final String legacyInterceptorsAttributeName) {
        return String.format(getLoggingLocale(), couldNotMigrateInterceptors$str(), legacyInterceptorsAttributeName);
    }
    protected String couldNotMigrateHA$str() {
        return "WFLYMSG0083: Can not migrate the HA configuration of %s. Its shared-store and backup attributes holds expressions and it is not possible to determine unambiguously how to create the corresponding ha-policy for the messaging-activemq's server.";
    }
    @Override
    public final String couldNotMigrateHA(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateHA$str(), address);
    }
    protected String couldNotMigrateDiscoveryGroupAttribute$str() {
        return "WFLYMSG0084: Can not migrate attribute %s to resource %s. Use instead the socket-binding attribute to configure this discovery-group.";
    }
    @Override
    public final String couldNotMigrateDiscoveryGroupAttribute(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateDiscoveryGroupAttribute$str(), attribute, address);
    }
    protected String couldNotCreateLegacyConnectionFactoryUsingInVMConnector$str() {
        return "WFLYMSG0085: Can not create a legacy-connection-factory based on connection-factory %s. It uses a HornetQ in-vm connector that is not compatible with Artemis in-vm connector ";
    }
    @Override
    public final String couldNotCreateLegacyConnectionFactoryUsingInVMConnector(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotCreateLegacyConnectionFactoryUsingInVMConnector$str(), address);
    }
    protected String couldNotMigrateResourceAttributeWithExpression$str() {
        return "WFLYMSG0086: Can not migrate attribute %s to resource %s. The attribute uses an expression that can be resolved differently depending on system properties. After migration, this attribute must be added back with an actual value instead of the expression.";
    }
    @Override
    public final String couldNotMigrateResourceAttributeWithExpression(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateResourceAttributeWithExpression$str(), attribute, address);
    }
    protected String couldNotMigrateUnsupportedAttribute$str() {
        return "WFLYMSG0087: Can not migrate attribute %s to resource %s. This attribute is not supported by the new messaging-activemq subsystem.";
    }
    @Override
    public final String couldNotMigrateUnsupportedAttribute(final String attribute, final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateUnsupportedAttribute$str(), attribute, address);
    }
    protected String couldNotMigrateFailbackDelayAttribute$str() {
        return "WFLYMSG0088: Can not migrate attribute failback-delay to resource %s. Artemis detects failback deterministically and it no longer requires to specify a delay for failback to occur.";
    }
    @Override
    public final String couldNotMigrateFailbackDelayAttribute(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateFailbackDelayAttribute$str(), address);
    }
    protected String couldNotMigrateDiscoveryGroup$str() {
        return "WFLYMSG0089: Can not migrate discovery group %s as no network configuration is properly defined.";
    }
    @Override
    public final String couldNotMigrateDiscoveryGroup(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateDiscoveryGroup$str(), address);
    }
    protected String couldNotMigrateBroadcastGroup$str() {
        return "WFLYMSG0090: Can not migrate broadcast group %s as no network configuration is properly defined.";
    }
    @Override
    public final String couldNotMigrateBroadcastGroup(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateBroadcastGroup$str(), address);
    }
    protected String couldNotMigrateBroadcastGroupWithoutConnectors$str() {
        return "WFLYMSG0091: Can not migrate broadcast group %s as no connector is properly defined.";
    }
    @Override
    public final String couldNotMigrateBroadcastGroupWithoutConnectors(final PathAddress address) {
        return String.format(getLoggingLocale(), couldNotMigrateBroadcastGroupWithoutConnectors$str(), address);
    }
}
