/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.management.AddressControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class SecurityRoleReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final SecurityRoleReadAttributeHandler INSTANCE = new SecurityRoleReadAttributeHandler();

    private SecurityRoleReadAttributeHandler() {
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String attributeName = operation.require("name").asString();
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String addressName = pathAddress.getElement(pathAddress.size() - 2).getValue();
        String roleName = pathAddress.getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        AddressControl control = (AddressControl)AddressControl.class.cast(hqServer.getManagementService().getResource("core.address." + addressName));
        if (control == null) {
            ManagementUtil.rollbackOperationWithResourceNotFound(context, operation);
            return;
        }
        try {
            String rolesAsJSON = control.getRolesAsJSON();
            ModelNode res = ModelNode.fromJSONString((String)rolesAsJSON);
            ModelNode roles = ManagementUtil.convertSecurityRole(res);
            ModelNode matchedRole = this.findRole(roleName, roles);
            if (matchedRole == null || !matchedRole.hasDefined(attributeName)) {
                throw MessagingMessages.MESSAGES.unsupportedAttribute(attributeName);
            }
            boolean value = matchedRole.get(attributeName).asBoolean();
            context.getResult().set(value);
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        finally {
            context.stepCompleted();
        }
    }

    private ModelNode findRole(String roleName, ModelNode roles) {
        for (ModelNode role : roles.asList()) {
            if (!role.get("name").asString().equals(roleName)) continue;
            return role;
        }
        return null;
    }
}

