/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.deployment.JmsDestination;
import org.jboss.as.messaging.deployment.MessagingAttachments;
import org.jboss.as.messaging.deployment.ParseResult;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicConfigurationRuntimeHandler;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class MessagingXmlInstallDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List parseResults = deploymentUnit.getAttachmentList(MessagingAttachments.PARSE_RESULT);
        for (ParseResult parseResult : parseResults) {
            String[] jndiBindings;
            ServiceName hqServiceName;
            for (JmsDestination topic : parseResult.getTopics()) {
                hqServiceName = MessagingServices.getHornetQServiceName(topic.getServer());
                jndiBindings = null;
                if (topic.getDestination().hasDefined(CommonAttributes.DESTINATION_ENTRIES.getName())) {
                    ModelNode entries = topic.getDestination().resolve().get(CommonAttributes.DESTINATION_ENTRIES.getName());
                    jndiBindings = JMSServices.getJndiBindings(entries);
                }
                JMSTopicAdd.INSTANCE.installServices(null, null, topic.getName(), hqServiceName, phaseContext.getServiceTarget(), jndiBindings);
                PathElement serverElement = PathElement.pathElement((String)"hornetq-server", (String)topic.getServer());
                PathElement destination = PathElement.pathElement((String)"jms-topic", (String)topic.getName());
                deploymentUnit.createDeploymentSubModel("messaging", serverElement);
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, destination});
                MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
                JMSTopicConfigurationRuntimeHandler.INSTANCE.registerDestination(topic.getServer(), topic.getName(), topic.getDestination());
            }
            for (JmsDestination queue : parseResult.getQueues()) {
                hqServiceName = MessagingServices.getHornetQServiceName(queue.getServer());
                jndiBindings = null;
                ModelNode destination = queue.getDestination();
                if (destination.hasDefined(CommonAttributes.DESTINATION_ENTRIES.getName())) {
                    ModelNode entries = destination.resolve().get(CommonAttributes.DESTINATION_ENTRIES.getName());
                    jndiBindings = JMSServices.getJndiBindings(entries);
                }
                String selector = destination.hasDefined(CommonAttributes.SELECTOR.getName()) ? destination.get(CommonAttributes.SELECTOR.getName()).resolve().asString() : null;
                boolean durable = destination.hasDefined(CommonAttributes.DURABLE.getName()) ? destination.get(CommonAttributes.DURABLE.getName()).resolve().asBoolean() : false;
                JMSQueueAdd.INSTANCE.installServices(null, null, queue.getName(), phaseContext.getServiceTarget(), hqServiceName, selector, durable, jndiBindings);
                PathElement serverElement = PathElement.pathElement((String)"hornetq-server", (String)queue.getServer());
                PathElement dest = PathElement.pathElement((String)"jms-queue", (String)queue.getName());
                deploymentUnit.createDeploymentSubModel("messaging", serverElement);
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, dest});
                MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
                JMSQueueConfigurationRuntimeHandler.INSTANCE.registerDestination(queue.getServer(), queue.getName(), destination);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        List parseResults = context.getAttachmentList(MessagingAttachments.PARSE_RESULT);
        for (ParseResult parseResult : parseResults) {
            for (JmsDestination topic : parseResult.getTopics()) {
                JMSTopicConfigurationRuntimeHandler.INSTANCE.unregisterDestination(topic.getServer(), topic.getName());
            }
            for (JmsDestination queue : parseResult.getQueues()) {
                JMSQueueConfigurationRuntimeHandler.INSTANCE.unregisterDestination(queue.getServer(), queue.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ManagementResourceRegistration createDeploymentSubModel(PathAddress address, DeploymentUnit unit) {
        Resource root;
        Resource resource = root = (Resource)unit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        synchronized (resource) {
            ManagementResourceRegistration registration = (ManagementResourceRegistration)unit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
            PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"messaging")});
            Resource subsystem = MessagingXmlInstallDeploymentUnitProcessor.getOrCreate(root, subsystemAddress);
            ManagementResourceRegistration subModel = registration.getSubModel(subsystemAddress.append(address));
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            MessagingXmlInstallDeploymentUnitProcessor.getOrCreate(subsystem, address);
            return subModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Resource getOrCreate(Resource parent, PathAddress address) {
        Resource current = parent;
        for (PathElement element : address) {
            Resource resource = current;
            synchronized (resource) {
                if (current.hasChild(element)) {
                    current = current.requireChild(element);
                } else {
                    Resource resource2 = Resource.Factory.create();
                    current.registerChild(element, resource2);
                    current = resource2;
                }
            }
        }
        return current;
    }
}

