/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.jms.Topic;
import org.hornetq.jms.client.HornetQTopic;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSTopicService
implements Service<Topic> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final String name;
    private final String[] jndi;
    private Topic topic;

    public JMSTopicService(String name, String[] jndi) {
        this.name = name;
        this.jndi = jndi;
    }

    public synchronized void start(final StartContext context) throws StartException {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        context.asynchronous();
        ((ExecutorService)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createTopic(false, JMSTopicService.this.name, JMSTopicService.this.jndi);
                    JMSTopicService.this.topic = (Topic)new HornetQTopic(JMSTopicService.this.name);
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingMessages.MESSAGES.failedToCreate(e, "queue"));
                }
            }
        });
    }

    public synchronized void stop(final StopContext context) {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        context.asynchronous();
        ((ExecutorService)this.executorInjector.getValue()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.removeTopicFromJNDI(JMSTopicService.this.name);
                    JMSTopicService.this.topic = null;
                }
                catch (Throwable e) {
                    MessagingLogger.MESSAGING_LOGGER.failedToDestroy(e, "jms topic", JMSTopicService.this.name);
                }
                context.complete();
            }
        });
    }

    public Topic getValue() throws IllegalStateException {
        return this.topic;
    }

    public static JMSTopicService installService(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ServiceName hqServiceName, ServiceTarget serviceTarget, String[] jndiBindings) {
        JMSTopicService service = new JMSTopicService(name, jndiBindings);
        ServiceName serviceName = JMSServices.getJmsTopicBaseServiceName(hqServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service).addDependency(HornetQActivationService.getHornetQActivationServiceName(hqServiceName)).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.jmsServer).setInitialMode(ServiceController.Mode.PASSIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.executorInjector, (boolean)false);
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
        return service;
    }
}

