/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.messaging.deployment.DirectJMSConnectionFactoryInjectionSource;
import org.jboss.as.messaging.deployment.DirectJMSDestinationInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.JMSConnectionFactoriesMetaData;
import org.jboss.metadata.javaee.spec.JMSConnectionFactoryMetaData;
import org.jboss.metadata.javaee.spec.JMSDestinationMetaData;
import org.jboss.metadata.javaee.spec.JMSDestinationsMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class MessagingJMSDefinitionDeploymentProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ResourceInjectionTarget resourceInjectionTarget, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        JMSConnectionFactoriesMetaData connectionFactoriesMetadata;
        if (environment == null) {
            return Collections.emptyList();
        }
        RemoteEnvironment remoteEnvironment = environment.getEnvironment();
        ArrayList<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
        JMSDestinationsMetaData destinationsMetadata = remoteEnvironment.getJmsDestinations();
        if (destinationsMetadata != null) {
            for (JMSDestinationMetaData metadata : destinationsMetadata) {
                BindingConfiguration bindingConfiguration = this.processJMSDestinationDefinition(metadata);
                bindingConfigurations.add(bindingConfiguration);
            }
        }
        if ((connectionFactoriesMetadata = remoteEnvironment.getJmsConnectionFactories()) != null) {
            for (JMSConnectionFactoryMetaData metadata : connectionFactoriesMetadata) {
                BindingConfiguration bindingConfiguration = this.processJMSConnectionFactoryDefinition(metadata);
                bindingConfigurations.add(bindingConfiguration);
            }
        }
        return bindingConfigurations;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private BindingConfiguration processJMSDestinationDefinition(JMSDestinationMetaData metadata) {
        String name = metadata.getName();
        String interfaceName = metadata.getInterfaceName();
        DirectJMSDestinationInjectionSource source = new DirectJMSDestinationInjectionSource(name, interfaceName);
        source.setDestinationName(metadata.getDestinationName());
        source.setResourceAdapter(metadata.getResourceAdapter());
        source.setClassName(metadata.getClassName());
        PropertiesMetaData properties = metadata.getProperties();
        if (properties != null) {
            for (PropertyMetaData property : properties) {
                source.addProperty(property.getKey(), property.getValue());
            }
        }
        return new BindingConfiguration(name, (InjectionSource)source);
    }

    private BindingConfiguration processJMSConnectionFactoryDefinition(JMSConnectionFactoryMetaData metadata) {
        String name = metadata.getName();
        DirectJMSConnectionFactoryInjectionSource source = new DirectJMSConnectionFactoryInjectionSource(name);
        source.setInterfaceName(metadata.getInterfaceName());
        source.setClassName(metadata.getClassName());
        source.setResourceAdapter(metadata.getResourceAdapter());
        source.setUser(metadata.getUser());
        source.setPassword(metadata.getPassword());
        source.setClientId(metadata.getClientId());
        PropertiesMetaData properties = metadata.getProperties();
        if (properties != null) {
            for (PropertyMetaData property : properties) {
                source.addProperty(property.getKey(), property.getValue());
            }
        }
        source.setTransactional(metadata.isTransactional());
        source.setMaxPoolSize(metadata.getMaxPoolSize());
        source.setMinPoolSize(metadata.getMinPoolSize());
        return new BindingConfiguration(name, (InjectionSource)source);
    }
}

