/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.AcceptorControlHandler;
import org.jboss.as.messaging.HornetQReloadRequiredHandlers;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.TransportParamDefinition;

public abstract class AbstractTransportDefinition
extends SimpleResourceDefinition {
    private final boolean registerRuntimeOnly;
    private final AttributeDefinition[] attrs;
    protected final boolean isAcceptor;

    protected abstract Set<String> getAllowedKeys();

    protected AbstractTransportDefinition(boolean registerRuntimeOnly, boolean isAcceptor, final String specificType, AttributeDefinition ... attrs) {
        super(PathElement.pathElement((String)specificType), (ResourceDescriptionResolver)new StandardResourceDescriptionResolver(isAcceptor ? "acceptor" : "connector", MessagingExtension.RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, false){

            public String getResourceDescription(Locale locale, ResourceBundle bundle) {
                return bundle.getString(specificType);
            }
        }, (OperationStepHandler)new HornetQReloadRequiredHandlers.AddStepHandler(attrs), (OperationStepHandler)new HornetQReloadRequiredHandlers.RemoveStepHandler());
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.isAcceptor = isAcceptor;
        this.attrs = attrs;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        ReloadRequiredWriteAttributeHandler attributeHandler = new ReloadRequiredWriteAttributeHandler(this.attrs);
        for (AttributeDefinition attr : this.attrs) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)attributeHandler);
        }
        if (this.isAcceptor && this.registerRuntimeOnly) {
            AcceptorControlHandler.INSTANCE.registerAttributes(registry);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        if (this.isAcceptor && this.registerRuntimeOnly) {
            AcceptorControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
        }
        super.registerOperations(registry);
    }

    public void registerChildren(ManagementResourceRegistration registry) {
        super.registerChildren(registry);
        registry.registerSubModel((ResourceDefinition)new TransportParamDefinition(this.getAllowedKeys()));
    }
}

