/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;

public final class AlternativeAttributeCheckHandler
implements OperationStepHandler {
    private final Map<String, AttributeDefinition> attributeDefinitions = new HashMap<String, AttributeDefinition>();

    public AlternativeAttributeCheckHandler(AttributeDefinition ... definitions) {
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.get("operation").asString();
        String attributeName = operation.get("name").asString();
        boolean alternativeMustBeSet = "undefine-attribute".equals(operationName);
        this.checkAlternativeAttribute(context, attributeName, alternativeMustBeSet);
        context.stepCompleted();
    }

    private void checkAlternativeAttribute(OperationContext context, String attributeName, boolean alternativeMustBeSet) throws OperationFailedException {
        if (this.attributeDefinitions.containsKey(attributeName)) {
            AttributeDefinition attr = this.attributeDefinitions.get(attributeName);
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            if (alternativeMustBeSet) {
                if (!attr.hasAlternative(resource.getModel())) {
                    throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.undefineAttributeWithoutAlternative(attributeName)));
                }
            } else if (attr.hasAlternative(resource.getModel())) {
                throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.altAttributeAlreadyDefined(attributeName)));
            }
        }
    }

    public static void checkAlternatives(ModelNode operation, String attr1, String attr2, boolean acceptNone) throws OperationFailedException {
        boolean hasAttr1 = operation.hasDefined(attr1);
        boolean hasAttr2 = operation.hasDefined(attr2);
        if (!(hasAttr1 || hasAttr2 || acceptNone)) {
            throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.invalidOperationParameters(attr1, attr2)));
        }
        if (hasAttr1 && hasAttr2) {
            throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.cannotIncludeOperationParameters(attr1, attr2)));
        }
    }
}

