/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.JGroupsBroadcastGroupConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.GroupBindingService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.OperationValidator;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jgroups.JChannel;

public class BroadcastGroupAdd
extends AbstractAddStepHandler {
    private static final OperationValidator VALIDATOR = new OperationValidator.AttributeDefinitionOperationValidator(BroadcastGroupDefinition.ATTRIBUTES);
    public static final BroadcastGroupAdd INSTANCE = new BroadcastGroupAdd();

    private BroadcastGroupAdd() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        final ModelNode connectorRefs = resource.getModel().get(BroadcastGroupDefinition.CONNECTOR_REFS.getName());
        if (connectorRefs.isDefined()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    BroadcastGroupDefinition.validateConnectors(context, operation, connectorRefs);
                    context.stepCompleted();
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        VALIDATOR.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            context.reloadRequired();
        } else {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            ServiceTarget target = context.getServiceTarget();
            if (!model.hasDefined(CommonAttributes.JGROUPS_STACK.getName())) {
                if (model.hasDefined(RemoteTransportDefinition.SOCKET_BINDING.getName())) {
                    GroupBindingService bindingService = new GroupBindingService();
                    target.addService(GroupBindingService.getBroadcastBaseServiceName(hqServiceName).append(new String[]{name}), (Service)bindingService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get("socket-binding").asString()}), SocketBinding.class, bindingService.getBindingRef()).install();
                } else {
                    ModelNode localAddrNode = CommonAttributes.LOCAL_BIND_ADDRESS.resolveModelAttribute(context, model);
                    String localAddress = localAddrNode.isDefined() ? localAddrNode.asString() : null;
                    String groupAddress = CommonAttributes.GROUP_ADDRESS.resolveModelAttribute(context, model).asString();
                    int groupPort = CommonAttributes.GROUP_PORT.resolveModelAttribute(context, model).asInt();
                    int localBindPort = CommonAttributes.LOCAL_BIND_PORT.resolveModelAttribute(context, model).asInt();
                    try {
                        InetAddress inet = localAddress != null ? InetAddress.getByName(localAddress) : InetAddressUtil.getLocalHost();
                        NetworkInterface intf = NetworkInterface.getByInetAddress(inet);
                        NetworkInterfaceBinding b = new NetworkInterfaceBinding(Collections.singleton(intf), inet);
                        InetAddress group = InetAddress.getByName(groupAddress);
                        SocketBinding socketBinding = new SocketBinding(name, localBindPort, false, group, groupPort, b, null, null);
                        GroupBindingService bindingService = new GroupBindingService();
                        target.addService(GroupBindingService.getBroadcastBaseServiceName(hqServiceName).append(new String[]{name}), (Service)bindingService).addInjectionValue(bindingService.getBindingRef(), (Value)new ImmediateValue((Object)socketBinding)).install();
                    }
                    catch (Exception e) {
                        throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
                    }
                }
            }
        }
    }

    static void addBroadcastGroupConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("broadcast-group")) {
            List configs = configuration.getBroadcastGroupConfigurations();
            Set<String> connectors = configuration.getConnectorConfigurations().keySet();
            for (Property prop : model.get("broadcast-group").asPropertyList()) {
                configs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(context, connectors, prop.getName(), prop.getValue()));
            }
        }
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(OperationContext context, Set<String> connectors, String name, ModelNode model) throws OperationFailedException {
        long broadcastPeriod = BroadcastGroupDefinition.BROADCAST_PERIOD.resolveModelAttribute(context, model).asLong();
        ArrayList<String> connectorRefs = new ArrayList<String>();
        if (model.hasDefined("connectors")) {
            for (ModelNode ref : model.get("connectors").asList()) {
                String refName = ref.asString();
                if (!connectors.contains(refName)) {
                    throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(name, refName, connectors);
                }
                connectorRefs.add(refName);
            }
        }
        return new BroadcastGroupConfiguration(name, broadcastPeriod, connectorRefs, null);
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, BroadcastGroupConfiguration config, SocketBinding socketBinding) throws Exception {
        String localAddress = socketBinding.getAddress().getHostAddress();
        String groupAddress = socketBinding.getMulticastAddress().getHostAddress();
        int localPort = socketBinding.getPort();
        int groupPort = socketBinding.getMulticastPort();
        long broadcastPeriod = config.getBroadcastPeriod();
        List connectorRefs = config.getConnectorInfos();
        UDPBroadcastGroupConfiguration endpointFactoryConfiguration = new UDPBroadcastGroupConfiguration(groupAddress, groupPort, localAddress, localPort);
        return new BroadcastGroupConfiguration(name, broadcastPeriod, connectorRefs, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, BroadcastGroupConfiguration config, JChannel channel, String channelName) throws Exception {
        long broadcastPeriod = config.getBroadcastPeriod();
        List connectorRefs = config.getConnectorInfos();
        JGroupsBroadcastGroupConfiguration endpointFactoryConfiguration = new JGroupsBroadcastGroupConfiguration(channel, channelName);
        return new BroadcastGroupConfiguration(name, broadcastPeriod, connectorRefs, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
    }
}

